/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.DamageSource;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet11PlayerPosition;
import net.minecraft.src.Packet12PlayerLook;
import net.minecraft.src.Packet13PlayerLookMove;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet19EntityAction;
import net.minecraft.src.Packet202PlayerAbilities;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.Session;
import net.minecraft.src.StatBase;
import net.minecraft.src.World;

public class EntityClientPlayerMP
extends EntityPlayerSP {
    public NetClientHandler sendQueue;
    private int inventoryUpdateTickCounter = 0;
    private double oldPosX;
    private double oldMinY;
    private double oldPosY;
    private double oldPosZ;
    private float oldRotationYaw;
    private float oldRotationPitch;
    private boolean wasOnGround = false;
    private boolean shouldStopSneaking = false;
    private boolean wasSneaking = false;
    private int timeSinceMoved = 0;
    private boolean hasSetHealth = false;

    public EntityClientPlayerMP(Minecraft par1Minecraft, World par2World, Session par3Session, NetClientHandler par4NetClientHandler) {
        super(par1Minecraft, par2World, par3Session, 0);
        this.sendQueue = par4NetClientHandler;
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        return false;
    }

    @Override
    public void heal(int i) {
    }

    @Override
    public void onUpdate() {
        if (!this.worldObj.blockExists(MathHelper.floor_double(this.posX), 0, MathHelper.floor_double(this.posZ))) {
            return;
        }
        super.onUpdate();
        this.sendMotionUpdates();
    }

    public void sendMotionUpdates() {
        boolean flag3;
        boolean flag1;
        boolean flag;
        if (this.inventoryUpdateTickCounter++ == 20) {
            this.inventoryUpdateTickCounter = 0;
        }
        if ((flag = this.isSprinting()) != this.wasSneaking) {
            if (flag) {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 4));
            } else {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 5));
            }
            this.wasSneaking = flag;
        }
        if ((flag1 = this.isSneaking()) != this.shouldStopSneaking) {
            if (flag1) {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 1));
            } else {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 2));
            }
            this.shouldStopSneaking = flag1;
        }
        double d = this.posX - this.oldPosX;
        double d1 = this.boundingBox.minY - this.oldMinY;
        double d2 = this.posY - this.oldPosY;
        double d3 = this.posZ - this.oldPosZ;
        double d4 = this.rotationYaw - this.oldRotationYaw;
        double d5 = this.rotationPitch - this.oldRotationPitch;
        boolean flag2 = d1 != 0.0 || d2 != 0.0 || d != 0.0 || d3 != 0.0;
        boolean bl = flag3 = d4 != 0.0 || d5 != 0.0;
        if (this.ridingEntity != null) {
            if (flag3) {
                this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.motionX, -999.0, -999.0, this.motionZ, this.onGround));
            } else {
                this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.motionX, -999.0, -999.0, this.motionZ, this.rotationYaw, this.rotationPitch, this.onGround));
            }
            flag2 = false;
        } else if (flag2 && flag3) {
            this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.posX, this.boundingBox.minY, this.posY, this.posZ, this.rotationYaw, this.rotationPitch, this.onGround));
            this.timeSinceMoved = 0;
        } else if (flag2) {
            this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.posX, this.boundingBox.minY, this.posY, this.posZ, this.onGround));
            this.timeSinceMoved = 0;
        } else if (flag3) {
            this.sendQueue.addToSendQueue(new Packet12PlayerLook(this.rotationYaw, this.rotationPitch, this.onGround));
            this.timeSinceMoved = 0;
        } else {
            this.sendQueue.addToSendQueue(new Packet10Flying(this.onGround));
            this.timeSinceMoved = this.wasOnGround != this.onGround || this.timeSinceMoved > 200 ? 0 : ++this.timeSinceMoved;
        }
        this.wasOnGround = this.onGround;
        if (flag2) {
            this.oldPosX = this.posX;
            this.oldMinY = this.boundingBox.minY;
            this.oldPosY = this.posY;
            this.oldPosZ = this.posZ;
        }
        if (flag3) {
            this.oldRotationYaw = this.rotationYaw;
            this.oldRotationPitch = this.rotationPitch;
        }
    }

    @Override
    public EntityItem dropOneItem() {
        this.sendQueue.addToSendQueue(new Packet14BlockDig(4, 0, 0, 0, 0));
        return null;
    }

    @Override
    protected void joinEntityItemWithWorld(EntityItem entityitem) {
    }

    @Override
    public void sendChatMessage(String par1Str) {
        if (this.mc.ingameGUI.getSentMessageList().size() == 0 || !((String)this.mc.ingameGUI.getSentMessageList().get(this.mc.ingameGUI.getSentMessageList().size() - 1)).equals(par1Str)) {
            this.mc.ingameGUI.getSentMessageList().add(par1Str);
        }
        this.sendQueue.addToSendQueue(new Packet3Chat(par1Str));
    }

    @Override
    public void swingItem() {
        super.swingItem();
        this.sendQueue.addToSendQueue(new Packet18Animation(this, 1));
    }

    @Override
    public void respawnPlayer() {
        this.sendQueue.addToSendQueue(new Packet9Respawn(this.dimension, (byte)this.worldObj.difficultySetting, this.worldObj.getWorldInfo().getTerrainType(), this.worldObj.getHeight(), 0));
    }

    @Override
    protected void damageEntity(DamageSource par1DamageSource, int par2) {
        this.setEntityHealth(this.getHealth() - par2);
    }

    @Override
    public void closeScreen() {
        this.sendQueue.addToSendQueue(new Packet101CloseWindow(this.craftingInventory.windowId));
        this.inventory.setItemStack(null);
        super.closeScreen();
    }

    @Override
    public void setHealth(int par1) {
        if (this.hasSetHealth) {
            super.setHealth(par1);
        } else {
            this.setEntityHealth(par1);
            this.hasSetHealth = true;
        }
    }

    @Override
    public void addStat(StatBase par1StatBase, int par2) {
        if (par1StatBase == null) {
            return;
        }
        if (par1StatBase.isIndependent) {
            super.addStat(par1StatBase, par2);
        }
    }

    public void incrementStat(StatBase par1StatBase, int par2) {
        if (par1StatBase == null) {
            return;
        }
        if (!par1StatBase.isIndependent) {
            super.addStat(par1StatBase, par2);
        }
    }

    @Override
    public void func_50009_aI() {
        this.sendQueue.addToSendQueue(new Packet202PlayerAbilities(this.capabilities));
    }
}

