/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockEndPortal;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDragonBase;
import net.minecraft.src.EntityDragonPart;
import net.minecraft.src.EntityEnderCrystal;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityDragon
extends EntityDragonBase {
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public EntityDragonPart[] dragonPartArray;
    public EntityDragonPart dragonPartHead = new EntityDragonPart(this, "head", 6.0f, 6.0f);
    public EntityDragonPart dragonPartBody = new EntityDragonPart(this, "body", 8.0f, 8.0f);
    public EntityDragonPart dragonPartTail1 = new EntityDragonPart(this, "tail", 4.0f, 4.0f);
    public EntityDragonPart dragonPartTail2 = new EntityDragonPart(this, "tail", 4.0f, 4.0f);
    public EntityDragonPart dragonPartTail3 = new EntityDragonPart(this, "tail", 4.0f, 4.0f);
    public EntityDragonPart dragonPartWing1 = new EntityDragonPart(this, "wing", 4.0f, 4.0f);
    public EntityDragonPart dragonPartWing2 = new EntityDragonPart(this, "wing", 4.0f, 4.0f);
    public float prevAnimTime = 0.0f;
    public float animTime = 0.0f;
    public boolean forceNewTarget = false;
    public boolean slowed = false;
    private Entity target;
    public int deathTicks = 0;
    public EntityEnderCrystal healingEnderCrystal = null;

    public EntityDragon(World par1World) {
        super(par1World);
        this.dragonPartArray = new EntityDragonPart[]{this.dragonPartHead, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.maxHealth = 200;
        this.setEntityHealth(this.maxHealth);
        this.texture = "/mob/enderdragon/ender.png";
        this.setSize(16.0f, 8.0f);
        this.noClip = true;
        this.isImmuneToFire = true;
        this.targetY = 100.0;
        this.ignoreFrustumCheck = true;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Integer(this.maxHealth));
    }

    public double[] getMovementOffsets(int par1, float par2) {
        double d1;
        if (this.health <= 0) {
            par2 = 0.0f;
        }
        par2 = 1.0f - par2;
        int i = this.ringBufferIndex - par1 * 1 & 0x3F;
        int j = this.ringBufferIndex - par1 * 1 - 1 & 0x3F;
        double[] ad = new double[3];
        double d = this.ringBuffer[i][0];
        for (d1 = this.ringBuffer[j][0] - d; d1 < -180.0; d1 += 360.0) {
        }
        while (d1 >= 180.0) {
            d1 -= 360.0;
        }
        ad[0] = d + d1 * (double)par2;
        d = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d;
        ad[1] = d + d1 * (double)par2;
        ad[2] = this.ringBuffer[i][2] + (this.ringBuffer[j][2] - this.ringBuffer[i][2]) * (double)par2;
        return ad;
    }

    @Override
    public void onLivingUpdate() {
        this.prevAnimTime = this.animTime;
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(16, this.health);
        }
        if (this.health <= 0) {
            float f = (this.rand.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 4.0f;
            float f4 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            this.worldObj.spawnParticle("largeexplode", this.posX + (double)f, this.posY + 2.0 + (double)f2, this.posZ + (double)f4, 0.0, 0.0, 0.0);
            return;
        }
        this.updateDragonEnderCrystal();
        float f1 = 0.2f / (MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ) * 10.0f + 1.0f);
        this.animTime = this.slowed ? (this.animTime += f1 * 0.5f) : (this.animTime += (f1 *= (float)Math.pow(2.0, this.motionY)));
        while (this.rotationYaw >= 180.0f) {
            this.rotationYaw -= 360.0f;
        }
        while (this.rotationYaw < -180.0f) {
            this.rotationYaw += 360.0f;
        }
        if (this.ringBufferIndex < 0) {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i][0] = this.rotationYaw;
                this.ringBuffer[i][1] = this.posY;
            }
        }
        if (++this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex][0] = this.rotationYaw;
        this.ringBuffer[this.ringBufferIndex][1] = this.posY;
        if (this.worldObj.isRemote) {
            if (this.newPosRotationIncrements > 0) {
                double d6;
                double d = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
                double d2 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
                double d4 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
                for (d6 = this.newRotationYaw - (double)this.rotationYaw; d6 < -180.0; d6 += 360.0) {
                }
                while (d6 >= 180.0) {
                    d6 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + d6 / (double)this.newPosRotationIncrements);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
                --this.newPosRotationIncrements;
                this.setPosition(d, d2, d4);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
        } else {
            double d11;
            float f10;
            double d1 = this.targetX - this.posX;
            double d3 = this.targetY - this.posY;
            double d5 = this.targetZ - this.posZ;
            double d7 = d1 * d1 + d3 * d3 + d5 * d5;
            if (this.target != null) {
                this.targetX = this.target.posX;
                this.targetZ = this.target.posZ;
                double d8 = this.targetX - this.posX;
                double d10 = this.targetZ - this.posZ;
                double d12 = Math.sqrt(d8 * d8 + d10 * d10);
                double d13 = (double)0.4f + d12 / 80.0 - 1.0;
                if (d13 > 10.0) {
                    d13 = 10.0;
                }
                this.targetY = this.target.boundingBox.minY + d13;
            } else {
                this.targetX += this.rand.nextGaussian() * 2.0;
                this.targetZ += this.rand.nextGaussian() * 2.0;
            }
            if (this.forceNewTarget || d7 < 100.0 || d7 > 22500.0 || this.isCollidedHorizontally || this.isCollidedVertically) {
                this.setNewTarget();
            }
            if ((d3 /= (double)MathHelper.sqrt_double(d1 * d1 + d5 * d5)) < (double)(-(f10 = 0.6f))) {
                d3 = -f10;
            }
            if (d3 > (double)f10) {
                d3 = f10;
            }
            this.motionY += d3 * (double)0.1f;
            while (this.rotationYaw < -180.0f) {
                this.rotationYaw += 360.0f;
            }
            while (this.rotationYaw >= 180.0f) {
                this.rotationYaw -= 360.0f;
            }
            double d9 = 180.0 - Math.atan2(d1, d5) * 180.0 / Math.PI;
            for (d11 = d9 - (double)this.rotationYaw; d11 < -180.0; d11 += 360.0) {
            }
            while (d11 >= 180.0) {
                d11 -= 360.0;
            }
            if (d11 > 50.0) {
                d11 = 50.0;
            }
            if (d11 < -50.0) {
                d11 = -50.0;
            }
            Vec3D vec3d = Vec3D.createVector(this.targetX - this.posX, this.targetY - this.posY, this.targetZ - this.posZ).normalize();
            Vec3D vec3d1 = Vec3D.createVector(MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f), this.motionY, -MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f)).normalize();
            float f18 = (float)(vec3d1.dotProduct(vec3d) + 0.5) / 1.5f;
            if (f18 < 0.0f) {
                f18 = 0.0f;
            }
            this.randomYawVelocity *= 0.8f;
            float f19 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ) * 1.0f + 1.0f;
            double d14 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ) * 1.0 + 1.0;
            if (d14 > 40.0) {
                d14 = 40.0;
            }
            this.randomYawVelocity = (float)((double)this.randomYawVelocity + d11 * ((double)0.7f / d14 / (double)f19));
            this.rotationYaw += this.randomYawVelocity * 0.1f;
            float f20 = (float)(2.0 / (d14 + 1.0));
            float f21 = 0.06f;
            this.moveFlying(0.0f, -1.0f, f21 * (f18 * f20 + (1.0f - f20)));
            if (this.slowed) {
                this.moveEntity(this.motionX * (double)0.8f, this.motionY * (double)0.8f, this.motionZ * (double)0.8f);
            } else {
                this.moveEntity(this.motionX, this.motionY, this.motionZ);
            }
            Vec3D vec3d2 = Vec3D.createVector(this.motionX, this.motionY, this.motionZ).normalize();
            float f22 = (float)(vec3d2.dotProduct(vec3d1) + 1.0) / 2.0f;
            f22 = 0.8f + 0.15f * f22;
            this.motionX *= (double)f22;
            this.motionZ *= (double)f22;
            this.motionY *= (double)0.91f;
        }
        this.renderYawOffset = this.rotationYaw;
        this.dragonPartHead.height = 3.0f;
        this.dragonPartHead.width = 3.0f;
        this.dragonPartTail1.height = 2.0f;
        this.dragonPartTail1.width = 2.0f;
        this.dragonPartTail2.height = 2.0f;
        this.dragonPartTail2.width = 2.0f;
        this.dragonPartTail3.height = 2.0f;
        this.dragonPartTail3.width = 2.0f;
        this.dragonPartBody.height = 3.0f;
        this.dragonPartBody.width = 5.0f;
        this.dragonPartWing1.height = 2.0f;
        this.dragonPartWing1.width = 4.0f;
        this.dragonPartWing2.height = 3.0f;
        this.dragonPartWing2.width = 4.0f;
        float f3 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
        float f5 = MathHelper.cos(f3);
        float f6 = -MathHelper.sin(f3);
        float f7 = this.rotationYaw * (float)Math.PI / 180.0f;
        float f8 = MathHelper.sin(f7);
        float f9 = MathHelper.cos(f7);
        this.dragonPartBody.onUpdate();
        this.dragonPartBody.setLocationAndAngles(this.posX + (double)(f8 * 0.5f), this.posY, this.posZ - (double)(f9 * 0.5f), 0.0f, 0.0f);
        this.dragonPartWing1.onUpdate();
        this.dragonPartWing1.setLocationAndAngles(this.posX + (double)(f9 * 4.5f), this.posY + 2.0, this.posZ + (double)(f8 * 4.5f), 0.0f, 0.0f);
        this.dragonPartWing2.onUpdate();
        this.dragonPartWing2.setLocationAndAngles(this.posX - (double)(f9 * 4.5f), this.posY + 2.0, this.posZ - (double)(f8 * 4.5f), 0.0f, 0.0f);
        if (!this.worldObj.isRemote) {
            this.func_41007_az();
        }
        if (!this.worldObj.isRemote && this.maxHurtTime == 0) {
            this.collideWithEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartWing1.boundingBox.expand(4.0, 2.0, 4.0).offset(0.0, -2.0, 0.0)));
            this.collideWithEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartWing2.boundingBox.expand(4.0, 2.0, 4.0).offset(0.0, -2.0, 0.0)));
            this.attackEntitiesInList(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartHead.boundingBox.expand(1.0, 1.0, 1.0)));
        }
        double[] ad = this.getMovementOffsets(5, 1.0f);
        double[] ad1 = this.getMovementOffsets(0, 1.0f);
        float f11 = MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f - this.randomYawVelocity * 0.01f);
        float f12 = MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f - this.randomYawVelocity * 0.01f);
        this.dragonPartHead.onUpdate();
        this.dragonPartHead.setLocationAndAngles(this.posX + (double)(f11 * 5.5f * f5), this.posY + (ad1[1] - ad[1]) * 1.0 + (double)(f6 * 5.5f), this.posZ - (double)(f12 * 5.5f * f5), 0.0f, 0.0f);
        for (int j = 0; j < 3; ++j) {
            EntityDragonPart entitydragonpart = null;
            if (j == 0) {
                entitydragonpart = this.dragonPartTail1;
            }
            if (j == 1) {
                entitydragonpart = this.dragonPartTail2;
            }
            if (j == 2) {
                entitydragonpart = this.dragonPartTail3;
            }
            double[] ad2 = this.getMovementOffsets(12 + j * 2, 1.0f);
            float f13 = this.rotationYaw * (float)Math.PI / 180.0f + this.simplifyAngle(ad2[0] - ad[0]) * (float)Math.PI / 180.0f * 1.0f;
            float f14 = MathHelper.sin(f13);
            float f15 = MathHelper.cos(f13);
            float f16 = 1.5f;
            float f17 = (float)(j + 1) * 2.0f;
            entitydragonpart.onUpdate();
            entitydragonpart.setLocationAndAngles(this.posX - (double)((f8 * f16 + f14 * f17) * f5), this.posY + (ad2[1] - ad[1]) * 1.0 - (double)((f17 + f16) * f6) + 1.5, this.posZ + (double)((f9 * f16 + f15 * f17) * f5), 0.0f, 0.0f);
        }
        if (!this.worldObj.isRemote) {
            this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.boundingBox) | this.destroyBlocksInAABB(this.dragonPartBody.boundingBox);
        }
    }

    private void updateDragonEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.isDead) {
                if (!this.worldObj.isRemote) {
                    this.attackEntityFromPart(this.dragonPartHead, DamageSource.explosion, 10);
                }
                this.healingEnderCrystal = null;
            } else if (this.ticksExisted % 10 == 0 && this.health < this.maxHealth) {
                ++this.health;
            }
        }
        if (this.rand.nextInt(10) == 0) {
            float f = 32.0f;
            List list = this.worldObj.getEntitiesWithinAABB(EntityEnderCrystal.class, this.boundingBox.expand(f, f, f));
            EntityEnderCrystal entityendercrystal = null;
            double d = Double.MAX_VALUE;
            for (Entity entity : list) {
                double d1 = entity.getDistanceSqToEntity(this);
                if (!(d1 < d)) continue;
                d = d1;
                entityendercrystal = (EntityEnderCrystal)entity;
            }
            this.healingEnderCrystal = entityendercrystal;
        }
    }

    private void func_41007_az() {
    }

    private void collideWithEntities(List par1List) {
        double d = (this.dragonPartBody.boundingBox.minX + this.dragonPartBody.boundingBox.maxX) / 2.0;
        double d1 = (this.dragonPartBody.boundingBox.minZ + this.dragonPartBody.boundingBox.maxZ) / 2.0;
        for (Entity entity : par1List) {
            if (!(entity instanceof EntityLiving)) continue;
            double d2 = entity.posX - d;
            double d3 = entity.posZ - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.addVelocity(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
        }
    }

    private void attackEntitiesInList(List par1List) {
        for (int i = 0; i < par1List.size(); ++i) {
            Entity entity = (Entity)par1List.get(i);
            if (!(entity instanceof EntityLiving)) continue;
            entity.attackEntityFrom(DamageSource.causeMobDamage(this), 10);
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.rand.nextInt(2) == 0 && this.worldObj.playerEntities.size() > 0) {
            this.target = (Entity)this.worldObj.playerEntities.get(this.rand.nextInt(this.worldObj.playerEntities.size()));
        } else {
            double d2;
            double d1;
            double d;
            boolean flag = false;
            do {
                this.targetX = 0.0;
                this.targetY = 70.0f + this.rand.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.rand.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.rand.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d = this.posX - this.targetX) * d + (d1 = this.posY - this.targetY) * d1 + (d2 = this.posZ - this.targetZ) * d2 > 100.0));
            this.target = null;
        }
    }

    private float simplifyAngle(double par1) {
        while (par1 >= 180.0) {
            par1 -= 360.0;
        }
        while (par1 < -180.0) {
            par1 += 360.0;
        }
        return (float)par1;
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int i = MathHelper.floor_double(par1AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par1AxisAlignedBB.minY);
        int k = MathHelper.floor_double(par1AxisAlignedBB.minZ);
        int l = MathHelper.floor_double(par1AxisAlignedBB.maxX);
        int i1 = MathHelper.floor_double(par1AxisAlignedBB.maxY);
        int j1 = MathHelper.floor_double(par1AxisAlignedBB.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    int j2 = this.worldObj.getBlockId(k1, l1, i2);
                    if (j2 == 0) continue;
                    if (j2 == Block.obsidian.blockID || j2 == Block.whiteStone.blockID || j2 == Block.bedrock.blockID) {
                        flag = true;
                        continue;
                    }
                    flag1 = true;
                    this.worldObj.setBlockWithNotify(k1, l1, i2, 0);
                }
            }
        }
        if (flag1) {
            double d = par1AxisAlignedBB.minX + (par1AxisAlignedBB.maxX - par1AxisAlignedBB.minX) * (double)this.rand.nextFloat();
            double d1 = par1AxisAlignedBB.minY + (par1AxisAlignedBB.maxY - par1AxisAlignedBB.minY) * (double)this.rand.nextFloat();
            double d2 = par1AxisAlignedBB.minZ + (par1AxisAlignedBB.maxZ - par1AxisAlignedBB.minZ) * (double)this.rand.nextFloat();
            this.worldObj.spawnParticle("largeexplode", d, d1, d2, 0.0, 0.0, 0.0);
        }
        return flag;
    }

    @Override
    public boolean attackEntityFromPart(EntityDragonPart par1EntityDragonPart, DamageSource par2DamageSource, int par3) {
        if (par1EntityDragonPart != this.dragonPartHead) {
            par3 = par3 / 4 + 1;
        }
        float f = this.rotationYaw * (float)Math.PI / 180.0f;
        float f1 = MathHelper.sin(f);
        float f2 = MathHelper.cos(f);
        this.targetX = this.posX + (double)(f1 * 5.0f) + (double)((this.rand.nextFloat() - 0.5f) * 2.0f);
        this.targetY = this.posY + (double)(this.rand.nextFloat() * 3.0f) + 1.0;
        this.targetZ = this.posZ - (double)(f2 * 5.0f) + (double)((this.rand.nextFloat() - 0.5f) * 2.0f);
        this.target = null;
        if (par2DamageSource.getEntity() instanceof EntityPlayer || par2DamageSource == DamageSource.explosion) {
            this.superAttackFrom(par2DamageSource, par3);
        }
        return true;
    }

    @Override
    protected void onDeathUpdate() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            this.worldObj.spawnParticle("hugeexplosion", this.posX + (double)f, this.posY + 2.0 + (double)f1, this.posZ + (double)f2, 0.0, 0.0, 0.0);
        }
        if (!this.worldObj.isRemote && this.deathTicks > 150 && this.deathTicks % 5 == 0) {
            int k;
            for (int i = 1000; i > 0; i -= k) {
                k = EntityXPOrb.getXPSplit(i);
                this.worldObj.spawnEntityInWorld(new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, k));
            }
        }
        this.moveEntity(0.0, 0.1f, 0.0);
        this.renderYawOffset = this.rotationYaw += 20.0f;
        if (this.deathTicks == 200) {
            int l;
            for (int j = 10000; j > 0; j -= l) {
                l = EntityXPOrb.getXPSplit(j);
                this.worldObj.spawnEntityInWorld(new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, l));
            }
            this.createEnderPortal(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posZ));
            this.onEntityDeath();
            this.setDead();
        }
    }

    private void createEnderPortal(int par1, int par2) {
        int byte0 = 64;
        BlockEndPortal.bossDefeated = true;
        int i = 4;
        for (int j = byte0 - 1; j <= byte0 + 32; ++j) {
            for (int k = par1 - i; k <= par1 + i; ++k) {
                for (int l = par2 - i; l <= par2 + i; ++l) {
                    double d = k - par1;
                    double d1 = l - par2;
                    double d2 = MathHelper.sqrt_double(d * d + d1 * d1);
                    if (d2 > (double)i - 0.5) continue;
                    if (j < byte0) {
                        if (!(d2 <= (double)(i - 1) - 0.5)) continue;
                        this.worldObj.setBlockWithNotify(k, j, l, Block.bedrock.blockID);
                        continue;
                    }
                    if (j > byte0) {
                        this.worldObj.setBlockWithNotify(k, j, l, 0);
                        continue;
                    }
                    if (d2 > (double)(i - 1) - 0.5) {
                        this.worldObj.setBlockWithNotify(k, j, l, Block.bedrock.blockID);
                        continue;
                    }
                    this.worldObj.setBlockWithNotify(k, j, l, Block.endPortal.blockID);
                }
            }
        }
        this.worldObj.setBlockWithNotify(par1, byte0 + 0, par2, Block.bedrock.blockID);
        this.worldObj.setBlockWithNotify(par1, byte0 + 1, par2, Block.bedrock.blockID);
        this.worldObj.setBlockWithNotify(par1, byte0 + 2, par2, Block.bedrock.blockID);
        this.worldObj.setBlockWithNotify(par1 - 1, byte0 + 2, par2, Block.torchWood.blockID);
        this.worldObj.setBlockWithNotify(par1 + 1, byte0 + 2, par2, Block.torchWood.blockID);
        this.worldObj.setBlockWithNotify(par1, byte0 + 2, par2 - 1, Block.torchWood.blockID);
        this.worldObj.setBlockWithNotify(par1, byte0 + 2, par2 + 1, Block.torchWood.blockID);
        this.worldObj.setBlockWithNotify(par1, byte0 + 3, par2, Block.bedrock.blockID);
        this.worldObj.setBlockWithNotify(par1, byte0 + 4, par2, Block.dragonEgg.blockID);
        BlockEndPortal.bossDefeated = false;
    }

    @Override
    protected void despawnEntity() {
    }

    @Override
    public Entity[] getParts() {
        return this.dragonPartArray;
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    public int getDragonHealth() {
        return this.dataWatcher.getWatchableObjectInt(16);
    }
}

