/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAIAttackOnCollide;
import net.minecraft.src.EntityAIDefendVillage;
import net.minecraft.src.EntityAIHurtByTarget;
import net.minecraft.src.EntityAILookAtVillager;
import net.minecraft.src.EntityAILookIdle;
import net.minecraft.src.EntityAIMoveThroughVillage;
import net.minecraft.src.EntityAIMoveTowardsTarget;
import net.minecraft.src.EntityAIMoveTwardsRestriction;
import net.minecraft.src.EntityAINearestAttackableTarget;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityGolem;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Village;
import net.minecraft.src.World;

public class EntityIronGolem
extends EntityGolem {
    private int field_48119_b = 0;
    Village villageObj = null;
    private int field_48120_c;
    private int field_48118_d;

    public EntityIronGolem(World par1World) {
        super(par1World);
        this.texture = "/mob/villager_golem.png";
        this.setSize(1.4f, 2.9f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, new EntityAIAttackOnCollide(this, 0.25f, true));
        this.tasks.addTask(2, new EntityAIMoveTowardsTarget(this, 0.22f, 32.0f));
        this.tasks.addTask(3, new EntityAIMoveThroughVillage(this, 0.16f, true));
        this.tasks.addTask(4, new EntityAIMoveTwardsRestriction(this, 0.16f));
        this.tasks.addTask(5, new EntityAILookAtVillager(this));
        this.tasks.addTask(6, new EntityAIWander(this, 0.16f));
        this.tasks.addTask(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIDefendVillage(this));
        this.targetTasks.addTask(2, new EntityAIHurtByTarget(this, false));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget(this, EntityMob.class, 16.0f, 0, false, true));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
    }

    @Override
    public boolean isAIEnabled() {
        return true;
    }

    @Override
    protected void updateAITick() {
        if (--this.field_48119_b <= 0) {
            this.field_48119_b = 70 + this.rand.nextInt(50);
            this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ), 32);
            if (this.villageObj == null) {
                this.detachHome();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.getCenter();
                this.setHomeArea(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, this.villageObj.getVillageRadius());
            }
        }
        super.updateAITick();
    }

    @Override
    public int getMaxHealth() {
        return 100;
    }

    @Override
    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    @Override
    public void onLivingUpdate() {
        int k;
        int j;
        int i;
        int l;
        super.onLivingUpdate();
        if (this.field_48120_c > 0) {
            --this.field_48120_c;
        }
        if (this.field_48118_d > 0) {
            --this.field_48118_d;
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > 2.500000277905201E-7 && this.rand.nextInt(5) == 0 && (l = this.worldObj.getBlockId(i = MathHelper.floor_double(this.posX), j = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), k = MathHelper.floor_double(this.posZ))) > 0) {
            this.worldObj.spawnParticle("tilecrack_" + l, this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.boundingBox.minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
        }
    }

    @Override
    public boolean func_48100_a(Class par1Class) {
        if (this.func_48112_E_() && EntityPlayer.class.isAssignableFrom(par1Class)) {
            return false;
        }
        return super.func_48100_a(par1Class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("PlayerCreated", this.func_48112_E_());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.func_48115_b(par1NBTTagCompound.getBoolean("PlayerCreated"));
    }

    @Override
    public boolean attackEntityAsMob(Entity par1Entity) {
        this.field_48120_c = 10;
        this.worldObj.setEntityState(this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage(this), 7 + this.rand.nextInt(15));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.worldObj.playSoundAtEntity(this, "mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @Override
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.field_48120_c = 10;
            this.worldObj.playSoundAtEntity(this, "mob.irongolem.throw", 1.0f, 1.0f);
        } else if (par1 == 11) {
            this.field_48118_d = 400;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public Village getVillage() {
        return this.villageObj;
    }

    public int func_48114_ab() {
        return this.field_48120_c;
    }

    public void func_48116_a(boolean par1) {
        this.field_48118_d = par1 ? 400 : 0;
        this.worldObj.setEntityState(this, (byte)11);
    }

    @Override
    protected String getLivingSound() {
        return "none";
    }

    @Override
    protected String getHurtSound() {
        return "mob.irongolem.hit";
    }

    @Override
    protected String getDeathSound() {
        return "mob.irongolem.death";
    }

    @Override
    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.worldObj.playSoundAtEntity(this, "mob.irongolem.walk", 1.0f, 1.0f);
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.rand.nextInt(3);
        for (int j = 0; j < i; ++j) {
            this.dropItem(Block.plantRed.blockID, 1);
        }
        int k = 3 + this.rand.nextInt(3);
        for (int l = 0; l < k; ++l) {
            this.dropItem(Item.ingotIron.shiftedIndex, 1);
        }
    }

    public int func_48117_D_() {
        return this.field_48118_d;
    }

    public boolean func_48112_E_() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void func_48115_b(boolean par1) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 1));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFE));
        }
    }
}

