/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityWeatherEffect;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityLightningBolt
extends EntityWeatherEffect {
    private int lightningState;
    public long boltVertex = 0L;
    private int boltLivingTime;

    public EntityLightningBolt(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.setLocationAndAngles(par2, par4, par6, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.rand.nextLong();
        this.boltLivingTime = this.rand.nextInt(3) + 1;
        if (par1World.difficultySetting >= 2 && par1World.doChunksNearChunkExist(MathHelper.floor_double(par2), MathHelper.floor_double(par4), MathHelper.floor_double(par6), 10)) {
            int i1;
            int k;
            int i = MathHelper.floor_double(par2);
            if (par1World.getBlockId(i, k = MathHelper.floor_double(par4), i1 = MathHelper.floor_double(par6)) == 0 && Block.fire.canPlaceBlockAt(par1World, i, k, i1)) {
                par1World.setBlockWithNotify(i, k, i1, Block.fire.blockID);
            }
            for (int j = 0; j < 4; ++j) {
                int k1;
                int j1;
                int l = MathHelper.floor_double(par2) + this.rand.nextInt(3) - 1;
                if (par1World.getBlockId(l, j1 = MathHelper.floor_double(par4) + this.rand.nextInt(3) - 1, k1 = MathHelper.floor_double(par6) + this.rand.nextInt(3) - 1) != 0 || !Block.fire.canPlaceBlockAt(par1World, l, j1, k1)) continue;
                par1World.setBlockWithNotify(l, j1, k1, Block.fire.blockID);
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.lightningState == 2) {
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "ambient.weather.thunder", 10000.0f, 0.8f + this.rand.nextFloat() * 0.2f);
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "random.explode", 2.0f, 0.5f + this.rand.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.setDead();
            } else if (this.lightningState < -this.rand.nextInt(10)) {
                int k;
                int j;
                int i;
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.rand.nextLong();
                if (this.worldObj.doChunksNearChunkExist(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ), 10) && this.worldObj.getBlockId(i = MathHelper.floor_double(this.posX), j = MathHelper.floor_double(this.posY), k = MathHelper.floor_double(this.posZ)) == 0 && Block.fire.canPlaceBlockAt(this.worldObj, i, j, k)) {
                    this.worldObj.setBlockWithNotify(i, j, k, Block.fire.blockID);
                }
            }
        }
        if (this.lightningState >= 0) {
            double d = 3.0;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, AxisAlignedBB.getBoundingBoxFromPool(this.posX - d, this.posY - d, this.posZ - d, this.posX + d, this.posY + 6.0 + d, this.posZ + d));
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                entity.onStruckByLightning(this);
            }
            this.worldObj.lightningFlash = 2;
        }
    }

    @Override
    protected void entityInit() {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public boolean isInRangeToRenderVec3D(Vec3D par1Vec3D) {
        return this.lightningState >= 0;
    }
}

