/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;

public class EntityLookHelper {
    private EntityLiving entity;
    private float field_46149_b;
    private float field_46150_c;
    private boolean field_46147_d = false;
    private double posX;
    private double posY;
    private double posZ;

    public EntityLookHelper(EntityLiving par1EntityLiving) {
        this.entity = par1EntityLiving;
    }

    public void setLookPositionWithEntity(Entity par1Entity, float par2, float par3) {
        this.posX = par1Entity.posX;
        this.posY = par1Entity instanceof EntityLiving ? par1Entity.posY + (double)((EntityLiving)par1Entity).getEyeHeight() : (par1Entity.boundingBox.minY + par1Entity.boundingBox.maxY) / 2.0;
        this.posZ = par1Entity.posZ;
        this.field_46149_b = par2;
        this.field_46150_c = par3;
        this.field_46147_d = true;
    }

    public void setLookPosition(double par1, double par3, double par5, float par7, float par8) {
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        this.field_46149_b = par7;
        this.field_46150_c = par8;
        this.field_46147_d = true;
    }

    public void onUpdateLook() {
        float f;
        this.entity.rotationPitch = 0.0f;
        if (this.field_46147_d) {
            this.field_46147_d = false;
            double d = this.posX - this.entity.posX;
            double d1 = this.posY - (this.entity.posY + (double)this.entity.getEyeHeight());
            double d2 = this.posZ - this.entity.posZ;
            double d3 = MathHelper.sqrt_double(d * d + d2 * d2);
            float f1 = (float)(Math.atan2(d2, d) * 180.0 / Math.PI) - 90.0f;
            float f2 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            this.entity.rotationPitch = this.updateRotation(this.entity.rotationPitch, f2, this.field_46150_c);
            this.entity.rotationYawHead = this.updateRotation(this.entity.rotationYawHead, f1, this.field_46149_b);
        } else {
            this.entity.rotationYawHead = this.updateRotation(this.entity.rotationYawHead, this.entity.renderYawOffset, 10.0f);
        }
        for (f = this.entity.rotationYawHead - this.entity.renderYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        if (!this.entity.getNavigator().noPath()) {
            if (f < -75.0f) {
                this.entity.rotationYawHead = this.entity.renderYawOffset - 75.0f;
            }
            if (f > 75.0f) {
                this.entity.rotationYawHead = this.entity.renderYawOffset + 75.0f;
            }
        }
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f > par3) {
            f = par3;
        }
        if (f < -par3) {
            f = -par3;
        }
        return par1 + f;
    }
}

