/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRail;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityIronGolem;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] cargoItems = new ItemStack[36];
    private int fuel = 0;
    private boolean field_856_i = false;
    public int minecartType;
    public double pushX;
    public double pushZ;
    private static final int[][][] field_855_j = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityMinecart(World par1World) {
        super(par1World);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
        this.yOffset = this.height / 2.0f;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(16, new Byte(0));
        this.dataWatcher.addObject(17, new Integer(0));
        this.dataWatcher.addObject(18, new Integer(1));
        this.dataWatcher.addObject(19, new Integer(0));
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity par1Entity) {
        return par1Entity.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    public EntityMinecart(World par1World, double par2, double par4, double par6, int par8) {
        this(par1World);
        this.setPosition(par2, par4 + (double)this.yOffset, par6);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = par2;
        this.prevPosY = par4;
        this.prevPosZ = par6;
        this.minecartType = par8;
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (this.worldObj.isRemote || this.isDead) {
            return true;
        }
        this.func_41029_h(-this.func_41030_m());
        this.func_41028_c(10);
        this.setBeenAttacked();
        this.func_41024_b(this.func_41025_i() + par2 * 10);
        if (this.func_41025_i() > 40) {
            if (this.riddenByEntity != null) {
                this.riddenByEntity.mountEntity(this);
            }
            this.setDead();
            this.dropItemWithOffset(Item.minecartEmpty.shiftedIndex, 1, 0.0f);
            if (this.minecartType == 1) {
                EntityMinecart entityminecart = this;
                for (int i = 0; i < entityminecart.getSizeInventory(); ++i) {
                    ItemStack itemstack = entityminecart.getStackInSlot(i);
                    if (itemstack == null) continue;
                    float f = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.stackSize > 0) {
                        int j = this.rand.nextInt(21) + 10;
                        if (j > itemstack.stackSize) {
                            j = itemstack.stackSize;
                        }
                        itemstack.stackSize -= j;
                        EntityItem entityitem = new EntityItem(this.worldObj, this.posX + (double)f, this.posY + (double)f1, this.posZ + (double)f2, new ItemStack(itemstack.itemID, j, itemstack.getItemDamage()));
                        float f3 = 0.05f;
                        entityitem.motionX = (float)this.rand.nextGaussian() * f3;
                        entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                        entityitem.motionZ = (float)this.rand.nextGaussian() * f3;
                        this.worldObj.spawnEntityInWorld(entityitem);
                    }
                }
                this.dropItemWithOffset(Block.chest.blockID, 1, 0.0f);
            } else if (this.minecartType == 2) {
                this.dropItemWithOffset(Block.stoneOvenIdle.blockID, 1, 0.0f);
            }
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.func_41029_h(-this.func_41030_m());
        this.func_41028_c(10);
        this.func_41024_b(this.func_41025_i() + this.func_41025_i() * 10);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void setDead() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (itemstack == null) continue;
            float f = this.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int j = this.rand.nextInt(21) + 10;
                if (j > itemstack.stackSize) {
                    j = itemstack.stackSize;
                }
                itemstack.stackSize -= j;
                EntityItem entityitem = new EntityItem(this.worldObj, this.posX + (double)f, this.posY + (double)f1, this.posZ + (double)f2, new ItemStack(itemstack.itemID, j, itemstack.getItemDamage()));
                if (itemstack.hasTagCompound()) {
                    entityitem.item.setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                }
                float f3 = 0.05f;
                entityitem.motionX = (float)this.rand.nextGaussian() * f3;
                entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                entityitem.motionZ = (float)this.rand.nextGaussian() * f3;
                this.worldObj.spawnEntityInWorld(entityitem);
            }
        }
        super.setDead();
    }

    @Override
    public void onUpdate() {
        double d8;
        int k;
        int j;
        if (this.func_41023_l() > 0) {
            this.func_41028_c(this.func_41023_l() - 1);
        }
        if (this.func_41025_i() > 0) {
            this.func_41024_b(this.func_41025_i() - 1);
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (this.isMinecartPowered() && this.rand.nextInt(4) == 0) {
            this.worldObj.spawnParticle("largesmoke", this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0);
        }
        if (this.worldObj.isRemote) {
            if (this.turnProgress > 0) {
                double d5;
                double d = this.posX + (this.minecartX - this.posX) / (double)this.turnProgress;
                double d1 = this.posY + (this.minecartY - this.posY) / (double)this.turnProgress;
                double d3 = this.posZ + (this.minecartZ - this.posZ) / (double)this.turnProgress;
                for (d5 = this.minecartYaw - (double)this.rotationYaw; d5 < -180.0; d5 += 360.0) {
                }
                while (d5 >= 180.0) {
                    d5 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + d5 / (double)this.turnProgress);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.minecartPitch - (double)this.rotationPitch) / (double)this.turnProgress);
                --this.turnProgress;
                this.setPosition(d, d1, d3);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        int i = MathHelper.floor_double(this.posX);
        if (BlockRail.isRailBlockAt(this.worldObj, i, (j = MathHelper.floor_double(this.posY)) - 1, k = MathHelper.floor_double(this.posZ))) {
            --j;
        }
        double d2 = 0.4;
        double d4 = 0.0078125;
        int l = this.worldObj.getBlockId(i, j, k);
        if (BlockRail.isRailBlock(l)) {
            double d30;
            Vec3D vec3d = this.func_514_g(this.posX, this.posY, this.posZ);
            int i1 = this.worldObj.getBlockMetadata(i, j, k);
            this.posY = j;
            boolean flag = false;
            boolean flag1 = false;
            if (l == Block.railPowered.blockID) {
                flag = (i1 & 8) != 0;
                boolean bl = flag1 = !flag;
            }
            if (((BlockRail)Block.blocksList[l]).isPowered()) {
                i1 &= 7;
            }
            if (i1 >= 2 && i1 <= 5) {
                this.posY = j + 1;
            }
            if (i1 == 2) {
                this.motionX -= d4;
            }
            if (i1 == 3) {
                this.motionX += d4;
            }
            if (i1 == 4) {
                this.motionZ += d4;
            }
            if (i1 == 5) {
                this.motionZ -= d4;
            }
            int[][] ai = field_855_j[i1];
            double d9 = ai[1][0] - ai[0][0];
            double d10 = ai[1][2] - ai[0][2];
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            double d12 = this.motionX * d9 + this.motionZ * d10;
            if (d12 < 0.0) {
                d9 = -d9;
                d10 = -d10;
            }
            double d13 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.motionX = d13 * d9 / d11;
            this.motionZ = d13 * d10 / d11;
            if (flag1) {
                double d16 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d16 < 0.03) {
                    this.motionX *= 0.0;
                    this.motionY *= 0.0;
                    this.motionZ *= 0.0;
                } else {
                    this.motionX *= 0.5;
                    this.motionY *= 0.0;
                    this.motionZ *= 0.5;
                }
            }
            double d17 = 0.0;
            double d18 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d19 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d20 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d21 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            d9 = d20 - d18;
            d10 = d21 - d19;
            if (d9 == 0.0) {
                this.posX = (double)i + 0.5;
                d17 = this.posZ - (double)k;
            } else if (d10 == 0.0) {
                this.posZ = (double)k + 0.5;
                d17 = this.posX - (double)i;
            } else {
                double d26;
                double d22 = this.posX - d18;
                double d24 = this.posZ - d19;
                d17 = d26 = (d22 * d9 + d24 * d10) * 2.0;
            }
            this.posX = d18 + d9 * d17;
            this.posZ = d19 + d10 * d17;
            this.setPosition(this.posX, this.posY + (double)this.yOffset, this.posZ);
            double d23 = this.motionX;
            double d25 = this.motionZ;
            if (this.riddenByEntity != null) {
                d23 *= 0.75;
                d25 *= 0.75;
            }
            if (d23 < -d2) {
                d23 = -d2;
            }
            if (d23 > d2) {
                d23 = d2;
            }
            if (d25 < -d2) {
                d25 = -d2;
            }
            if (d25 > d2) {
                d25 = d2;
            }
            this.moveEntity(d23, 0.0, d25);
            if (ai[0][1] != 0 && MathHelper.floor_double(this.posX) - i == ai[0][0] && MathHelper.floor_double(this.posZ) - k == ai[0][2]) {
                this.setPosition(this.posX, this.posY + (double)ai[0][1], this.posZ);
            } else if (ai[1][1] != 0 && MathHelper.floor_double(this.posX) - i == ai[1][0] && MathHelper.floor_double(this.posZ) - k == ai[1][2]) {
                this.setPosition(this.posX, this.posY + (double)ai[1][1], this.posZ);
            }
            if (this.riddenByEntity != null) {
                this.motionX *= (double)0.997f;
                this.motionY *= 0.0;
                this.motionZ *= (double)0.997f;
            } else {
                if (this.minecartType == 2) {
                    double d27 = MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ);
                    if (d27 > 0.01) {
                        this.pushX /= d27;
                        this.pushZ /= d27;
                        double d29 = 0.04;
                        this.motionX *= (double)0.8f;
                        this.motionY *= 0.0;
                        this.motionZ *= (double)0.8f;
                        this.motionX += this.pushX * d29;
                        this.motionZ += this.pushZ * d29;
                    } else {
                        this.motionX *= (double)0.9f;
                        this.motionY *= 0.0;
                        this.motionZ *= (double)0.9f;
                    }
                }
                this.motionX *= (double)0.96f;
                this.motionY *= 0.0;
                this.motionZ *= (double)0.96f;
            }
            Vec3D vec3d1 = this.func_514_g(this.posX, this.posY, this.posZ);
            if (vec3d1 != null && vec3d != null) {
                double d28 = (vec3d.yCoord - vec3d1.yCoord) * 0.05;
                double d14 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d14 > 0.0) {
                    this.motionX = this.motionX / d14 * (d14 + d28);
                    this.motionZ = this.motionZ / d14 * (d14 + d28);
                }
                this.setPosition(this.posX, vec3d1.yCoord, this.posZ);
            }
            int k1 = MathHelper.floor_double(this.posX);
            int l1 = MathHelper.floor_double(this.posZ);
            if (k1 != i || l1 != k) {
                double d15 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                this.motionX = d15 * (double)(k1 - i);
                this.motionZ = d15 * (double)(l1 - k);
            }
            if (this.minecartType == 2 && (d30 = (double)MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ)) > 0.01 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.001) {
                this.pushX /= d30;
                this.pushZ /= d30;
                if (this.pushX * this.motionX + this.pushZ * this.motionZ < 0.0) {
                    this.pushX = 0.0;
                    this.pushZ = 0.0;
                } else {
                    this.pushX = this.motionX;
                    this.pushZ = this.motionZ;
                }
            }
            if (flag) {
                double d31 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d31 > 0.01) {
                    double d32 = 0.06;
                    this.motionX += this.motionX / d31 * d32;
                    this.motionZ += this.motionZ / d31 * d32;
                } else if (i1 == 1) {
                    if (this.worldObj.isBlockNormalCube(i - 1, j, k)) {
                        this.motionX = 0.02;
                    } else if (this.worldObj.isBlockNormalCube(i + 1, j, k)) {
                        this.motionX = -0.02;
                    }
                } else if (i1 == 0) {
                    if (this.worldObj.isBlockNormalCube(i, j, k - 1)) {
                        this.motionZ = 0.02;
                    } else if (this.worldObj.isBlockNormalCube(i, j, k + 1)) {
                        this.motionZ = -0.02;
                    }
                }
            }
        } else {
            if (this.motionX < -d2) {
                this.motionX = -d2;
            }
            if (this.motionX > d2) {
                this.motionX = d2;
            }
            if (this.motionZ < -d2) {
                this.motionZ = -d2;
            }
            if (this.motionZ > d2) {
                this.motionZ = d2;
            }
            if (this.onGround) {
                this.motionX *= 0.5;
                this.motionY *= 0.5;
                this.motionZ *= 0.5;
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (!this.onGround) {
                this.motionX *= (double)0.95f;
                this.motionY *= (double)0.95f;
                this.motionZ *= (double)0.95f;
            }
        }
        this.rotationPitch = 0.0f;
        double d6 = this.prevPosX - this.posX;
        double d7 = this.prevPosZ - this.posZ;
        if (d6 * d6 + d7 * d7 > 0.001) {
            this.rotationYaw = (float)(Math.atan2(d7, d6) * 180.0 / Math.PI);
            if (this.field_856_i) {
                this.rotationYaw += 180.0f;
            }
        }
        for (d8 = (double)(this.rotationYaw - this.prevRotationYaw); d8 >= 180.0; d8 -= 360.0) {
        }
        while (d8 < -180.0) {
            d8 += 360.0;
        }
        if (d8 < -170.0 || d8 >= 170.0) {
            this.rotationYaw += 180.0f;
            this.field_856_i = !this.field_856_i;
        }
        this.setRotation(this.rotationYaw, this.rotationPitch);
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = (Entity)list.get(j1);
                if (entity == this.riddenByEntity || !entity.canBePushed() || !(entity instanceof EntityMinecart)) continue;
                entity.applyEntityCollision(this);
            }
        }
        if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
            if (this.riddenByEntity.ridingEntity == this) {
                this.riddenByEntity.ridingEntity = null;
            }
            this.riddenByEntity = null;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.fuel <= 0) {
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setMinecartPowered(this.fuel > 0);
    }

    public Vec3D func_515_a(double par1, double par3, double par5, double par7) {
        int l;
        int k;
        int j;
        int i = MathHelper.floor_double(par1);
        if (BlockRail.isRailBlockAt(this.worldObj, i, (j = MathHelper.floor_double(par3)) - 1, k = MathHelper.floor_double(par5))) {
            --j;
        }
        if (BlockRail.isRailBlock(l = this.worldObj.getBlockId(i, j, k))) {
            int i1 = this.worldObj.getBlockMetadata(i, j, k);
            if (((BlockRail)Block.blocksList[l]).isPowered()) {
                i1 &= 7;
            }
            par3 = j;
            if (i1 >= 2 && i1 <= 5) {
                par3 = j + 1;
            }
            int[][] ai = field_855_j[i1];
            double d = ai[1][0] - ai[0][0];
            double d1 = ai[1][2] - ai[0][2];
            double d2 = Math.sqrt(d * d + d1 * d1);
            if (ai[0][1] != 0 && MathHelper.floor_double(par1 += (d /= d2) * par7) - i == ai[0][0] && MathHelper.floor_double(par5 += (d1 /= d2) * par7) - k == ai[0][2]) {
                par3 += (double)ai[0][1];
            } else if (ai[1][1] != 0 && MathHelper.floor_double(par1) - i == ai[1][0] && MathHelper.floor_double(par5) - k == ai[1][2]) {
                par3 += (double)ai[1][1];
            }
            return this.func_514_g(par1, par3, par5);
        }
        return null;
    }

    public Vec3D func_514_g(double par1, double par3, double par5) {
        int l;
        int k;
        int j;
        int i = MathHelper.floor_double(par1);
        if (BlockRail.isRailBlockAt(this.worldObj, i, (j = MathHelper.floor_double(par3)) - 1, k = MathHelper.floor_double(par5))) {
            --j;
        }
        if (BlockRail.isRailBlock(l = this.worldObj.getBlockId(i, j, k))) {
            int i1 = this.worldObj.getBlockMetadata(i, j, k);
            par3 = j;
            if (((BlockRail)Block.blocksList[l]).isPowered()) {
                i1 &= 7;
            }
            if (i1 >= 2 && i1 <= 5) {
                par3 = j + 1;
            }
            int[][] ai = field_855_j[i1];
            double d = 0.0;
            double d1 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d2 = (double)j + 0.5 + (double)ai[0][1] * 0.5;
            double d3 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d4 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d5 = (double)j + 0.5 + (double)ai[1][1] * 0.5;
            double d6 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            double d7 = d4 - d1;
            double d8 = (d5 - d2) * 2.0;
            double d9 = d6 - d3;
            if (d7 == 0.0) {
                par1 = (double)i + 0.5;
                d = par5 - (double)k;
            } else if (d9 == 0.0) {
                par5 = (double)k + 0.5;
                d = par1 - (double)i;
            } else {
                double d12;
                double d10 = par1 - d1;
                double d11 = par5 - d3;
                d = d12 = (d10 * d7 + d11 * d9) * 2.0;
            }
            par1 = d1 + d7 * d;
            par3 = d2 + d8 * d;
            par5 = d3 + d9 * d;
            if (d8 < 0.0) {
                par3 += 1.0;
            }
            if (d8 > 0.0) {
                par3 += 0.5;
            }
            return Vec3D.createVector(par1, par3, par5);
        }
        return null;
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setInteger("Type", this.minecartType);
        if (this.minecartType == 2) {
            par1NBTTagCompound.setDouble("PushX", this.pushX);
            par1NBTTagCompound.setDouble("PushZ", this.pushZ);
            par1NBTTagCompound.setShort("Fuel", (short)this.fuel);
        } else if (this.minecartType == 1) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.cargoItems.length; ++i) {
                if (this.cargoItems[i] == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i);
                this.cargoItems[i].writeToNBT(nbttagcompound);
                nbttaglist.appendTag(nbttagcompound);
            }
            par1NBTTagCompound.setTag("Items", nbttaglist);
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.minecartType = par1NBTTagCompound.getInteger("Type");
        if (this.minecartType == 2) {
            this.pushX = par1NBTTagCompound.getDouble("PushX");
            this.pushZ = par1NBTTagCompound.getDouble("PushZ");
            this.fuel = par1NBTTagCompound.getShort("Fuel");
        } else if (this.minecartType == 1) {
            NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items");
            this.cargoItems = new ItemStack[this.getSizeInventory()];
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i);
                int j = nbttagcompound.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.cargoItems.length) continue;
                this.cargoItems[j] = ItemStack.loadItemStackFromNBT(nbttagcompound);
            }
        }
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public void applyEntityCollision(Entity par1Entity) {
        double d1;
        double d;
        double d2;
        if (this.worldObj.isRemote) {
            return;
        }
        if (par1Entity == this.riddenByEntity) {
            return;
        }
        if (par1Entity instanceof EntityLiving && !(par1Entity instanceof EntityPlayer) && !(par1Entity instanceof EntityIronGolem) && this.minecartType == 0 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01 && this.riddenByEntity == null && par1Entity.ridingEntity == null) {
            par1Entity.mountEntity(this);
        }
        if ((d2 = (d = par1Entity.posX - this.posX) * d + (d1 = par1Entity.posZ - this.posZ) * d1) >= (double)1.0E-4f) {
            d2 = MathHelper.sqrt_double(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.1f;
            d1 *= (double)0.1f;
            d *= (double)(1.0f - this.entityCollisionReduction);
            d1 *= (double)(1.0f - this.entityCollisionReduction);
            d *= 0.5;
            d1 *= 0.5;
            if (par1Entity instanceof EntityMinecart) {
                Vec3D vec3d1;
                double d4 = par1Entity.posX - this.posX;
                double d5 = par1Entity.posZ - this.posZ;
                Vec3D vec3d = Vec3D.createVector(d4, 0.0, d5).normalize();
                double d6 = Math.abs(vec3d.dotProduct(vec3d1 = Vec3D.createVector(MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f), 0.0, MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f)).normalize()));
                if (d6 < (double)0.8f) {
                    return;
                }
                double d7 = par1Entity.motionX + this.motionX;
                double d8 = par1Entity.motionZ + this.motionZ;
                if (((EntityMinecart)par1Entity).minecartType == 2 && this.minecartType != 2) {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity(par1Entity.motionX - d, 0.0, par1Entity.motionZ - d1);
                    par1Entity.motionX *= (double)0.95f;
                    par1Entity.motionZ *= (double)0.95f;
                } else if (((EntityMinecart)par1Entity).minecartType != 2 && this.minecartType == 2) {
                    par1Entity.motionX *= (double)0.2f;
                    par1Entity.motionZ *= (double)0.2f;
                    par1Entity.addVelocity(this.motionX + d, 0.0, this.motionZ + d1);
                    this.motionX *= (double)0.95f;
                    this.motionZ *= (double)0.95f;
                } else {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity((d7 /= 2.0) - d, 0.0, (d8 /= 2.0) - d1);
                    par1Entity.motionX *= (double)0.2f;
                    par1Entity.motionZ *= (double)0.2f;
                    par1Entity.addVelocity(d7 + d, 0.0, d8 + d1);
                }
            } else {
                this.addVelocity(-d, 0.0, -d1);
                par1Entity.addVelocity(d / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    public int getSizeInventory() {
        return 27;
    }

    @Override
    public ItemStack getStackInSlot(int par1) {
        return this.cargoItems[par1];
    }

    @Override
    public ItemStack decrStackSize(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].stackSize <= par2) {
                ItemStack itemstack = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[par1].splitStack(par2);
            if (this.cargoItems[par1].stackSize == 0) {
                this.cargoItems[par1] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack itemstack = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
            par2ItemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "container.minecart";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        if (this.minecartType == 0) {
            if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != par1EntityPlayer) {
                return true;
            }
            if (!this.worldObj.isRemote) {
                par1EntityPlayer.mountEntity(this);
            }
        } else if (this.minecartType == 1) {
            if (!this.worldObj.isRemote) {
                par1EntityPlayer.displayGUIChest(this);
            }
        } else if (this.minecartType == 2) {
            ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
            if (itemstack != null && itemstack.itemID == Item.coal.shiftedIndex) {
                if (--itemstack.stackSize == 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
                }
                this.fuel += 3600;
            }
            this.pushX = this.posX - par1EntityPlayer.posX;
            this.pushZ = this.posZ - par1EntityPlayer.posZ;
        }
        return true;
    }

    @Override
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.minecartX = par1;
        this.minecartY = par3;
        this.minecartZ = par5;
        this.minecartYaw = par7;
        this.minecartPitch = par8;
        this.turnProgress = par9 + 2;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @Override
    public void setVelocity(double par1, double par3, double par5) {
        this.velocityX = this.motionX = par1;
        this.velocityY = this.motionY = par3;
        this.velocityZ = this.motionZ = par5;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        if (this.isDead) {
            return false;
        }
        return par1EntityPlayer.getDistanceSqToEntity(this) <= 64.0;
    }

    protected boolean isMinecartPowered() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    protected void setMinecartPowered(boolean par1) {
        if (par1) {
            this.dataWatcher.updateObject(16, (byte)(this.dataWatcher.getWatchableObjectByte(16) | 1));
        } else {
            this.dataWatcher.updateObject(16, (byte)(this.dataWatcher.getWatchableObjectByte(16) & 0xFFFFFFFE));
        }
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }

    public void func_41024_b(int par1) {
        this.dataWatcher.updateObject(19, par1);
    }

    public int func_41025_i() {
        return this.dataWatcher.getWatchableObjectInt(19);
    }

    public void func_41028_c(int par1) {
        this.dataWatcher.updateObject(17, par1);
    }

    public int func_41023_l() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void func_41029_h(int par1) {
        this.dataWatcher.updateObject(18, par1);
    }

    public int func_41030_m() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }
}

