/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class EntityMooshroom
extends EntityCow {
    public EntityMooshroom(World par1World) {
        super(par1World);
        this.texture = "/mob/redcow.png";
        this.setSize(0.9f, 1.3f);
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == Item.bowlEmpty.shiftedIndex && this.getGrowingAge() >= 0) {
            if (itemstack.stackSize == 1) {
                par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, new ItemStack(Item.bowlSoup));
                return true;
            }
            if (par1EntityPlayer.inventory.addItemStackToInventory(new ItemStack(Item.bowlSoup)) && !par1EntityPlayer.capabilities.isCreativeMode) {
                par1EntityPlayer.inventory.decrStackSize(par1EntityPlayer.inventory.currentItem, 1);
                return true;
            }
        }
        if (itemstack != null && itemstack.itemID == Item.shears.shiftedIndex && this.getGrowingAge() >= 0) {
            this.setDead();
            this.worldObj.spawnParticle("largeexplode", this.posX, this.posY + (double)(this.height / 2.0f), this.posZ, 0.0, 0.0, 0.0);
            if (!this.worldObj.isRemote) {
                EntityCow entitycow = new EntityCow(this.worldObj);
                entitycow.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
                entitycow.setEntityHealth(this.getHealth());
                entitycow.renderYawOffset = this.renderYawOffset;
                this.worldObj.spawnEntityInWorld(entitycow);
                for (int i = 0; i < 5; ++i) {
                    this.worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY + (double)this.height, this.posZ, new ItemStack(Block.mushroomRed)));
                }
            }
            return true;
        }
        return super.interact(par1EntityPlayer);
    }

    @Override
    public EntityAnimal spawnBabyAnimal(EntityAnimal par1EntityAnimal) {
        return new EntityMooshroom(this.worldObj);
    }
}

