/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.DamageSource;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class EntityOtherPlayerMP
extends EntityPlayer {
    private boolean isItemInUse = false;
    private int otherPlayerMPPosRotationIncrements;
    private double otherPlayerMPX;
    private double otherPlayerMPY;
    private double otherPlayerMPZ;
    private double otherPlayerMPYaw;
    private double otherPlayerMPPitch;

    public EntityOtherPlayerMP(World par1World, String par2Str) {
        super(par1World);
        this.username = par2Str;
        this.yOffset = 0.0f;
        this.stepHeight = 0.0f;
        if (par2Str != null && par2Str.length() > 0) {
            this.skinUrl = "http://s3.amazonaws.com/MinecraftSkins/" + par2Str + ".png";
        }
        this.noClip = true;
        this.field_22062_y = 0.25f;
        this.renderDistanceWeight = 10.0;
    }

    @Override
    protected void resetHeight() {
        this.yOffset = 0.0f;
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        return true;
    }

    @Override
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.otherPlayerMPX = par1;
        this.otherPlayerMPY = par3;
        this.otherPlayerMPZ = par5;
        this.otherPlayerMPYaw = par7;
        this.otherPlayerMPPitch = par8;
        this.otherPlayerMPPosRotationIncrements = par9;
    }

    @Override
    public void onUpdate() {
        this.field_22062_y = 0.0f;
        super.onUpdate();
        this.field_705_Q = this.field_704_R;
        double d = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.field_704_R += (f - this.field_704_R) * 0.4f;
        this.field_703_S += this.field_704_R;
        if (!this.isItemInUse && this.isEating() && this.inventory.mainInventory[this.inventory.currentItem] != null) {
            ItemStack itemstack = this.inventory.mainInventory[this.inventory.currentItem];
            this.setItemInUse(this.inventory.mainInventory[this.inventory.currentItem], Item.itemsList[itemstack.itemID].getMaxItemUseDuration(itemstack));
            this.isItemInUse = true;
        } else if (this.isItemInUse && !this.isEating()) {
            this.clearItemInUse();
            this.isItemInUse = false;
        }
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public void onLivingUpdate() {
        super.updateEntityActionState();
        if (this.otherPlayerMPPosRotationIncrements > 0) {
            double d3;
            double d = this.posX + (this.otherPlayerMPX - this.posX) / (double)this.otherPlayerMPPosRotationIncrements;
            double d1 = this.posY + (this.otherPlayerMPY - this.posY) / (double)this.otherPlayerMPPosRotationIncrements;
            double d2 = this.posZ + (this.otherPlayerMPZ - this.posZ) / (double)this.otherPlayerMPPosRotationIncrements;
            for (d3 = this.otherPlayerMPYaw - (double)this.rotationYaw; d3 < -180.0; d3 += 360.0) {
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d3 / (double)this.otherPlayerMPPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.otherPlayerMPPitch - (double)this.rotationPitch) / (double)this.otherPlayerMPPosRotationIncrements);
            --this.otherPlayerMPPosRotationIncrements;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        this.prevCameraYaw = this.cameraYaw;
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f1 = 0.0f;
        }
        this.cameraYaw += (f - this.cameraYaw) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
    }

    @Override
    public void outfitWithItem(int par1, int par2, int par3) {
        ItemStack itemstack = null;
        if (par2 >= 0) {
            itemstack = new ItemStack(par2, 1, par3);
        }
        if (par1 == 0) {
            this.inventory.mainInventory[this.inventory.currentItem] = itemstack;
        } else {
            this.inventory.armorInventory[par1 - 1] = itemstack;
        }
    }

    @Override
    public void func_6420_o() {
    }

    @Override
    public float getEyeHeight() {
        return 1.82f;
    }
}

