/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EnumArt;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityPainting
extends Entity {
    private int tickCounter1 = 0;
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public EnumArt art;

    public EntityPainting(World par1World) {
        super(par1World);
        this.yOffset = 0.0f;
        this.setSize(0.5f, 0.5f);
    }

    public EntityPainting(World par1World, int par2, int par3, int par4, int par5) {
        this(par1World);
        this.xPosition = par2;
        this.yPosition = par3;
        this.zPosition = par4;
        ArrayList<EnumArt> arraylist = new ArrayList<EnumArt>();
        EnumArt[] aenumart = EnumArt.values();
        int i = aenumart.length;
        for (int j = 0; j < i; ++j) {
            EnumArt enumart;
            this.art = enumart = aenumart[j];
            this.func_412_b(par5);
            if (!this.onValidSurface()) continue;
            arraylist.add(enumart);
        }
        if (arraylist.size() > 0) {
            this.art = (EnumArt)((Object)arraylist.get(this.rand.nextInt(arraylist.size())));
        }
        this.func_412_b(par5);
    }

    public EntityPainting(World par1World, int par2, int par3, int par4, int par5, String par6Str) {
        this(par1World);
        this.xPosition = par2;
        this.yPosition = par3;
        this.zPosition = par4;
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(par6Str)) continue;
            this.art = enumart;
            break;
        }
        this.func_412_b(par5);
    }

    @Override
    protected void entityInit() {
    }

    public void func_412_b(int par1) {
        this.direction = par1;
        this.prevRotationYaw = this.rotationYaw = (float)(par1 * 90);
        float f = this.art.sizeX;
        float f1 = this.art.sizeY;
        float f2 = this.art.sizeX;
        if (par1 == 0 || par1 == 2) {
            f2 = 0.5f;
        } else {
            f = 0.5f;
        }
        f /= 32.0f;
        f1 /= 32.0f;
        f2 /= 32.0f;
        float f3 = (float)this.xPosition + 0.5f;
        float f4 = (float)this.yPosition + 0.5f;
        float f5 = (float)this.zPosition + 0.5f;
        float f6 = 0.5625f;
        if (par1 == 0) {
            f5 -= f6;
        }
        if (par1 == 1) {
            f3 -= f6;
        }
        if (par1 == 2) {
            f5 += f6;
        }
        if (par1 == 3) {
            f3 += f6;
        }
        if (par1 == 0) {
            f3 -= this.func_411_c(this.art.sizeX);
        }
        if (par1 == 1) {
            f5 += this.func_411_c(this.art.sizeX);
        }
        if (par1 == 2) {
            f3 += this.func_411_c(this.art.sizeX);
        }
        if (par1 == 3) {
            f5 -= this.func_411_c(this.art.sizeX);
        }
        this.setPosition(f3, f4 += this.func_411_c(this.art.sizeY), f5);
        float f7 = -0.00625f;
        this.boundingBox.setBounds(f3 - f - f7, f4 - f1 - f7, f5 - f2 - f7, f3 + f + f7, f4 + f1 + f7, f5 + f2 + f7);
    }

    private float func_411_c(int par1) {
        if (par1 == 32) {
            return 0.5f;
        }
        return par1 != 64 ? 0.0f : 0.5f;
    }

    @Override
    public void onUpdate() {
        if (this.tickCounter1++ == 100 && !this.worldObj.isRemote) {
            this.tickCounter1 = 0;
            if (!this.isDead && !this.onValidSurface()) {
                this.setDead();
                this.worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
            }
        }
    }

    public boolean onValidSurface() {
        if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() > 0) {
            return false;
        }
        int i = this.art.sizeX / 16;
        int j = this.art.sizeY / 16;
        int k = this.xPosition;
        int l = this.yPosition;
        int i1 = this.zPosition;
        if (this.direction == 0) {
            k = MathHelper.floor_double(this.posX - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 1) {
            i1 = MathHelper.floor_double(this.posZ - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 2) {
            k = MathHelper.floor_double(this.posX - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 3) {
            i1 = MathHelper.floor_double(this.posZ - (double)((float)this.art.sizeX / 32.0f));
        }
        l = MathHelper.floor_double(this.posY - (double)((float)this.art.sizeY / 32.0f));
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < j; ++k1) {
                Material material = this.direction == 0 || this.direction == 2 ? this.worldObj.getBlockMaterial(k + j1, l + k1, this.zPosition) : this.worldObj.getBlockMaterial(this.xPosition, l + k1, i1 + j1);
                if (material.isSolid()) continue;
                return false;
            }
        }
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            if (!(list.get(l1) instanceof EntityPainting)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (!this.isDead && !this.worldObj.isRemote) {
            this.setDead();
            this.setBeenAttacked();
            this.worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
        return true;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setByte("Dir", (byte)this.direction);
        par1NBTTagCompound.setString("Motive", this.art.title);
        par1NBTTagCompound.setInteger("TileX", this.xPosition);
        par1NBTTagCompound.setInteger("TileY", this.yPosition);
        par1NBTTagCompound.setInteger("TileZ", this.zPosition);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.direction = par1NBTTagCompound.getByte("Dir");
        this.xPosition = par1NBTTagCompound.getInteger("TileX");
        this.yPosition = par1NBTTagCompound.getInteger("TileY");
        this.zPosition = par1NBTTagCompound.getInteger("TileZ");
        String s = par1NBTTagCompound.getString("Motive");
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(s)) continue;
            this.art = enumart;
        }
        if (this.art == null) {
            this.art = EnumArt.Kebab;
        }
        this.func_412_b(this.direction);
    }

    @Override
    public void moveEntity(double par1, double par3, double par5) {
        if (!this.worldObj.isRemote && !this.isDead && par1 * par1 + par3 * par3 + par5 * par5 > 0.0) {
            this.setDead();
            this.worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
    }

    @Override
    public void addVelocity(double par1, double par3, double par5) {
        if (!this.worldObj.isRemote && !this.isDead && par1 * par1 + par3 * par3 + par5 * par5 > 0.0) {
            this.setDead();
            this.worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
    }
}

