/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.DamageSource;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityPigZombie
extends EntityZombie {
    private int angerLevel = 0;
    private int randomSoundDelay = 0;
    private static final ItemStack defaultHeldItem = new ItemStack(Item.swordGold, 1);

    public EntityPigZombie(World par1World) {
        super(par1World);
        this.texture = "/mob/pigzombie.png";
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.isImmuneToFire = true;
    }

    @Override
    protected boolean isAIEnabled() {
        return false;
    }

    @Override
    public void onUpdate() {
        float f = this.moveSpeed = this.entityToAttack == null ? 0.5f : 0.95f;
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.worldObj.playSoundAtEntity(this, "mob.zombiepig.zpigangry", this.getSoundVolume() * 2.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        super.onUpdate();
    }

    @Override
    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting > 0 && this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.isAnyLiquid(this.boundingBox);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setShort("Anger", (short)this.angerLevel);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.angerLevel = par1NBTTagCompound.getShort("Anger");
    }

    @Override
    protected Entity findPlayerToAttack() {
        if (this.angerLevel == 0) {
            return null;
        }
        return super.findPlayerToAttack();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        Entity entity = par1DamageSource.getEntity();
        if (entity instanceof EntityPlayer) {
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (!(entity1 instanceof EntityPigZombie)) continue;
                EntityPigZombie entitypigzombie = (EntityPigZombie)entity1;
                entitypigzombie.becomeAngryAt(entity);
            }
            this.becomeAngryAt(entity);
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    private void becomeAngryAt(Entity par1Entity) {
        this.entityToAttack = par1Entity;
        this.angerLevel = 400 + this.rand.nextInt(400);
        this.randomSoundDelay = this.rand.nextInt(40);
    }

    @Override
    protected String getLivingSound() {
        return "mob.zombiepig.zpig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiepig.zpighurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiepig.zpigdeath";
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.rand.nextInt(2 + par2);
        for (int j = 0; j < i; ++j) {
            this.dropItem(Item.rottenFlesh.shiftedIndex, 1);
        }
        i = this.rand.nextInt(2 + par2);
        for (int k = 0; k < i; ++k) {
            this.dropItem(Item.goldNugget.shiftedIndex, 1);
        }
    }

    @Override
    protected void dropRareDrop(int par1) {
        if (par1 > 0) {
            ItemStack itemstack = new ItemStack(Item.swordGold);
            EnchantmentHelper.func_48441_a(this.rand, itemstack, 5);
            this.entityDropItem(itemstack, 0.0f);
        } else {
            int i = this.rand.nextInt(3);
            if (i == 0) {
                this.dropItem(Item.ingotGold.shiftedIndex, 1);
            } else if (i == 1) {
                this.dropItem(Item.swordGold.shiftedIndex, 1);
            } else if (i == 2) {
                this.dropItem(Item.helmetGold.shiftedIndex, 1);
            }
        }
    }

    @Override
    protected int getDropItemId() {
        return Item.rottenFlesh.shiftedIndex;
    }

    @Override
    public ItemStack getHeldItem() {
        return defaultHeldItem;
    }
}

