/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityThrowable;
import net.minecraft.src.Item;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Potion;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.World;

public class EntityPotion
extends EntityThrowable {
    private int potionDamage;

    public EntityPotion(World par1World) {
        super(par1World);
    }

    public EntityPotion(World par1World, EntityLiving par2EntityLiving, int par3) {
        super(par1World, par2EntityLiving);
        this.potionDamage = par3;
    }

    public EntityPotion(World par1World, double par2, double par4, double par6, int par8) {
        super(par1World, par2, par4, par6);
        this.potionDamage = par8;
    }

    @Override
    protected float func_40075_e() {
        return 0.05f;
    }

    @Override
    protected float func_40077_c() {
        return 0.5f;
    }

    @Override
    protected float func_40074_d() {
        return -20.0f;
    }

    public int getPotionDamage() {
        return this.potionDamage;
    }

    @Override
    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (!this.worldObj.isRemote) {
            AxisAlignedBB axisalignedbb;
            List list1;
            List list = Item.potion.getEffects(this.potionDamage);
            if (list != null && !list.isEmpty() && (list1 = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, axisalignedbb = this.boundingBox.expand(4.0, 2.0, 4.0))) != null && !list1.isEmpty()) {
                for (Entity entity : list1) {
                    double d = this.getDistanceSqToEntity(entity);
                    if (!(d < 16.0)) continue;
                    double d1 = 1.0 - Math.sqrt(d) / 4.0;
                    if (entity == par1MovingObjectPosition.entityHit) {
                        d1 = 1.0;
                    }
                    for (PotionEffect potioneffect : list) {
                        int i = potioneffect.getPotionID();
                        if (Potion.potionTypes[i].isInstant()) {
                            Potion.potionTypes[i].affectEntity(this.thrower, (EntityLiving)entity, potioneffect.getAmplifier(), d1);
                            continue;
                        }
                        int j = (int)(d1 * (double)potioneffect.getDuration() + 0.5);
                        if (j <= 20) continue;
                        ((EntityLiving)entity).addPotionEffect(new PotionEffect(i, j, potioneffect.getAmplifier()));
                    }
                }
            }
            this.worldObj.playAuxSFX(2002, (int)Math.round(this.posX), (int)Math.round(this.posY), (int)Math.round(this.posZ), this.potionDamage);
            this.setDead();
        }
    }
}

