/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockSilverfish;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDamageSource;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumCreatureAttribute;
import net.minecraft.src.Facing;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntitySilverfish
extends EntityMob {
    private int allySummonCooldown;

    public EntitySilverfish(World par1World) {
        super(par1World);
        this.texture = "/mob/silverfish.png";
        this.setSize(0.3f, 0.7f);
        this.moveSpeed = 0.6f;
        this.attackStrength = 1;
    }

    @Override
    public int getMaxHealth() {
        return 8;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected Entity findPlayerToAttack() {
        double d = 8.0;
        return this.worldObj.getClosestVulnerablePlayerToEntity(this, d);
    }

    @Override
    protected String getLivingSound() {
        return "mob.silverfish.say";
    }

    @Override
    protected String getHurtSound() {
        return "mob.silverfish.hit";
    }

    @Override
    protected String getDeathSound() {
        return "mob.silverfish.kill";
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (this.allySummonCooldown <= 0 && par1DamageSource instanceof EntityDamageSource) {
            this.allySummonCooldown = 20;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    protected void attackEntity(Entity par1Entity, float par2) {
        if (this.attackTime <= 0 && par2 < 1.2f && par1Entity.boundingBox.maxY > this.boundingBox.minY && par1Entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            par1Entity.attackEntityFrom(DamageSource.causeMobDamage(this), this.attackStrength);
        }
    }

    @Override
    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.worldObj.playSoundAtEntity(this, "mob.silverfish.step", 1.0f, 1.0f);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    @Override
    protected int getDropItemId() {
        return 0;
    }

    @Override
    public void onUpdate() {
        this.renderYawOffset = this.rotationYaw;
        super.onUpdate();
    }

    @Override
    protected void updateEntityActionState() {
        super.updateEntityActionState();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.allySummonCooldown > 0) {
            --this.allySummonCooldown;
            if (this.allySummonCooldown == 0) {
                int i = MathHelper.floor_double(this.posX);
                int k = MathHelper.floor_double(this.posY);
                int i1 = MathHelper.floor_double(this.posZ);
                boolean flag = false;
                int l1 = 0;
                while (!flag && l1 <= 5 && l1 >= -5) {
                    int j2 = 0;
                    while (!flag && j2 <= 10 && j2 >= -10) {
                        int k2 = 0;
                        while (!flag && k2 <= 10 && k2 >= -10) {
                            int l2 = this.worldObj.getBlockId(i + j2, k + l1, i1 + k2);
                            if (l2 == Block.silverfish.blockID) {
                                this.worldObj.playAuxSFX(2001, i + j2, k + l1, i1 + k2, Block.silverfish.blockID + (this.worldObj.getBlockMetadata(i + j2, k + l1, i1 + k2) << 12));
                                this.worldObj.setBlockWithNotify(i + j2, k + l1, i1 + k2, 0);
                                Block.silverfish.onBlockDestroyedByPlayer(this.worldObj, i + j2, k + l1, i1 + k2, 0);
                                if (this.rand.nextBoolean()) {
                                    flag = true;
                                    break;
                                }
                            }
                            k2 = k2 > 0 ? 0 - k2 : 1 - k2;
                        }
                        j2 = j2 > 0 ? 0 - j2 : 1 - j2;
                    }
                    l1 = l1 > 0 ? 0 - l1 : 1 - l1;
                }
            }
        }
        if (this.entityToAttack == null && !this.hasPath()) {
            int j = MathHelper.floor_double(this.posX);
            int l = MathHelper.floor_double(this.posY + 0.5);
            int j1 = MathHelper.floor_double(this.posZ);
            int k1 = this.rand.nextInt(6);
            int i2 = this.worldObj.getBlockId(j + Facing.offsetsXForSide[k1], l + Facing.offsetsYForSide[k1], j1 + Facing.offsetsZForSide[k1]);
            if (BlockSilverfish.getPosingIdByMetadata(i2)) {
                this.worldObj.setBlockAndMetadataWithNotify(j + Facing.offsetsXForSide[k1], l + Facing.offsetsYForSide[k1], j1 + Facing.offsetsZForSide[k1], Block.silverfish.blockID, BlockSilverfish.getMetadataForBlockType(i2));
                this.spawnExplosionParticle();
                this.setDead();
            } else {
                this.updateWanderPath();
            }
        } else if (this.entityToAttack != null && !this.hasPath()) {
            this.entityToAttack = null;
        }
    }

    @Override
    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.worldObj.getBlockId(par1, par2 - 1, par3) == Block.stone.blockID) {
            return 10.0f;
        }
        return super.getBlockPathWeight(par1, par2, par3);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public boolean getCanSpawnHere() {
        if (super.getCanSpawnHere()) {
            EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 5.0);
            return entityplayer == null;
        }
        return false;
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }
}

