/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EnumCreatureAttribute;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Potion;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.World;

public class EntitySpider
extends EntityMob {
    public EntitySpider(World par1World) {
        super(par1World);
        this.texture = "/mob/spider.png";
        this.setSize(1.4f, 0.9f);
        this.moveSpeed = 0.8f;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            this.func_40148_a(this.isCollidedHorizontally);
        }
    }

    @Override
    public int getMaxHealth() {
        return 16;
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.75 - 0.5;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected Entity findPlayerToAttack() {
        float f = this.getBrightness(1.0f);
        if (f < 0.5f) {
            double d = 16.0;
            return this.worldObj.getClosestVulnerablePlayerToEntity(this, d);
        }
        return null;
    }

    @Override
    protected String getLivingSound() {
        return "mob.spider";
    }

    @Override
    protected String getHurtSound() {
        return "mob.spider";
    }

    @Override
    protected String getDeathSound() {
        return "mob.spiderdeath";
    }

    @Override
    protected void attackEntity(Entity par1Entity, float par2) {
        float f = this.getBrightness(1.0f);
        if (f > 0.5f && this.rand.nextInt(100) == 0) {
            this.entityToAttack = null;
            return;
        }
        if (par2 > 2.0f && par2 < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d = par1Entity.posX - this.posX;
                double d1 = par1Entity.posZ - this.posZ;
                float f1 = MathHelper.sqrt_double(d * d + d1 * d1);
                this.motionX = d / (double)f1 * 0.5 * (double)0.8f + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f1 * 0.5 * (double)0.8f + this.motionZ * (double)0.2f;
                this.motionY = 0.4f;
            }
        } else {
            super.attackEntity(par1Entity, par2);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    @Override
    protected int getDropItemId() {
        return Item.silk.shiftedIndex;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        super.dropFewItems(par1, par2);
        if (par1 && (this.rand.nextInt(3) == 0 || this.rand.nextInt(1 + par2) > 0)) {
            this.dropItem(Item.spiderEye.shiftedIndex, 1);
        }
    }

    @Override
    public boolean isOnLadder() {
        return this.func_40149_l_();
    }

    @Override
    public void setInWeb() {
    }

    public float spiderScaleAmount() {
        return 1.0f;
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean isPotionApplicable(PotionEffect par1PotionEffect) {
        if (par1PotionEffect.getPotionID() == Potion.poison.id) {
            return false;
        }
        return super.isPotionApplicable(par1PotionEffect);
    }

    public boolean func_40149_l_() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void func_40148_a(boolean par1) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        byte0 = par1 ? (byte)(byte0 | 1) : (byte)(byte0 & 0xFE);
        this.dataWatcher.updateObject(16, byte0);
    }
}

