/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityAIAvoidEntity;
import net.minecraft.src.EntityAIFollowGolem;
import net.minecraft.src.EntityAIMoveIndoors;
import net.minecraft.src.EntityAIMoveTwardsRestriction;
import net.minecraft.src.EntityAIOpenDoor;
import net.minecraft.src.EntityAIPlay;
import net.minecraft.src.EntityAIRestrictOpenDoor;
import net.minecraft.src.EntityAISwimming;
import net.minecraft.src.EntityAIVillagerMate;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityAIWatchClosest2;
import net.minecraft.src.EntityAgeable;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Village;
import net.minecraft.src.World;

public class EntityVillager
extends EntityAgeable {
    private int randomTickDivider = 0;
    private boolean isMatingFlag = false;
    private boolean isPlayingFlag = false;
    Village villageObj = null;

    public EntityVillager(World par1World) {
        this(par1World, 0);
    }

    public EntityVillager(World par1World, int par2) {
        super(par1World);
        this.setProfession(par2);
        this.texture = "/mob/villager/villager.png";
        this.moveSpeed = 0.5f;
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIAvoidEntity(this, EntityZombie.class, 8.0f, 0.3f, 0.35f));
        this.tasks.addTask(2, new EntityAIMoveIndoors(this));
        this.tasks.addTask(3, new EntityAIRestrictOpenDoor(this));
        this.tasks.addTask(4, new EntityAIOpenDoor(this, true));
        this.tasks.addTask(5, new EntityAIMoveTwardsRestriction(this, 0.3f));
        this.tasks.addTask(6, new EntityAIVillagerMate(this));
        this.tasks.addTask(7, new EntityAIFollowGolem(this));
        this.tasks.addTask(8, new EntityAIPlay(this, 0.32f));
        this.tasks.addTask(9, new EntityAIWatchClosest2(this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(9, new EntityAIWatchClosest2(this, EntityVillager.class, 5.0f, 0.02f));
        this.tasks.addTask(9, new EntityAIWander(this, 0.3f));
        this.tasks.addTask(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
    }

    @Override
    public boolean isAIEnabled() {
        return true;
    }

    @Override
    protected void updateAITick() {
        if (--this.randomTickDivider <= 0) {
            this.worldObj.villageCollectionObj.addVillagerPosition(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
            this.randomTickDivider = 70 + this.rand.nextInt(50);
            this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ), 32);
            if (this.villageObj == null) {
                this.detachHome();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.getCenter();
                this.setHomeArea(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, this.villageObj.getVillageRadius());
            }
        }
        super.updateAITick();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, 0);
    }

    @Override
    public int getMaxHealth() {
        return 20;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Profession", this.getProfession());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setProfession(par1NBTTagCompound.getInteger("Profession"));
    }

    @Override
    public String getTexture() {
        switch (this.getProfession()) {
            case 0: {
                return "/mob/villager/farmer.png";
            }
            case 1: {
                return "/mob/villager/librarian.png";
            }
            case 2: {
                return "/mob/villager/priest.png";
            }
            case 3: {
                return "/mob/villager/smith.png";
            }
            case 4: {
                return "/mob/villager/butcher.png";
            }
        }
        return super.getTexture();
    }

    @Override
    protected boolean canDespawn() {
        return false;
    }

    @Override
    protected String getLivingSound() {
        return "mob.villager.default";
    }

    @Override
    protected String getHurtSound() {
        return "mob.villager.defaulthurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.villager.defaultdeath";
    }

    public void setProfession(int par1) {
        this.dataWatcher.updateObject(16, par1);
    }

    public int getProfession() {
        return this.dataWatcher.getWatchableObjectInt(16);
    }

    public boolean getIsMatingFlag() {
        return this.isMatingFlag;
    }

    public void setIsMatingFlag(boolean par1) {
        this.isMatingFlag = par1;
    }

    public void setIsPlayingFlag(boolean par1) {
        this.isPlayingFlag = par1;
    }

    public boolean getIsPlayingFlag() {
        return this.isPlayingFlag;
    }

    @Override
    public void setRevengeTarget(EntityLiving par1EntityLiving) {
        super.setRevengeTarget(par1EntityLiving);
        if (this.villageObj != null && par1EntityLiving != null) {
            this.villageObj.addOrRenewAgressor(par1EntityLiving);
        }
    }
}

