/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.NibbleArray;

public class ExtendedBlockStorage {
    private int yBase;
    private int blockRefCount;
    private int tickRefCount;
    private byte[] blockLSBArray;
    private NibbleArray blockMSBArray;
    private NibbleArray blockMetadataArray;
    private NibbleArray blocklightArray;
    private NibbleArray skylightArray;

    public ExtendedBlockStorage(int par1) {
        this.yBase = par1;
        this.blockLSBArray = new byte[4096];
        this.blockMetadataArray = new NibbleArray(this.blockLSBArray.length, 4);
        this.skylightArray = new NibbleArray(this.blockLSBArray.length, 4);
        this.blocklightArray = new NibbleArray(this.blockLSBArray.length, 4);
    }

    public int getExtBlockID(int par1, int par2, int par3) {
        int i = this.blockLSBArray[par2 << 8 | par3 << 4 | par1] & 0xFF;
        if (this.blockMSBArray != null) {
            return this.blockMSBArray.get(par1, par2, par3) << 8 | i;
        }
        return i;
    }

    public void setExtBlockID(int par1, int par2, int par3, int par4) {
        int i = this.blockLSBArray[par2 << 8 | par3 << 4 | par1] & 0xFF;
        if (this.blockMSBArray != null) {
            i = this.blockMSBArray.get(par1, par2, par3) << 8 | i;
        }
        if (i == 0 && par4 != 0) {
            ++this.blockRefCount;
            if (Block.blocksList[par4] != null && Block.blocksList[par4].getTickRandomly()) {
                ++this.tickRefCount;
            }
        } else if (i != 0 && par4 == 0) {
            --this.blockRefCount;
            if (Block.blocksList[i] != null && Block.blocksList[i].getTickRandomly()) {
                --this.tickRefCount;
            }
        } else if (Block.blocksList[i] != null && Block.blocksList[i].getTickRandomly() && (Block.blocksList[par4] == null || !Block.blocksList[par4].getTickRandomly())) {
            --this.tickRefCount;
        } else if ((Block.blocksList[i] == null || !Block.blocksList[i].getTickRandomly()) && Block.blocksList[par4] != null && Block.blocksList[par4].getTickRandomly()) {
            ++this.tickRefCount;
        }
        this.blockLSBArray[par2 << 8 | par3 << 4 | par1] = (byte)(par4 & 0xFF);
        if (par4 > 255) {
            if (this.blockMSBArray == null) {
                this.blockMSBArray = new NibbleArray(this.blockLSBArray.length, 4);
            }
            this.blockMSBArray.set(par1, par2, par3, (par4 & 0xF00) >> 8);
        } else if (this.blockMSBArray != null) {
            this.blockMSBArray.set(par1, par2, par3, 0);
        }
    }

    public int getExtBlockMetadata(int par1, int par2, int par3) {
        return this.blockMetadataArray.get(par1, par2, par3);
    }

    public void setExtBlockMetadata(int par1, int par2, int par3, int par4) {
        this.blockMetadataArray.set(par1, par2, par3, par4);
    }

    public boolean getIsEmpty() {
        return this.blockRefCount == 0;
    }

    public boolean getNeedsRandomTick() {
        return this.tickRefCount > 0;
    }

    public int getYLocation() {
        return this.yBase;
    }

    public void setExtSkylightValue(int par1, int par2, int par3, int par4) {
        this.skylightArray.set(par1, par2, par3, par4);
    }

    public int getExtSkylightValue(int par1, int par2, int par3) {
        return this.skylightArray.get(par1, par2, par3);
    }

    public void setExtBlocklightValue(int par1, int par2, int par3, int par4) {
        this.blocklightArray.set(par1, par2, par3, par4);
    }

    public int getExtBlocklightValue(int par1, int par2, int par3) {
        return this.blocklightArray.get(par1, par2, par3);
    }

    public void func_48708_d() {
        this.blockRefCount = 0;
        this.tickRefCount = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    int l = this.getExtBlockID(i, j, k);
                    if (l <= 0) continue;
                    if (Block.blocksList[l] == null) {
                        this.blockLSBArray[j << 8 | k << 4 | i] = 0;
                        if (this.blockMSBArray == null) continue;
                        this.blockMSBArray.set(i, j, k, 0);
                        continue;
                    }
                    ++this.blockRefCount;
                    if (!Block.blocksList[l].getTickRandomly()) continue;
                    ++this.tickRefCount;
                }
            }
        }
    }

    public void func_48711_e() {
    }

    public int func_48700_f() {
        return this.blockRefCount;
    }

    public byte[] func_48692_g() {
        return this.blockLSBArray;
    }

    public void func_48715_h() {
        this.blockMSBArray = null;
    }

    public NibbleArray getBlockMSBArray() {
        return this.blockMSBArray;
    }

    public NibbleArray func_48697_j() {
        return this.blockMetadataArray;
    }

    public NibbleArray getBlocklightArray() {
        return this.blocklightArray;
    }

    public NibbleArray getSkylightArray() {
        return this.skylightArray;
    }

    public void setBlockLSBArray(byte[] par1ArrayOfByte) {
        this.blockLSBArray = par1ArrayOfByte;
    }

    public void setBlockMSBArray(NibbleArray par1NibbleArray) {
        this.blockMSBArray = par1NibbleArray;
    }

    public void setBlockMetadataArray(NibbleArray par1NibbleArray) {
        this.blockMetadataArray = par1NibbleArray;
    }

    public void setBlocklightArray(NibbleArray par1NibbleArray) {
        this.blocklightArray = par1NibbleArray;
    }

    public void setSkylightArray(NibbleArray par1NibbleArray) {
        this.skylightArray = par1NibbleArray;
    }

    public NibbleArray createBlockMSBArray() {
        this.blockMSBArray = new NibbleArray(this.blockLSBArray.length, 4);
        return this.blockMSBArray;
    }
}

