/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GameSettings;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private static final Pattern colorCodeRegex = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private int[] charWidth = new int[256];
    public int fontTextureName = 0;
    public int FONT_HEIGHT = 8;
    public Random fontRandom = new Random();
    private byte[] glyphWidth = new byte[65536];
    private final int[] glyphTextureName = new int[256];
    private int[] colorCode = new int[32];
    private int boundTextureName;
    private final RenderEngine renderEngine;
    private float posX;
    private float posY;
    private boolean unicodeFlag;
    private boolean bidiFlag;
    private float red;
    private float blue;
    private float green;
    private float alpha;

    FontRenderer() {
        this.renderEngine = null;
    }

    public FontRenderer(GameSettings par1GameSettings, String par2Str, RenderEngine par3RenderEngine, boolean par4) {
        BufferedImage bufferedimage;
        this.renderEngine = par3RenderEngine;
        this.unicodeFlag = par4;
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(par2Str));
            InputStream inputstream = RenderEngine.class.getResourceAsStream("/font/glyph_sizes.bin");
            inputstream.read(this.glyphWidth);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] ai = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, ai, 0, i);
        for (int k = 0; k < 256; ++k) {
            int i2;
            int i1 = k % 16;
            int k1 = k / 16;
            for (i2 = 7; i2 >= 0; --i2) {
                int k2 = i1 * 8 + i2;
                boolean flag = true;
                for (int j3 = 0; j3 < 8 && flag; ++j3) {
                    int l3 = (k1 * 8 + j3) * i;
                    int j4 = ai[k2 + l3] & 0xFF;
                    if (j4 <= 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            if (k == 32) {
                i2 = 2;
            }
            this.charWidth[k] = i2 + 2;
        }
        this.fontTextureName = par3RenderEngine.allocateAndSetupTexture(bufferedimage);
        for (int l = 0; l < 32; ++l) {
            int j1 = (l >> 3 & 1) * 85;
            int l1 = (l >> 2 & 1) * 170 + j1;
            int j2 = (l >> 1 & 1) * 170 + j1;
            int l2 = (l >> 0 & 1) * 170 + j1;
            if (l == 6) {
                l1 += 85;
            }
            if (par1GameSettings.anaglyph) {
                int i3 = (l1 * 30 + j2 * 59 + l2 * 11) / 100;
                int k3 = (l1 * 30 + j2 * 70) / 100;
                int i4 = (l1 * 30 + l2 * 70) / 100;
                l1 = i3;
                j2 = k3;
                l2 = i4;
            }
            if (l >= 16) {
                l1 /= 4;
                j2 /= 4;
                l2 /= 4;
            }
            this.colorCode[l] = (l1 & 0xFF) << 16 | (j2 & 0xFF) << 8 | l2 & 0xFF;
        }
    }

    private float renderCharAtPos(int par1, char par2, boolean par3) {
        if (par2 == ' ') {
            return 4.0f;
        }
        if (par1 > 0 && !this.unicodeFlag) {
            return this.renderDefaultChar(par1 + 32, par3);
        }
        return this.renderUnicodeChar(par2, par3);
    }

    private float renderDefaultChar(int par1, boolean par2) {
        float f2;
        float f = par1 % 16 * 8;
        float f1 = par1 / 16 * 8;
        float f3 = f2 = par2 ? 1.0f : 0.0f;
        if (this.boundTextureName != this.fontTextureName) {
            GL11.glBindTexture((int)3553, (int)this.fontTextureName);
            this.boundTextureName = this.fontTextureName;
        }
        float f32 = (float)this.charWidth[par1] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f32) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f32 + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f32) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX + f32 - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.charWidth[par1];
    }

    private void loadGlyphTexture(int par1) {
        BufferedImage bufferedimage;
        String s = String.format("/font/glyph_%02X.png", par1);
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(s));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.glyphTextureName[par1] = this.renderEngine.allocateAndSetupTexture(bufferedimage);
        this.boundTextureName = this.glyphTextureName[par1];
    }

    private float renderUnicodeChar(char par1, boolean par2) {
        if (this.glyphWidth[par1] == 0) {
            return 0.0f;
        }
        int i = par1 / 256;
        if (this.glyphTextureName[i] == 0) {
            this.loadGlyphTexture(i);
        }
        if (this.boundTextureName != this.glyphTextureName[i]) {
            GL11.glBindTexture((int)3553, (int)this.glyphTextureName[i]);
            this.boundTextureName = this.glyphTextureName[i];
        }
        int j = this.glyphWidth[par1] >>> 4;
        int k = this.glyphWidth[par1] & 0xF;
        float f = j;
        float f1 = k + 1;
        float f2 = (float)(par1 % 16 * 16) + f;
        float f3 = (par1 & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        float f5 = par2 ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f1 - f) / 2.0f + 1.0f;
    }

    public int drawStringWithShadow(String par1Str, int par2, int par3, int par4) {
        if (this.bidiFlag) {
            par1Str = this.bidiReorder(par1Str);
        }
        int i = this.renderString(par1Str, par2 + 1, par3 + 1, par4, true);
        i = Math.max(i, this.renderString(par1Str, par2, par3, par4, false));
        return i;
    }

    public void drawString(String par1Str, int par2, int par3, int par4) {
        if (this.bidiFlag) {
            par1Str = this.bidiReorder(par1Str);
        }
        this.renderString(par1Str, par2, par3, par4, false);
    }

    private String bidiReorder(String par1Str) {
        if (par1Str == null || !Bidi.requiresBidi(par1Str.toCharArray(), 0, par1Str.length())) {
            return par1Str;
        }
        Bidi bidi = new Bidi(par1Str, -2);
        byte[] abyte0 = new byte[bidi.getRunCount()];
        Object[] as = new String[abyte0.length];
        for (int i = 0; i < abyte0.length; ++i) {
            int j = bidi.getRunStart(i);
            int k = bidi.getRunLimit(i);
            int i1 = bidi.getRunLevel(i);
            String s = par1Str.substring(j, k);
            abyte0[i] = (byte)i1;
            as[i] = s;
        }
        String[] as1 = (String[])as.clone();
        Bidi.reorderVisually(abyte0, 0, as, 0, abyte0.length);
        StringBuilder stringbuilder = new StringBuilder();
        for (int l = 0; l < as.length; ++l) {
            int j1;
            byte byte0 = abyte0[l];
            for (j1 = 0; j1 < as1.length; ++j1) {
                if (!as1[j1].equals(as[l])) continue;
                byte0 = abyte0[j1];
                break;
            }
            if ((byte0 & 1) == 0) {
                stringbuilder.append((String)as[l]);
                continue;
            }
            for (j1 = ((String)as[l]).length() - 1; j1 >= 0; --j1) {
                char c = ((String)as[l]).charAt(j1);
                if (c == '(') {
                    c = ')';
                } else if (c == ')') {
                    c = '(';
                }
                stringbuilder.append(c);
            }
        }
        return stringbuilder.toString();
    }

    private void renderStringAtPos(String par1Str, boolean par2) {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        for (int i = 0; i < par1Str.length(); ++i) {
            char c = par1Str.charAt(i);
            if (c == '\u00a7' && i + 1 < par1Str.length()) {
                int j = "0123456789abcdefklmnor".indexOf(par1Str.toLowerCase().charAt(i + 1));
                if (j < 16) {
                    flag = false;
                    flag1 = false;
                    flag4 = false;
                    flag3 = false;
                    flag2 = false;
                    if (j < 0 || j > 15) {
                        j = 15;
                    }
                    if (par2) {
                        j += 16;
                    }
                    int l = this.colorCode[j];
                    GL11.glColor3f((float)((float)(l >> 16) / 255.0f), (float)((float)(l >> 8 & 0xFF) / 255.0f), (float)((float)(l & 0xFF) / 255.0f));
                } else if (j == 16) {
                    flag = true;
                } else if (j == 17) {
                    flag1 = true;
                } else if (j == 18) {
                    flag4 = true;
                } else if (j == 19) {
                    flag3 = true;
                } else if (j == 20) {
                    flag2 = true;
                } else if (j == 21) {
                    flag = false;
                    flag1 = false;
                    flag4 = false;
                    flag3 = false;
                    flag2 = false;
                    GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
                }
                ++i;
                continue;
            }
            int k = ChatAllowedCharacters.allowedCharacters.indexOf(c);
            if (flag && k > 0) {
                int i1;
                while (this.charWidth[k + 32] != this.charWidth[(i1 = this.fontRandom.nextInt(ChatAllowedCharacters.allowedCharacters.length())) + 32]) {
                }
                k = i1;
            }
            float f = this.renderCharAtPos(k, c, flag2);
            if (flag1) {
                this.posX += 1.0f;
                this.renderCharAtPos(k, c, flag2);
                this.posX -= 1.0f;
                f += 1.0f;
            }
            if (flag4) {
                Tessellator tessellator = Tessellator.instance;
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.addVertex(this.posX, this.posY + (float)(this.FONT_HEIGHT / 2), 0.0);
                tessellator.addVertex(this.posX + f, this.posY + (float)(this.FONT_HEIGHT / 2), 0.0);
                tessellator.addVertex(this.posX + f, this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f, 0.0);
                tessellator.addVertex(this.posX, this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            if (flag3) {
                Tessellator tessellator1 = Tessellator.instance;
                GL11.glDisable((int)3553);
                tessellator1.startDrawingQuads();
                int j1 = flag3 ? -1 : 0;
                tessellator1.addVertex(this.posX + (float)j1, this.posY + (float)this.FONT_HEIGHT, 0.0);
                tessellator1.addVertex(this.posX + f, this.posY + (float)this.FONT_HEIGHT, 0.0);
                tessellator1.addVertex(this.posX + f, this.posY + (float)this.FONT_HEIGHT - 1.0f, 0.0);
                tessellator1.addVertex(this.posX + (float)j1, this.posY + (float)this.FONT_HEIGHT - 1.0f, 0.0);
                tessellator1.draw();
                GL11.glEnable((int)3553);
            }
            this.posX += f;
        }
    }

    public int renderString(String par1Str, int par2, int par3, int par4, boolean par5) {
        if (par1Str != null) {
            this.boundTextureName = 0;
            if ((par4 & 0xFC000000) == 0) {
                par4 |= 0xFF000000;
            }
            if (par5) {
                par4 = (par4 & 0xFCFCFC) >> 2 | par4 & 0xFF000000;
            }
            this.red = (float)(par4 >> 16 & 0xFF) / 255.0f;
            this.blue = (float)(par4 >> 8 & 0xFF) / 255.0f;
            this.green = (float)(par4 & 0xFF) / 255.0f;
            this.alpha = (float)(par4 >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
            this.posX = par2;
            this.posY = par3;
            this.renderStringAtPos(par1Str, par5);
            return (int)this.posX;
        }
        return 0;
    }

    public int getStringWidth(String par1Str) {
        if (par1Str == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < par1Str.length(); ++j) {
            char c = par1Str.charAt(j);
            int k = this.getCharWidth(c);
            if (k < 0 && j < par1Str.length() - 1) {
                char c1;
                if ((c1 = par1Str.charAt(++j)) == 'l' || c1 == 'L') {
                    flag = true;
                } else if (c1 == 'r' || c1 == 'R') {
                    flag = false;
                }
                k = this.getCharWidth(c1);
            }
            i += k;
            if (!flag) continue;
            ++i;
        }
        return i;
    }

    public int getCharWidth(char par1) {
        if (par1 == '\u00a7') {
            return -1;
        }
        int i = ChatAllowedCharacters.allowedCharacters.indexOf(par1);
        if (i >= 0 && !this.unicodeFlag) {
            return this.charWidth[i + 32];
        }
        if (this.glyphWidth[par1] != 0) {
            int j = this.glyphWidth[par1] >> 4;
            int k = this.glyphWidth[par1] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (++k - j) / 2 + 1;
        }
        return 0;
    }

    public String trimStringToWidth(String par1Str, int par2) {
        return this.trimStringToWidth(par1Str, par2, false);
    }

    public String trimStringToWidth(String par1Str, int par2, boolean par3) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = 0;
        int j = par3 ? par1Str.length() - 1 : 0;
        byte byte0 = (byte)(par3 ? -1 : 1);
        boolean flag = false;
        boolean flag1 = false;
        for (int k = j; k >= 0 && k < par1Str.length() && i < par2; k += byte0) {
            char c = par1Str.charAt(k);
            int l = this.getCharWidth(c);
            if (flag) {
                flag = false;
                if (c == 'l' || c == 'L') {
                    flag1 = true;
                } else if (c == 'r' || c == 'R') {
                    flag1 = false;
                }
            } else if (l < 0) {
                flag = true;
            } else {
                i += l;
                if (flag1) {
                    ++i;
                }
            }
            if (i > par2) break;
            if (par3) {
                stringbuilder.insert(0, c);
                continue;
            }
            stringbuilder.append(c);
        }
        return stringbuilder.toString();
    }

    public void drawSplitString(String par1Str, int par2, int par3, int par4, int par5) {
        if (this.bidiFlag) {
            par1Str = this.bidiReorder(par1Str);
        }
        this.renderSplitStringNoShadow(par1Str, par2, par3, par4, par5);
    }

    private void renderSplitStringNoShadow(String par1Str, int par2, int par3, int par4, int par5) {
        this.renderSplitString(par1Str, par2, par3, par4, par5, false);
    }

    private void renderSplitString(String par1Str, int par2, int par3, int par4, int par5, boolean par6) {
        String[] as = par1Str.split("\n");
        if (as.length > 1) {
            for (int i = 0; i < as.length; ++i) {
                this.renderSplitStringNoShadow(as[i], par2, par3, par4, par5);
                par3 += this.splitStringWidth(as[i], par4);
            }
            return;
        }
        String[] as1 = par1Str.split(" ");
        int j = 0;
        String s = "";
        while (j < as1.length) {
            String s1 = s + as1[j++] + " ";
            while (j < as1.length && this.getStringWidth(s1 + as1[j]) < par4) {
                s1 = s1 + as1[j++] + " ";
            }
            while (this.getStringWidth(s1) > par4) {
                int k = 0;
                while (this.getStringWidth(s1.substring(0, k + 1)) <= par4) {
                    ++k;
                }
                if (s1.substring(0, k).trim().length() > 0) {
                    String s2 = s1.substring(0, k);
                    if (s2.lastIndexOf("\u00a7") >= 0) {
                        s = "\u00a7" + s2.charAt(s2.lastIndexOf("\u00a7") + 1);
                    }
                    this.renderString(s2, par2, par3, par5, par6);
                    par3 += this.FONT_HEIGHT;
                }
                s1 = s + s1.substring(k);
            }
            if (this.getStringWidth(s1.trim()) <= 0) continue;
            if (s1.lastIndexOf("\u00a7") >= 0) {
                s = "\u00a7" + s1.charAt(s1.lastIndexOf("\u00a7") + 1);
            }
            this.renderString(s1, par2, par3, par5, par6);
            par3 += this.FONT_HEIGHT;
        }
    }

    public int splitStringWidth(String par1Str, int par2) {
        String[] as = par1Str.split("\n");
        if (as.length > 1) {
            int i = 0;
            for (int j = 0; j < as.length; ++j) {
                i += this.splitStringWidth(as[j], par2);
            }
            return i;
        }
        String[] as1 = par1Str.split(" ");
        int k = 0;
        int l = 0;
        while (k < as1.length) {
            String s = as1[k++] + " ";
            while (k < as1.length && this.getStringWidth(s + as1[k]) < par2) {
                s = s + as1[k++] + " ";
            }
            while (this.getStringWidth(s) > par2) {
                int i1 = 0;
                while (this.getStringWidth(s.substring(0, i1 + 1)) <= par2) {
                    ++i1;
                }
                if (s.substring(0, i1).trim().length() > 0) {
                    l += this.FONT_HEIGHT;
                }
                s = s.substring(i1);
            }
            if (s.trim().length() <= 0) continue;
            l += this.FONT_HEIGHT;
        }
        if (l < this.FONT_HEIGHT) {
            l += this.FONT_HEIGHT;
        }
        return l;
    }

    public void setUnicodeFlag(boolean par1) {
        this.unicodeFlag = par1;
    }

    public void setBidiFlag(boolean par1) {
        this.bidiFlag = par1;
    }

    public List listFormattedStringToWidth(String par1Str, int par2) {
        return Arrays.asList(this.wrapFormattedStringToWidth(par1Str, par2).split("\n"));
    }

    String wrapFormattedStringToWidth(String par1Str, int par2) {
        int i = this.sizeStringToWidth(par1Str, par2);
        if (par1Str.length() <= i) {
            return par1Str;
        }
        String s = par1Str.substring(0, i);
        String s1 = FontRenderer.getFormatFromString(s) + par1Str.substring(i + (par1Str.charAt(i) != ' ' ? 0 : 1));
        return s + "\n" + this.wrapFormattedStringToWidth(s1, par2);
    }

    private int sizeStringToWidth(String par1Str, int par2) {
        int k;
        int i = par1Str.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c = par1Str.charAt(k);
            switch (c) {
                case '\u00a7': {
                    char c1;
                    if (k == i) break;
                    if ((c1 = par1Str.charAt(++k)) == 'l' || c1 == 'L') {
                        flag = true;
                        break;
                    }
                    if (c1 != 'r' && c1 != 'R') break;
                    flag = false;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += this.getCharWidth(c);
                    if (!flag) break;
                    ++j;
                }
            }
            if (c == '\n') {
                l = ++k;
                break;
            }
            if (j > par2) break;
        }
        if (k != i && l != -1 && l < k) {
            return l;
        }
        return k;
    }

    private static boolean isFormatColor(char par0) {
        return par0 >= '0' && par0 <= '9' || par0 >= 'a' && par0 <= 'f' || par0 >= 'A' && par0 <= 'F';
    }

    private static boolean isFormatSpecial(char par0) {
        return par0 >= 'k' && par0 <= 'o' || par0 >= 'K' && par0 <= 'O' || par0 == 'r' || par0 == 'R';
    }

    private static String getFormatFromString(String par0Str) {
        String s = "";
        int i = -1;
        int j = par0Str.length();
        while ((i = par0Str.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c = par0Str.charAt(i + 1);
            if (FontRenderer.isFormatColor(c)) {
                s = "\u00a7" + c;
                continue;
            }
            if (!FontRenderer.isFormatSpecial(c)) continue;
            s = s + "\u00a7" + c;
        }
        return s;
    }

    public static String stripColorCodes(String par0Str) {
        return colorCodeRegex.matcher(par0Str).replaceAll("");
    }
}

