/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GLAllocation {
    private static List displayLists = new ArrayList();
    private static List textureNames = new ArrayList();

    public static synchronized int generateDisplayLists(int par0) {
        int i = GL11.glGenLists((int)par0);
        displayLists.add(i);
        displayLists.add(par0);
        return i;
    }

    public static synchronized void generateTextureNames(IntBuffer par0IntBuffer) {
        GL11.glGenTextures((IntBuffer)par0IntBuffer);
        for (int i = par0IntBuffer.position(); i < par0IntBuffer.limit(); ++i) {
            textureNames.add(par0IntBuffer.get(i));
        }
    }

    public static synchronized void deleteDisplayLists(int par0) {
        int i = displayLists.indexOf(par0);
        GL11.glDeleteLists((int)((Integer)displayLists.get(i)), (int)((Integer)displayLists.get(i + 1)));
        displayLists.remove(i);
        displayLists.remove(i);
    }

    public static synchronized void deleteTexturesAndDisplayLists() {
        for (int i = 0; i < displayLists.size(); i += 2) {
            GL11.glDeleteLists((int)((Integer)displayLists.get(i)), (int)((Integer)displayLists.get(i + 1)));
        }
        IntBuffer intbuffer = GLAllocation.createDirectIntBuffer(textureNames.size());
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        for (int j = 0; j < textureNames.size(); ++j) {
            intbuffer.put((Integer)textureNames.get(j));
        }
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        displayLists.clear();
        textureNames.clear();
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int par0) {
        ByteBuffer bytebuffer = ByteBuffer.allocateDirect(par0).order(ByteOrder.nativeOrder());
        return bytebuffer;
    }

    public static IntBuffer createDirectIntBuffer(int par0) {
        return GLAllocation.createDirectByteBuffer(par0 << 2).asIntBuffer();
    }

    public static FloatBuffer createDirectFloatBuffer(int par0) {
        return GLAllocation.createDirectByteBuffer(par0 << 2).asFloatBuffer();
    }
}

