/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GenLayerAddIsland;
import net.minecraft.src.GenLayerAddMushroomIsland;
import net.minecraft.src.GenLayerAddSnow;
import net.minecraft.src.GenLayerBiome;
import net.minecraft.src.GenLayerFuzzyZoom;
import net.minecraft.src.GenLayerHills;
import net.minecraft.src.GenLayerIsland;
import net.minecraft.src.GenLayerRiver;
import net.minecraft.src.GenLayerRiverInit;
import net.minecraft.src.GenLayerRiverMix;
import net.minecraft.src.GenLayerShore;
import net.minecraft.src.GenLayerSmooth;
import net.minecraft.src.GenLayerSwampRivers;
import net.minecraft.src.GenLayerVoronoiZoom;
import net.minecraft.src.GenLayerZoom;
import net.minecraft.src.WorldType;

public abstract class GenLayer {
    private long worldGenSeed;
    protected GenLayer parent;
    private long chunkSeed;
    private long baseSeed;

    public static GenLayer[] func_48425_a(long par0, WorldType par2WorldType) {
        GenLayer obj = new GenLayerIsland(1L);
        obj = new GenLayerFuzzyZoom(2000L, obj);
        obj = new GenLayerAddIsland(1L, obj);
        obj = new GenLayerZoom(2001L, obj);
        obj = new GenLayerAddIsland(2L, obj);
        obj = new GenLayerAddSnow(2L, obj);
        obj = new GenLayerZoom(2002L, obj);
        obj = new GenLayerAddIsland(3L, obj);
        obj = new GenLayerZoom(2003L, obj);
        obj = new GenLayerAddIsland(4L, obj);
        obj = new GenLayerAddMushroomIsland(5L, obj);
        int byte0 = 4;
        GenLayer obj1 = obj;
        obj1 = GenLayerZoom.func_35515_a(1000L, obj1, 0);
        obj1 = new GenLayerRiverInit(100L, obj1);
        obj1 = GenLayerZoom.func_35515_a(1000L, obj1, byte0 + 2);
        obj1 = new GenLayerRiver(1L, obj1);
        obj1 = new GenLayerSmooth(1000L, obj1);
        GenLayer obj2 = obj;
        obj2 = GenLayerZoom.func_35515_a(1000L, obj2, 0);
        obj2 = new GenLayerBiome(200L, obj2, par2WorldType);
        obj2 = GenLayerZoom.func_35515_a(1000L, obj2, 2);
        obj2 = new GenLayerHills(1000L, obj2);
        for (int i = 0; i < byte0; ++i) {
            obj2 = new GenLayerZoom(1000 + i, obj2);
            if (i == 0) {
                obj2 = new GenLayerAddIsland(3L, obj2);
            }
            if (i == 1) {
                obj2 = new GenLayerShore(1000L, obj2);
            }
            if (i != 1) continue;
            obj2 = new GenLayerSwampRivers(1000L, obj2);
        }
        obj2 = new GenLayerSmooth(1000L, obj2);
        obj2 = new GenLayerRiverMix(100L, obj2, obj1);
        GenLayerRiverMix genlayerrivermix = (GenLayerRiverMix)obj2;
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, obj2);
        obj2.initWorldGenSeed(par0);
        genlayervoronoizoom.initWorldGenSeed(par0);
        return new GenLayer[]{obj2, genlayervoronoizoom, genlayerrivermix};
    }

    public GenLayer(long par1) {
        this.baseSeed = par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
    }

    public void initWorldGenSeed(long par1) {
        this.worldGenSeed = par1;
        if (this.parent != null) {
            this.parent.initWorldGenSeed(par1);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    public void initChunkSeed(long par1, long par3) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par1;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par3;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par1;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par3;
    }

    protected int nextInt(int par1) {
        int i = (int)((this.chunkSeed >> 24) % (long)par1);
        if (i < 0) {
            i += par1;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return i;
    }

    public abstract int[] getInts(int var1, int var2, int var3, int var4);
}

