/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Achievement;
import net.minecraft.src.Gui;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiAchievement
extends Gui {
    private Minecraft theGame;
    private int achievementWindowWidth;
    private int achievementWindowHeight;
    private String achievementGetLocalText;
    private String achievementStatName;
    private Achievement theAchievement;
    private long achievementTime;
    private RenderItem itemRender;
    private boolean haveAchiement;

    public GuiAchievement(Minecraft par1Minecraft) {
        this.theGame = par1Minecraft;
        this.itemRender = new RenderItem();
    }

    public void queueTakenAchievement(Achievement par1Achievement) {
        this.achievementGetLocalText = StatCollector.translateToLocal("achievement.get");
        this.achievementStatName = StatCollector.translateToLocal(par1Achievement.getName());
        this.achievementTime = System.currentTimeMillis();
        this.theAchievement = par1Achievement;
        this.haveAchiement = false;
    }

    public void queueAchievementInformation(Achievement par1Achievement) {
        this.achievementGetLocalText = StatCollector.translateToLocal(par1Achievement.getName());
        this.achievementStatName = par1Achievement.getDescription();
        this.achievementTime = System.currentTimeMillis() - 2500L;
        this.theAchievement = par1Achievement;
        this.haveAchiement = true;
    }

    private void updateAchievementWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.theGame.displayWidth, (int)this.theGame.displayHeight);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.achievementWindowWidth = this.theGame.displayWidth;
        this.achievementWindowHeight = this.theGame.displayHeight;
        ScaledResolution scaledresolution = new ScaledResolution(this.theGame.gameSettings, this.theGame.displayWidth, this.theGame.displayHeight);
        this.achievementWindowWidth = scaledresolution.getScaledWidth();
        this.achievementWindowHeight = scaledresolution.getScaledHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.achievementWindowWidth, (double)this.achievementWindowHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void updateAchievementWindow() {
        if (this.theAchievement == null || this.achievementTime == 0L) {
            return;
        }
        double d = (double)(System.currentTimeMillis() - this.achievementTime) / 3000.0;
        if (!this.haveAchiement && (d < 0.0 || d > 1.0)) {
            this.achievementTime = 0L;
            return;
        }
        this.updateAchievementWindowScale();
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        double d1 = d * 2.0;
        if (d1 > 1.0) {
            d1 = 2.0 - d1;
        }
        d1 *= 4.0;
        if ((d1 = 1.0 - d1) < 0.0) {
            d1 = 0.0;
        }
        d1 *= d1;
        d1 *= d1;
        int i = this.achievementWindowWidth - 160;
        int j = 0 - (int)(d1 * 36.0);
        int k = this.theGame.renderEngine.getTexture("/achievement/bg.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)k);
        GL11.glDisable((int)2896);
        this.drawTexturedModalRect(i, j, 96, 202, 160, 32);
        if (this.haveAchiement) {
            this.theGame.fontRenderer.drawSplitString(this.achievementStatName, i + 30, j + 7, 120, -1);
        } else {
            this.theGame.fontRenderer.drawString(this.achievementGetLocalText, i + 30, j + 7, -256);
            this.theGame.fontRenderer.drawString(this.achievementStatName, i + 30, j + 18, -1);
        }
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        this.itemRender.renderItemIntoGUI(this.theGame.fontRenderer, this.theGame.renderEngine, this.theAchievement.theItemStack, i + 8, j + 8);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }
}

