/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Collection;
import net.minecraft.src.AchievementList;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiAchievements;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiContainerCreative;
import net.minecraft.src.GuiStats;
import net.minecraft.src.Potion;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderManager;
import net.minecraft.src.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiInventory
extends GuiContainer {
    private float xSize_lo;
    private float ySize_lo;

    public GuiInventory(EntityPlayer par1EntityPlayer) {
        super(par1EntityPlayer.inventorySlots);
        this.allowUserInput = true;
        par1EntityPlayer.addStat(AchievementList.openInventory, 1);
    }

    @Override
    public void updateScreen() {
        if (this.mc.playerController.isInCreativeMode()) {
            this.mc.displayGuiScreen(new GuiContainerCreative(this.mc.thePlayer));
        }
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        if (this.mc.playerController.isInCreativeMode()) {
            this.mc.displayGuiScreen(new GuiContainerCreative(this.mc.thePlayer));
        } else {
            super.initGui();
            if (!this.mc.thePlayer.getActivePotionEffects().isEmpty()) {
                this.guiLeft = 160 + (this.width - this.xSize - 200) / 2;
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.fontRenderer.drawString(StatCollector.translateToLocal("container.crafting"), 86, 16, 0x404040);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        super.drawScreen(par1, par2, par3);
        this.xSize_lo = par1;
        this.ySize_lo = par2;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        int i = this.mc.renderEngine.getTexture("/gui/inventory.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i);
        int j = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        this.displayDebuffEffects();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(j + 51), (float)(k + 75), (float)50.0f);
        float f = 30.0f;
        GL11.glScalef((float)(-f), (float)f, (float)f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = this.mc.thePlayer.renderYawOffset;
        float f2 = this.mc.thePlayer.rotationYaw;
        float f3 = this.mc.thePlayer.rotationPitch;
        float f4 = (float)(j + 51) - this.xSize_lo;
        float f5 = (float)(k + 75 - 50) - this.ySize_lo;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(f5 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.mc.thePlayer.renderYawOffset = (float)Math.atan(f4 / 40.0f) * 20.0f;
        this.mc.thePlayer.rotationYaw = (float)Math.atan(f4 / 40.0f) * 40.0f;
        this.mc.thePlayer.rotationPitch = -((float)Math.atan(f5 / 40.0f)) * 20.0f;
        this.mc.thePlayer.rotationYawHead = this.mc.thePlayer.rotationYaw;
        GL11.glTranslatef((float)0.0f, (float)this.mc.thePlayer.yOffset, (float)0.0f);
        RenderManager.instance.playerViewY = 180.0f;
        RenderManager.instance.renderEntityWithPosYaw(this.mc.thePlayer, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        this.mc.thePlayer.renderYawOffset = f1;
        this.mc.thePlayer.rotationYaw = f2;
        this.mc.thePlayer.rotationPitch = f3;
        GL11.glPopMatrix();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)32826);
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.id == 0) {
            this.mc.displayGuiScreen(new GuiAchievements(this.mc.statFileWriter));
        }
        if (par1GuiButton.id == 1) {
            this.mc.displayGuiScreen(new GuiStats(this, this.mc.statFileWriter));
        }
    }

    private void displayDebuffEffects() {
        int i = this.guiLeft - 124;
        int j = this.guiTop;
        int k = this.mc.renderEngine.getTexture("/gui/inventory.png");
        Collection collection = this.mc.thePlayer.getActivePotionEffects();
        if (collection.isEmpty()) {
            return;
        }
        int l = 33;
        if (collection.size() > 5) {
            l = 132 / (collection.size() - 1);
        }
        for (PotionEffect potioneffect : this.mc.thePlayer.getActivePotionEffects()) {
            Potion potion = Potion.potionTypes[potioneffect.getPotionID()];
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.renderEngine.bindTexture(k);
            this.drawTexturedModalRect(i, j, 0, this.ySize, 140, 32);
            if (potion.hasStatusIcon()) {
                int i1 = potion.getStatusIconIndex();
                this.drawTexturedModalRect(i + 6, j + 7, 0 + i1 % 8 * 18, this.ySize + 32 + i1 / 8 * 18, 18, 18);
            }
            String s = StatCollector.translateToLocal(potion.getName());
            if (potioneffect.getAmplifier() == 1) {
                s = s + " II";
            } else if (potioneffect.getAmplifier() == 2) {
                s = s + " III";
            } else if (potioneffect.getAmplifier() == 3) {
                s = s + " IV";
            }
            this.fontRenderer.drawStringWithShadow(s, i + 10 + 18, j + 6, 0xFFFFFF);
            String s1 = Potion.getDurationString(potioneffect);
            this.fontRenderer.drawStringWithShadow(s1, i + 10 + 18, j + 6 + 10, 0x7F7F7F);
            j += l;
        }
    }
}

