/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiButtonLanguage;
import net.minecraft.src.GuiLanguage;
import net.minecraft.src.GuiMultiplayer;
import net.minecraft.src.GuiOptions;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSelectWorld;
import net.minecraft.src.GuiTexturePacks;
import net.minecraft.src.MathHelper;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GuiMainMenu
extends GuiScreen {
    private static final Random rand = new Random();
    private float updateCounter = 0.0f;
    private String splashText = "missingno";
    private GuiButton multiplayerButton;
    private int panoramaTimer = 0;
    private int viewportTexture;

    public GuiMainMenu() {
        try {
            String s1;
            ArrayList<String> arraylist = new ArrayList<String>();
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(GuiMainMenu.class.getResourceAsStream("/title/splashes.txt"), Charset.forName("UTF-8")));
            String s = "";
            while ((s1 = bufferedreader.readLine()) != null) {
                if ((s1 = s1.trim()).length() <= 0) continue;
                arraylist.add(s1);
            }
            do {
                this.splashText = (String)arraylist.get(rand.nextInt(arraylist.size()));
            } while (this.splashText.hashCode() == 125780783);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateCounter = rand.nextFloat();
    }

    @Override
    public void updateScreen() {
        ++this.panoramaTimer;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    protected void keyTyped(char c, int i) {
    }

    @Override
    public void initGui() {
        this.viewportTexture = this.mc.renderEngine.allocateAndSetupTexture(new BufferedImage(256, 256, 2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 11 && calendar.get(5) == 9) {
            this.splashText = "Happy birthday, ez!";
        } else if (calendar.get(2) + 1 == 6 && calendar.get(5) == 1) {
            this.splashText = "Happy birthday, Notch!";
        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            this.splashText = "Merry X-mas!";
        } else if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            this.splashText = "Happy new year!";
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        int i = this.height / 4 + 48;
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, i, stringtranslate.translateKey("menu.singleplayer")));
        this.multiplayerButton = new GuiButton(2, this.width / 2 - 100, i + 24, stringtranslate.translateKey("menu.multiplayer"));
        this.controlList.add(this.multiplayerButton);
        this.controlList.add(new GuiButton(3, this.width / 2 - 100, i + 48, stringtranslate.translateKey("menu.mods")));
        if (this.mc.hideQuitButton) {
            this.controlList.add(new GuiButton(0, this.width / 2 - 100, i + 72, stringtranslate.translateKey("menu.options")));
        } else {
            this.controlList.add(new GuiButton(0, this.width / 2 - 100, i + 72 + 12, 98, 20, stringtranslate.translateKey("menu.options")));
            this.controlList.add(new GuiButton(4, this.width / 2 + 2, i + 72 + 12, 98, 20, stringtranslate.translateKey("menu.quit")));
        }
        this.controlList.add(new GuiButtonLanguage(5, this.width / 2 - 124, i + 72 + 12));
        if (this.mc.session == null) {
            this.multiplayerButton.enabled = false;
        }
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.id == 0) {
            this.mc.displayGuiScreen(new GuiOptions(this, this.mc.gameSettings));
        }
        if (par1GuiButton.id == 5) {
            this.mc.displayGuiScreen(new GuiLanguage(this, this.mc.gameSettings));
        }
        if (par1GuiButton.id == 1) {
            this.mc.displayGuiScreen(new GuiSelectWorld(this));
        }
        if (par1GuiButton.id == 2) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this));
        }
        if (par1GuiButton.id == 3) {
            this.mc.displayGuiScreen(new GuiTexturePacks(this));
        }
        if (par1GuiButton.id == 4) {
            this.mc.shutdown();
        }
    }

    private void drawPanorama(int par1, int par2, float par3) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        int i = 8;
        for (int j = 0; j < i * i; ++j) {
            GL11.glPushMatrix();
            float f = ((float)(j % i) / (float)i - 0.5f) / 64.0f;
            float f1 = ((float)(j / i) / (float)i - 0.5f) / 64.0f;
            float f2 = 0.0f;
            GL11.glTranslatef((float)f, (float)f1, (float)f2);
            GL11.glRotatef((float)(MathHelper.sin(((float)this.panoramaTimer + par3) / 400.0f) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)this.panoramaTimer + par3) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int k = 0; k < 6; ++k) {
                GL11.glPushMatrix();
                if (k == 1) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 3) {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 4) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (k == 5) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/bg/panorama" + k + ".png"));
                tessellator.startDrawingQuads();
                tessellator.setColorRGBA_I(0xFFFFFF, 255 / (j + 1));
                float f3 = 0.0f;
                tessellator.addVertexWithUV(-1.0, -1.0, 1.0, 0.0f + f3, 0.0f + f3);
                tessellator.addVertexWithUV(1.0, -1.0, 1.0, 1.0f - f3, 0.0f + f3);
                tessellator.addVertexWithUV(1.0, 1.0, 1.0, 1.0f - f3, 1.0f - f3);
                tessellator.addVertexWithUV(-1.0, 1.0, 1.0, 0.0f + f3, 1.0f - f3);
                tessellator.draw();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        tessellator.setTranslation(0.0, 0.0, 0.0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2929);
    }

    private void rotateAndBlurSkybox(float par1) {
        GL11.glBindTexture((int)3553, (int)this.viewportTexture);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        int byte0 = 3;
        for (int i = 0; i < byte0; ++i) {
            tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f / (float)(i + 1));
            int j = this.width;
            int k = this.height;
            float f = (float)(i - byte0 / 2) / 256.0f;
            tessellator.addVertexWithUV(j, k, this.zLevel, 0.0f + f, 0.0);
            tessellator.addVertexWithUV(j, 0.0, this.zLevel, 1.0f + f, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, this.zLevel, 1.0f + f, 1.0);
            tessellator.addVertexWithUV(0.0, k, this.zLevel, 0.0f + f, 1.0);
        }
        tessellator.draw();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void renderSkybox(int par1, int par2, float par3) {
        GL11.glViewport((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(par1, par2, par3);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3553);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        float f = this.width <= this.height ? 120.0f / (float)this.height : 120.0f / (float)this.width;
        float f1 = (float)this.height * f / 256.0f;
        float f2 = (float)this.width * f / 256.0f;
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.width;
        int j = this.height;
        tessellator.addVertexWithUV(0.0, j, this.zLevel, 0.5f - f1, 0.5f + f2);
        tessellator.addVertexWithUV(i, j, this.zLevel, 0.5f - f1, 0.5f - f2);
        tessellator.addVertexWithUV(i, 0.0, this.zLevel, 0.5f + f1, 0.5f - f2);
        tessellator.addVertexWithUV(0.0, 0.0, this.zLevel, 0.5f + f1, 0.5f + f2);
        tessellator.draw();
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.renderSkybox(par1, par2, par3);
        Tessellator tessellator = Tessellator.instance;
        int c = 274;
        int i = this.width / 2 - c / 2;
        int byte0 = 30;
        this.drawGradientRect(0, 0, this.width, this.height, -2130706433, 0xFFFFFF);
        this.drawGradientRect(0, 0, this.width, this.height, 0, Integer.MIN_VALUE);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/mclogo.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if ((double)this.updateCounter < 1.0E-4) {
            this.drawTexturedModalRect(i + 0, byte0 + 0, 0, 0, 99, 44);
            this.drawTexturedModalRect(i + 99, byte0 + 0, 129, 0, 27, 44);
            this.drawTexturedModalRect(i + 99 + 26, byte0 + 0, 126, 0, 3, 44);
            this.drawTexturedModalRect(i + 99 + 26 + 3, byte0 + 0, 99, 0, 26, 44);
            this.drawTexturedModalRect(i + 155, byte0 + 0, 0, 45, 155, 44);
        } else {
            this.drawTexturedModalRect(i + 0, byte0 + 0, 0, 0, 155, 44);
            this.drawTexturedModalRect(i + 155, byte0 + 0, 0, 45, 155, 44);
        }
        tessellator.setColorOpaque_I(0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2 + 90), (float)70.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = 1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        f = f * 100.0f / (float)(this.fontRenderer.getStringWidth(this.splashText) + 32);
        GL11.glScalef((float)f, (float)f, (float)f);
        this.drawCenteredString(this.fontRenderer, this.splashText, 0, -8, 0xFFFF00);
        GL11.glPopMatrix();
        this.drawString(this.fontRenderer, "Minecraft 1.2.5", 2, this.height - 10, 0xFFFFFF);
        String s = "Copyright Mojang AB. Do not distribute!";
        this.drawString(this.fontRenderer, s, this.width - this.fontRenderer.getStringWidth(s) - 2, this.height - 10, 0xFFFFFF);
        super.drawScreen(par1, par2, par3);
    }
}

