/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiConnecting;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiScreenAddServer;
import net.minecraft.src.GuiScreenServerList;
import net.minecraft.src.GuiSlotServer;
import net.minecraft.src.GuiYesNo;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Packet;
import net.minecraft.src.ServerNBTStorage;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StringTranslate;
import org.lwjgl.input.Keyboard;

public class GuiMultiplayer
extends GuiScreen {
    private static int threadsPending = 0;
    private static Object lock = new Object();
    private GuiScreen parentScreen;
    private GuiSlotServer serverSlotContainer;
    private List serverList = new ArrayList();
    private int selectedServer = -1;
    private GuiButton buttonEdit;
    private GuiButton buttonSelect;
    private GuiButton buttonDelete;
    private boolean deleteClicked = false;
    private boolean addClicked = false;
    private boolean editClicked = false;
    private boolean directClicked = false;
    private String lagTooltip = null;
    private ServerNBTStorage tempServer = null;

    public GuiMultiplayer(GuiScreen par1GuiScreen) {
        this.parentScreen = par1GuiScreen;
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public void initGui() {
        this.loadServerList();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.serverSlotContainer = new GuiSlotServer(this);
        this.initGuiControls();
    }

    private void loadServerList() {
        try {
            NBTTagCompound nbttagcompound = CompressedStreamTools.read(new File(this.mc.mcDataDir, "servers.dat"));
            NBTTagList nbttaglist = nbttagcompound.getTagList("servers");
            this.serverList.clear();
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                this.serverList.add(ServerNBTStorage.createServerNBTStorage((NBTTagCompound)nbttaglist.tagAt(i)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveServerList() {
        try {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.serverList.size(); ++i) {
                nbttaglist.appendTag(((ServerNBTStorage)this.serverList.get(i)).getCompoundTag());
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setTag("servers", nbttaglist);
            CompressedStreamTools.safeWrite(nbttagcompound, new File(this.mc.mcDataDir, "servers.dat"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initGuiControls() {
        boolean flag;
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.buttonEdit = new GuiButton(7, this.width / 2 - 154, this.height - 28, 70, 20, stringtranslate.translateKey("selectServer.edit"));
        this.controlList.add(this.buttonEdit);
        this.buttonDelete = new GuiButton(2, this.width / 2 - 74, this.height - 28, 70, 20, stringtranslate.translateKey("selectServer.delete"));
        this.controlList.add(this.buttonDelete);
        this.buttonSelect = new GuiButton(1, this.width / 2 - 154, this.height - 52, 100, 20, stringtranslate.translateKey("selectServer.select"));
        this.controlList.add(this.buttonSelect);
        this.controlList.add(new GuiButton(4, this.width / 2 - 50, this.height - 52, 100, 20, stringtranslate.translateKey("selectServer.direct")));
        this.controlList.add(new GuiButton(3, this.width / 2 + 4 + 50, this.height - 52, 100, 20, stringtranslate.translateKey("selectServer.add")));
        this.controlList.add(new GuiButton(8, this.width / 2 + 4, this.height - 28, 70, 20, stringtranslate.translateKey("selectServer.refresh")));
        this.controlList.add(new GuiButton(0, this.width / 2 + 4 + 76, this.height - 28, 75, 20, stringtranslate.translateKey("gui.cancel")));
        this.buttonSelect.enabled = flag = this.selectedServer >= 0 && this.selectedServer < this.serverSlotContainer.getSize();
        this.buttonEdit.enabled = flag;
        this.buttonDelete.enabled = flag;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == 2) {
            String s = ((ServerNBTStorage)this.serverList.get((int)this.selectedServer)).name;
            if (s != null) {
                this.deleteClicked = true;
                StringTranslate stringtranslate = StringTranslate.getInstance();
                String s1 = stringtranslate.translateKey("selectServer.deleteQuestion");
                String s2 = "'" + s + "' " + stringtranslate.translateKey("selectServer.deleteWarning");
                String s3 = stringtranslate.translateKey("selectServer.deleteButton");
                String s4 = stringtranslate.translateKey("gui.cancel");
                GuiYesNo guiyesno = new GuiYesNo(this, s1, s2, s3, s4, this.selectedServer);
                this.mc.displayGuiScreen(guiyesno);
            }
        } else if (par1GuiButton.id == 1) {
            this.joinServer(this.selectedServer);
        } else if (par1GuiButton.id == 4) {
            this.directClicked = true;
            this.tempServer = new ServerNBTStorage(StatCollector.translateToLocal("selectServer.defaultName"), "");
            this.mc.displayGuiScreen(new GuiScreenServerList(this, this.tempServer));
        } else if (par1GuiButton.id == 3) {
            this.addClicked = true;
            this.tempServer = new ServerNBTStorage(StatCollector.translateToLocal("selectServer.defaultName"), "");
            this.mc.displayGuiScreen(new GuiScreenAddServer(this, this.tempServer));
        } else if (par1GuiButton.id == 7) {
            this.editClicked = true;
            ServerNBTStorage servernbtstorage = (ServerNBTStorage)this.serverList.get(this.selectedServer);
            this.tempServer = new ServerNBTStorage(servernbtstorage.name, servernbtstorage.host);
            this.mc.displayGuiScreen(new GuiScreenAddServer(this, this.tempServer));
        } else if (par1GuiButton.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (par1GuiButton.id == 8) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this.parentScreen));
        } else {
            this.serverSlotContainer.actionPerformed(par1GuiButton);
        }
    }

    @Override
    public void confirmClicked(boolean par1, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.serverList.remove(par2);
                this.saveServerList();
            }
            this.mc.displayGuiScreen(this);
        } else if (this.directClicked) {
            this.directClicked = false;
            if (par1) {
                this.joinServer(this.tempServer);
            } else {
                this.mc.displayGuiScreen(this);
            }
        } else if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.serverList.add(this.tempServer);
                this.saveServerList();
            }
            this.mc.displayGuiScreen(this);
        } else if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                ServerNBTStorage servernbtstorage = (ServerNBTStorage)this.serverList.get(this.selectedServer);
                servernbtstorage.name = this.tempServer.name;
                servernbtstorage.host = this.tempServer.host;
                this.saveServerList();
            }
            this.mc.displayGuiScreen(this);
        }
    }

    private int parseIntWithDefault(String par1Str, int par2) {
        try {
            return Integer.parseInt(par1Str.trim());
        }
        catch (Exception exception) {
            return par2;
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        if (par1 == '\r') {
            this.actionPerformed((GuiButton)this.controlList.get(2));
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) {
        super.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.lagTooltip = null;
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.serverSlotContainer.drawScreen(par1, par2, par3);
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("multiplayer.title"), this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(par1, par2, par3);
        if (this.lagTooltip != null) {
            this.func_35325_a(this.lagTooltip, par1, par2);
        }
    }

    private void joinServer(int par1) {
        this.joinServer((ServerNBTStorage)this.serverList.get(par1));
    }

    private void joinServer(ServerNBTStorage par1ServerNBTStorage) {
        int i;
        String s = par1ServerNBTStorage.host;
        String[] as = s.split(":");
        if (s.startsWith("[") && (i = s.indexOf("]")) > 0) {
            String s1 = s.substring(1, i);
            String s2 = s.substring(i + 1).trim();
            if (s2.startsWith(":") && s2.length() > 0) {
                s2 = s2.substring(1);
                as = new String[]{s1, s2};
            } else {
                as = new String[]{s1};
            }
        }
        if (as.length > 2) {
            as = new String[]{s};
        }
        this.mc.displayGuiScreen(new GuiConnecting(this.mc, as[0], as.length <= 1 ? 25565 : this.parseIntWithDefault(as[1], 25565)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollServer(ServerNBTStorage par1ServerNBTStorage) throws IOException {
        int i;
        String s = par1ServerNBTStorage.host;
        String[] as = s.split(":");
        if (s.startsWith("[") && (i = s.indexOf("]")) > 0) {
            String s2 = s.substring(1, i);
            String s3 = s.substring(i + 1).trim();
            if (s3.startsWith(":") && s3.length() > 0) {
                s3 = s3.substring(1);
                as = new String[]{s2, s3};
            } else {
                as = new String[]{s2};
            }
        }
        if (as.length > 2) {
            as = new String[]{s};
        }
        String s1 = as[0];
        int j = as.length <= 1 ? 25565 : this.parseIntWithDefault(as[1], 25565);
        Socket socket = null;
        FilterInputStream datainputstream = null;
        FilterOutputStream dataoutputstream = null;
        try {
            socket = new Socket();
            socket.setSoTimeout(3000);
            socket.setTcpNoDelay(true);
            socket.setTrafficClass(18);
            socket.connect(new InetSocketAddress(s1, j), 3000);
            datainputstream = new DataInputStream(socket.getInputStream());
            dataoutputstream = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)dataoutputstream).write(254);
            if (datainputstream.read() != 255) {
                throw new IOException("Bad message");
            }
            String s4 = Packet.readString((DataInputStream)datainputstream, 256);
            char[] ac = s4.toCharArray();
            for (int k = 0; k < ac.length; ++k) {
                if (ac[k] == '\u00a7' || ChatAllowedCharacters.allowedCharacters.indexOf(ac[k]) >= 0) continue;
                ac[k] = 63;
            }
            s4 = new String(ac);
            String[] as1 = s4.split("\u00a7");
            s4 = as1[0];
            int l = -1;
            int i1 = -1;
            try {
                l = Integer.parseInt(as1[1]);
                i1 = Integer.parseInt(as1[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            par1ServerNBTStorage.motd = "\u00a77" + s4;
            par1ServerNBTStorage.playerCount = l >= 0 && i1 > 0 ? "\u00a77" + l + "\u00a78/\u00a77" + i1 : "\u00a78???";
        }
        finally {
            try {
                if (datainputstream != null) {
                    datainputstream.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (dataoutputstream != null) {
                    dataoutputstream.close();
                }
            }
            catch (Throwable throwable1) {}
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable throwable2) {}
        }
    }

    protected void func_35325_a(String par1Str, int par2, int par3) {
        if (par1Str == null) {
            return;
        }
        int i = par2 + 12;
        int j = par3 - 12;
        int k = this.fontRenderer.getStringWidth(par1Str);
        this.drawGradientRect(i - 3, j - 3, i + k + 3, j + 8 + 3, -1073741824, -1073741824);
        this.fontRenderer.drawStringWithShadow(par1Str, i, j, -1);
    }

    static List getServerList(GuiMultiplayer par0GuiMultiplayer) {
        return par0GuiMultiplayer.serverList;
    }

    static int setSelectedServer(GuiMultiplayer par0GuiMultiplayer, int par1) {
        par0GuiMultiplayer.selectedServer = par1;
        return par0GuiMultiplayer.selectedServer;
    }

    static int getSelectedServer(GuiMultiplayer par0GuiMultiplayer) {
        return par0GuiMultiplayer.selectedServer;
    }

    static GuiButton getButtonSelect(GuiMultiplayer par0GuiMultiplayer) {
        return par0GuiMultiplayer.buttonSelect;
    }

    static GuiButton getButtonEdit(GuiMultiplayer par0GuiMultiplayer) {
        return par0GuiMultiplayer.buttonEdit;
    }

    static GuiButton getButtonDelete(GuiMultiplayer par0GuiMultiplayer) {
        return par0GuiMultiplayer.buttonDelete;
    }

    static void joinServer(GuiMultiplayer par0GuiMultiplayer, int par1) {
        par0GuiMultiplayer.joinServer(par1);
    }

    static Object getLock() {
        return lock;
    }

    static int getThreadsPending() {
        return threadsPending;
    }

    static int incrementThreadsPending() {
        return threadsPending++;
    }

    static void pollServer(GuiMultiplayer par0GuiMultiplayer, ServerNBTStorage par1ServerNBTStorage) throws IOException {
        par0GuiMultiplayer.pollServer(par1ServerNBTStorage);
    }

    static int decrementThreadsPending() {
        return threadsPending--;
    }

    static String setTooltipText(GuiMultiplayer par0GuiMultiplayer, String par1Str) {
        par0GuiMultiplayer.lagTooltip = par1Str;
        return par0GuiMultiplayer.lagTooltip;
    }
}

