/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiTextField;
import net.minecraft.src.ServerNBTStorage;
import net.minecraft.src.StringTranslate;
import org.lwjgl.input.Keyboard;

public class GuiScreenAddServer
extends GuiScreen {
    private GuiScreen parentGui;
    private GuiTextField serverAddress;
    private GuiTextField serverName;
    private ServerNBTStorage serverNBTStorage;

    public GuiScreenAddServer(GuiScreen par1GuiScreen, ServerNBTStorage par2ServerNBTStorage) {
        this.parentGui = par1GuiScreen;
        this.serverNBTStorage = par2ServerNBTStorage;
    }

    @Override
    public void updateScreen() {
        this.serverName.updateCursorCounter();
        this.serverAddress.updateCursorCounter();
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("addServer.add")));
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.cancel")));
        this.serverName = new GuiTextField(this.fontRenderer, this.width / 2 - 100, 76, 200, 20);
        this.serverName.setFocused(true);
        this.serverName.setText(this.serverNBTStorage.name);
        this.serverAddress = new GuiTextField(this.fontRenderer, this.width / 2 - 100, 116, 200, 20);
        this.serverAddress.setMaxStringLength(128);
        this.serverAddress.setText(this.serverNBTStorage.host);
        ((GuiButton)this.controlList.get((int)0)).enabled = this.serverAddress.getText().length() > 0 && this.serverAddress.getText().split(":").length > 0 && this.serverName.getText().length() > 0;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == 1) {
            this.parentGui.confirmClicked(false, 0);
        } else if (par1GuiButton.id == 0) {
            this.serverNBTStorage.name = this.serverName.getText();
            this.serverNBTStorage.host = this.serverAddress.getText();
            this.parentGui.confirmClicked(true, 0);
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        String s;
        String[] as;
        this.serverName.textboxKeyTyped(par1, par2);
        this.serverAddress.textboxKeyTyped(par1, par2);
        if (par1 == '\t') {
            if (this.serverName.getIsFocused()) {
                this.serverName.setFocused(false);
                this.serverAddress.setFocused(true);
            } else {
                this.serverName.setFocused(true);
                this.serverAddress.setFocused(false);
            }
        }
        if (par1 == '\r') {
            this.actionPerformed((GuiButton)this.controlList.get(0));
        }
        boolean bl = ((GuiButton)this.controlList.get((int)0)).enabled = this.serverAddress.getText().length() > 0 && this.serverAddress.getText().split(":").length > 0 && this.serverName.getText().length() > 0;
        if (((GuiButton)this.controlList.get((int)0)).enabled && (as = (s = this.serverAddress.getText().trim()).split(":")).length > 2) {
            ((GuiButton)this.controlList.get((int)0)).enabled = false;
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) {
        super.mouseClicked(par1, par2, par3);
        this.serverAddress.mouseClicked(par1, par2, par3);
        this.serverName.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("addServer.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("addServer.enterName"), this.width / 2 - 100, 63, 0xA0A0A0);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("addServer.enterIp"), this.width / 2 - 100, 104, 0xA0A0A0);
        this.serverName.drawTextBox();
        this.serverAddress.drawTextBox();
        super.drawScreen(par1, par2, par3);
    }
}

