/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiSlot {
    private final Minecraft mc;
    private final int width;
    private final int height;
    protected final int top;
    protected final int bottom;
    private final int right;
    private final int left = 0;
    protected final int slotHeight;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    protected int mouseX;
    protected int mouseY;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;

    public GuiSlot(Minecraft par1Minecraft, int par2, int par3, int par4, int par5, int par6) {
        this.mc = par1Minecraft;
        this.width = par2;
        this.height = par3;
        this.top = par4;
        this.bottom = par5;
        this.slotHeight = par6;
        this.right = par2;
    }

    public void func_27258_a(boolean par1) {
        this.field_25123_p = par1;
    }

    protected void func_27259_a(boolean par1, int par2) {
        this.field_27262_q = par1;
        this.field_27261_r = par2;
        if (!par1) {
            this.field_27261_r = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.field_27261_r;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void func_27260_a(int i, int j, Tessellator tessellator) {
    }

    protected void func_27255_a(int i, int j) {
    }

    protected void func_27257_b(int i, int j) {
    }

    public int func_27256_c(int par1, int par2) {
        int i = this.width / 2 - 110;
        int j = this.width / 2 + 110;
        int k = par2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
        int l = k / this.slotHeight;
        if (par1 >= i && par1 <= j && l >= 0 && k >= 0 && l < this.getSize()) {
            return l;
        }
        return -1;
    }

    public void registerScrollButtons(List par1List, int par2, int par3) {
        this.scrollUpButtonID = par2;
        this.scrollDownButtonID = par3;
    }

    private void bindAmountScrolled() {
        int i = this.getContentHeight() - (this.bottom - this.top - 4);
        if (i < 0) {
            i /= 2;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)i) {
            this.amountScrolled = i;
        }
    }

    public void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == this.scrollUpButtonID) {
            this.amountScrolled -= (float)(this.slotHeight * 2 / 3);
            this.initialClickY = -2.0f;
            this.bindAmountScrolled();
        } else if (par1GuiButton.id == this.scrollDownButtonID) {
            this.amountScrolled += (float)(this.slotHeight * 2 / 3);
            this.initialClickY = -2.0f;
            this.bindAmountScrolled();
        }
    }

    public void drawScreen(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        this.drawBackground();
        int i = this.getSize();
        int j = this.width / 2 + 124;
        int k = j + 6;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialClickY == -1.0f) {
                boolean flag = true;
                if (par2 >= this.top && par2 <= this.bottom) {
                    int i1 = this.width / 2 - 110;
                    int j1 = this.width / 2 + 110;
                    int l1 = par2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
                    int j2 = l1 / this.slotHeight;
                    if (par1 >= i1 && par1 <= j1 && j2 >= 0 && l1 >= 0 && j2 < i) {
                        boolean flag1 = j2 == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.elementClicked(j2, flag1);
                        this.selectedElement = j2;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (par1 >= i1 && par1 <= j1 && l1 < 0) {
                        this.func_27255_a(par1 - i1, par2 - this.top + (int)this.amountScrolled - 4);
                        flag = false;
                    }
                    if (par1 >= j && par1 <= k) {
                        int k3;
                        this.scrollMultiplier = -1.0f;
                        int l2 = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (l2 < 1) {
                            l2 = 1;
                        }
                        if ((k3 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            k3 = 32;
                        }
                        if (k3 > this.bottom - this.top - 8) {
                            k3 = this.bottom - this.top - 8;
                        }
                        this.scrollMultiplier /= (float)(this.bottom - this.top - k3) / (float)l2;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.initialClickY = flag ? (float)par2 : -2.0f;
                } else {
                    this.initialClickY = -2.0f;
                }
            } else if (this.initialClickY >= 0.0f) {
                this.amountScrolled -= ((float)par2 - this.initialClickY) * this.scrollMultiplier;
                this.initialClickY = par2;
            }
        } else {
            while (Mouse.next()) {
                int l = Mouse.getEventDWheel();
                if (l == 0) continue;
                if (l > 0) {
                    l = -1;
                } else if (l < 0) {
                    l = 1;
                }
                this.amountScrolled += (float)(l * this.slotHeight / 2);
            }
            this.initialClickY = -1.0f;
        }
        this.bindAmountScrolled();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x202020);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0f / f, (float)(this.bottom + (int)this.amountScrolled) / f);
        tessellator.addVertexWithUV(this.right, this.bottom, 0.0, (float)this.right / f, (float)(this.bottom + (int)this.amountScrolled) / f);
        tessellator.addVertexWithUV(this.right, this.top, 0.0, (float)this.right / f, (float)(this.top + (int)this.amountScrolled) / f);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0f / f, (float)(this.top + (int)this.amountScrolled) / f);
        tessellator.draw();
        int k1 = this.width / 2 - 92 - 16;
        int i2 = this.top + 4 - (int)this.amountScrolled;
        if (this.field_27262_q) {
            this.func_27260_a(k1, i2, tessellator);
        }
        for (int k2 = 0; k2 < i; ++k2) {
            int i3 = i2 + k2 * this.slotHeight + this.field_27261_r;
            int l3 = this.slotHeight - 4;
            if (i3 > this.bottom || i3 + l3 < this.top) continue;
            if (this.field_25123_p && this.isSelected(k2)) {
                int j4 = this.width / 2 - 110;
                int l4 = this.width / 2 + 110;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(0x808080);
                tessellator.addVertexWithUV(j4, i3 + l3 + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(l4, i3 + l3 + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(l4, i3 - 2, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(j4, i3 - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(j4 + 1, i3 + l3 + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(l4 - 1, i3 + l3 + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(l4 - 1, i3 - 1, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(j4 + 1, i3 - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            this.drawSlot(k2, k1, i3, l3, tessellator);
        }
        GL11.glDisable((int)2929);
        int byte0 = 4;
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(0.0, this.top + byte0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.right, this.top + byte0, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(this.right, this.top, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.right, this.bottom, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(this.right, this.bottom - byte0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.bottom - byte0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int j3 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (j3 > 0) {
            int k4;
            int i4 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (i4 < 32) {
                i4 = 32;
            }
            if (i4 > this.bottom - this.top - 8) {
                i4 = this.bottom - this.top - 8;
            }
            if ((k4 = (int)this.amountScrolled * (this.bottom - this.top - i4) / j3 + this.top) < this.top) {
                k4 = this.top;
            }
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(j, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(k, this.bottom, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(k, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(j, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0x808080, 255);
            tessellator.addVertexWithUV(j, k4 + i4, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(k, k4 + i4, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(k, k4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(j, k4, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0xC0C0C0, 255);
            tessellator.addVertexWithUV(j, k4 + i4 - 1, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(k - 1, k4 + i4 - 1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(k - 1, k4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(j, k4, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        this.func_27257_b(par1, par2);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void overlayBackground(int par1, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0x404040, par4);
        tessellator.addVertexWithUV(0.0, par2, 0.0, 0.0, (float)par2 / f);
        tessellator.addVertexWithUV(this.width, par2, 0.0, (float)this.width / f, (float)par2 / f);
        tessellator.setColorRGBA_I(0x404040, par3);
        tessellator.addVertexWithUV(this.width, par1, 0.0, (float)this.width / f, (float)par1 / f);
        tessellator.addVertexWithUV(0.0, par1, 0.0, 0.0, (float)par1 / f);
        tessellator.draw();
    }
}

