/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSlot;
import net.minecraft.src.GuiSlotStatsBlock;
import net.minecraft.src.GuiSlotStatsGeneral;
import net.minecraft.src.GuiSlotStatsItem;
import net.minecraft.src.Item;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatFileWriter;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class GuiStats
extends GuiScreen {
    private static RenderItem renderItem = new RenderItem();
    protected GuiScreen parentGui;
    protected String statsTitle = "Select world";
    private GuiSlotStatsGeneral slotGeneral;
    private GuiSlotStatsItem slotItem;
    private GuiSlotStatsBlock slotBlock;
    private StatFileWriter statFileWriter;
    private GuiSlot selectedSlot = null;

    public GuiStats(GuiScreen par1GuiScreen, StatFileWriter par2StatFileWriter) {
        this.parentGui = par1GuiScreen;
        this.statFileWriter = par2StatFileWriter;
    }

    @Override
    public void initGui() {
        this.statsTitle = StatCollector.translateToLocal("gui.stats");
        this.slotGeneral = new GuiSlotStatsGeneral(this);
        this.slotGeneral.registerScrollButtons(this.controlList, 1, 1);
        this.slotItem = new GuiSlotStatsItem(this);
        this.slotItem.registerScrollButtons(this.controlList, 1, 1);
        this.slotBlock = new GuiSlotStatsBlock(this);
        this.slotBlock.registerScrollButtons(this.controlList, 1, 1);
        this.selectedSlot = this.slotGeneral;
        this.addHeaderButtons();
    }

    public void addHeaderButtons() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, stringtranslate.translateKey("gui.done")));
        this.controlList.add(new GuiButton(1, this.width / 2 - 154, this.height - 52, 100, 20, stringtranslate.translateKey("stat.generalButton")));
        GuiButton guibutton = new GuiButton(2, this.width / 2 - 46, this.height - 52, 100, 20, stringtranslate.translateKey("stat.blocksButton"));
        this.controlList.add(guibutton);
        GuiButton guibutton1 = new GuiButton(3, this.width / 2 + 62, this.height - 52, 100, 20, stringtranslate.translateKey("stat.itemsButton"));
        this.controlList.add(guibutton1);
        if (this.slotBlock.getSize() == 0) {
            guibutton.enabled = false;
        }
        if (this.slotItem.getSize() == 0) {
            guibutton1.enabled = false;
        }
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == 0) {
            this.mc.displayGuiScreen(this.parentGui);
        } else if (par1GuiButton.id == 1) {
            this.selectedSlot = this.slotGeneral;
        } else if (par1GuiButton.id == 3) {
            this.selectedSlot = this.slotItem;
        } else if (par1GuiButton.id == 2) {
            this.selectedSlot = this.slotBlock;
        } else {
            this.selectedSlot.actionPerformed(par1GuiButton);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.selectedSlot.drawScreen(par1, par2, par3);
        this.drawCenteredString(this.fontRenderer, this.statsTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(par1, par2, par3);
    }

    private void drawItemSprite(int par1, int par2, int par3) {
        this.drawButtonBackground(par1 + 1, par2 + 1);
        GL11.glEnable((int)32826);
        RenderHelper.enableGUIStandardItemLighting();
        renderItem.drawItemIntoGui(this.fontRenderer, this.mc.renderEngine, par3, 0, Item.itemsList[par3].getIconFromDamage(0), par1 + 2, par2 + 2);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)32826);
    }

    private void drawButtonBackground(int par1, int par2) {
        this.drawSprite(par1, par2, 0, 0);
    }

    private void drawSprite(int par1, int par2, int par3, int par4) {
        int i = this.mc.renderEngine.getTexture("/gui/slot.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(par1 + 0, par2 + 18, this.zLevel, (float)(par3 + 0) * 0.0078125f, (float)(par4 + 18) * 0.0078125f);
        tessellator.addVertexWithUV(par1 + 18, par2 + 18, this.zLevel, (float)(par3 + 18) * 0.0078125f, (float)(par4 + 18) * 0.0078125f);
        tessellator.addVertexWithUV(par1 + 18, par2 + 0, this.zLevel, (float)(par3 + 18) * 0.0078125f, (float)(par4 + 0) * 0.0078125f);
        tessellator.addVertexWithUV(par1 + 0, par2 + 0, this.zLevel, (float)(par3 + 0) * 0.0078125f, (float)(par4 + 0) * 0.0078125f);
        tessellator.draw();
    }

    static Minecraft getMinecraft(GuiStats par0GuiStats) {
        return par0GuiStats.mc;
    }

    static FontRenderer getFontRenderer1(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static StatFileWriter getStatsFileWriter(GuiStats par0GuiStats) {
        return par0GuiStats.statFileWriter;
    }

    static FontRenderer getFontRenderer2(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static FontRenderer getFontRenderer3(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static Minecraft getMinecraft1(GuiStats par0GuiStats) {
        return par0GuiStats.mc;
    }

    static void drawSprite(GuiStats par0GuiStats, int par1, int par2, int par3, int par4) {
        par0GuiStats.drawSprite(par1, par2, par3, par4);
    }

    static Minecraft getMinecraft2(GuiStats par0GuiStats) {
        return par0GuiStats.mc;
    }

    static FontRenderer getFontRenderer4(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static FontRenderer getFontRenderer5(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static FontRenderer getFontRenderer6(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static FontRenderer getFontRenderer7(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static FontRenderer getFontRenderer8(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static void drawGradientRect(GuiStats par0GuiStats, int par1, int par2, int par3, int par4, int par5, int par6) {
        par0GuiStats.drawGradientRect(par1, par2, par3, par4, par5, par6);
    }

    static FontRenderer getFontRenderer9(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static FontRenderer getFontRenderer10(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static void drawGradientRect1(GuiStats par0GuiStats, int par1, int par2, int par3, int par4, int par5, int par6) {
        par0GuiStats.drawGradientRect(par1, par2, par3, par4, par5, par6);
    }

    static FontRenderer getFontRenderer11(GuiStats par0GuiStats) {
        return par0GuiStats.fontRenderer;
    }

    static void drawItemSprite(GuiStats par0GuiStats, int par1, int par2, int par3) {
        par0GuiStats.drawItemSprite(par1, par2, par3);
    }
}

