/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class GuiTextField
extends Gui {
    private final FontRenderer fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private String text = "";
    private int maxStringLength = 32;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean field_50045_k = true;
    private boolean isFocused = false;
    private boolean isEnabled = true;
    private int field_50041_n = 0;
    private int field_50042_o = 0;
    private int field_50048_p = 0;
    private int field_50047_q = 0xE0E0E0;
    private int field_50046_r = 0x707070;

    public GuiTextField(FontRenderer par1FontRenderer, int par2, int par3, int par4, int par5) {
        this.fontRenderer = par1FontRenderer;
        this.xPos = par2;
        this.yPos = par3;
        this.width = par4;
        this.height = par5;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setText(String par1Str) {
        this.text = par1Str.length() > this.maxStringLength ? par1Str.substring(0, this.maxStringLength) : par1Str;
        this.func_50038_e();
    }

    public String getText() {
        return this.text;
    }

    public String func_50039_c() {
        int i = this.field_50042_o >= this.field_50048_p ? this.field_50048_p : this.field_50042_o;
        int j = this.field_50042_o >= this.field_50048_p ? this.field_50042_o : this.field_50048_p;
        return this.text.substring(i, j);
    }

    public void func_50031_b(String par1Str) {
        String s = "";
        String s1 = ChatAllowedCharacters.func_52019_a(par1Str);
        int i = this.field_50042_o >= this.field_50048_p ? this.field_50048_p : this.field_50042_o;
        int j = this.field_50042_o >= this.field_50048_p ? this.field_50042_o : this.field_50048_p;
        int k = this.maxStringLength - this.text.length() - (i - this.field_50048_p);
        int l = 0;
        if (this.text.length() > 0) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        this.text = s;
        this.func_50023_d(i - this.field_50048_p + l);
    }

    public void func_50021_a(int par1) {
        if (this.text.length() == 0) {
            return;
        }
        if (this.field_50048_p != this.field_50042_o) {
            this.func_50031_b("");
            return;
        }
        this.func_50020_b(this.func_50028_c(par1) - this.field_50042_o);
    }

    public void func_50020_b(int par1) {
        if (this.text.length() == 0) {
            return;
        }
        if (this.field_50048_p != this.field_50042_o) {
            this.func_50031_b("");
            return;
        }
        boolean flag = par1 < 0;
        int i = flag ? this.field_50042_o + par1 : this.field_50042_o;
        int j = flag ? this.field_50042_o : this.field_50042_o + par1;
        String s = "";
        if (i >= 0) {
            s = this.text.substring(0, i);
        }
        if (j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        this.text = s;
        if (flag) {
            this.func_50023_d(par1);
        }
    }

    public int func_50028_c(int par1) {
        return this.func_50024_a(par1, this.func_50035_h());
    }

    public int func_50024_a(int par1, int par2) {
        int i = par2;
        boolean flag = par1 < 0;
        int j = Math.abs(par1);
        for (int k = 0; k < j; ++k) {
            if (flag) {
                while (i > 0 && this.text.charAt(i - 1) == ' ') {
                    --i;
                }
                while (i > 0 && this.text.charAt(i - 1) != ' ') {
                    --i;
                }
                continue;
            }
            int l = this.text.length();
            if ((i = this.text.indexOf(32, i)) == -1) {
                i = l;
                continue;
            }
            while (i < l && this.text.charAt(i) == ' ') {
                ++i;
            }
        }
        return i;
    }

    public void func_50023_d(int par1) {
        this.func_50030_e(this.field_50048_p + par1);
    }

    public void func_50030_e(int par1) {
        this.field_50042_o = par1;
        int i = this.text.length();
        if (this.field_50042_o < 0) {
            this.field_50042_o = 0;
        }
        if (this.field_50042_o > i) {
            this.field_50042_o = i;
        }
        this.func_50032_g(this.field_50042_o);
    }

    public void func_50034_d() {
        this.func_50030_e(0);
    }

    public void func_50038_e() {
        this.func_50030_e(this.text.length());
    }

    public boolean textboxKeyTyped(char par1, int par2) {
        if (!this.isEnabled || !this.isFocused) {
            return false;
        }
        switch (par1) {
            case '\u0001': {
                this.func_50038_e();
                this.func_50032_g(0);
                return true;
            }
            case '\u0003': {
                GuiScreen.setClipboardString(this.func_50039_c());
                return true;
            }
            case '\u0016': {
                this.func_50031_b(GuiScreen.getClipboardString());
                return true;
            }
            case '\u0018': {
                GuiScreen.setClipboardString(this.func_50039_c());
                this.func_50031_b("");
                return true;
            }
        }
        switch (par2) {
            case 203: {
                if (GuiScreen.func_50049_m()) {
                    if (GuiScreen.func_50051_l()) {
                        this.func_50032_g(this.func_50024_a(-1, this.func_50036_k()));
                    } else {
                        this.func_50032_g(this.func_50036_k() - 1);
                    }
                } else if (GuiScreen.func_50051_l()) {
                    this.func_50030_e(this.func_50028_c(-1));
                } else {
                    this.func_50023_d(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_50049_m()) {
                    if (GuiScreen.func_50051_l()) {
                        this.func_50032_g(this.func_50024_a(1, this.func_50036_k()));
                    } else {
                        this.func_50032_g(this.func_50036_k() + 1);
                    }
                } else if (GuiScreen.func_50051_l()) {
                    this.func_50030_e(this.func_50028_c(1));
                } else {
                    this.func_50023_d(1);
                }
                return true;
            }
            case 14: {
                if (GuiScreen.func_50051_l()) {
                    this.func_50021_a(-1);
                } else {
                    this.func_50020_b(-1);
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_50051_l()) {
                    this.func_50021_a(1);
                } else {
                    this.func_50020_b(1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_50049_m()) {
                    this.func_50032_g(0);
                } else {
                    this.func_50034_d();
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_50049_m()) {
                    this.func_50032_g(this.text.length());
                } else {
                    this.func_50038_e();
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.isAllowedCharacter(par1)) {
            this.func_50031_b(Character.toString(par1));
            return true;
        }
        return false;
    }

    public void mouseClicked(int par1, int par2, int par3) {
        boolean flag;
        boolean bl = flag = par1 >= this.xPos && par1 < this.xPos + this.width && par2 >= this.yPos && par2 < this.yPos + this.height;
        if (this.field_50045_k) {
            this.setFocused(this.isEnabled && flag);
        }
        if (this.isFocused && par3 == 0) {
            int i = par1 - this.xPos;
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            String s = this.fontRenderer.trimStringToWidth(this.text.substring(this.field_50041_n), this.func_50019_l());
            this.func_50030_e(this.fontRenderer.trimStringToWidth(s, i).length() + this.field_50041_n);
        }
    }

    public void drawTextBox() {
        if (this.getEnableBackgroundDrawing()) {
            GuiTextField.drawRect(this.xPos - 1, this.yPos - 1, this.xPos + this.width + 1, this.yPos + this.height + 1, -6250336);
            GuiTextField.drawRect(this.xPos, this.yPos, this.xPos + this.width, this.yPos + this.height, -16777216);
        }
        int i = this.isEnabled ? this.field_50047_q : this.field_50046_r;
        int j = this.field_50042_o - this.field_50041_n;
        int k = this.field_50048_p - this.field_50041_n;
        String s = this.fontRenderer.trimStringToWidth(this.text.substring(this.field_50041_n), this.func_50019_l());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.enableBackgroundDrawing ? this.xPos + 4 : this.xPos;
        int i1 = this.enableBackgroundDrawing ? this.yPos + (this.height - 8) / 2 : this.yPos;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.fontRenderer.drawStringWithShadow(s1, j1, i1, i);
        }
        boolean flag2 = this.field_50042_o < this.text.length() || this.text.length() >= this.func_50040_g();
        int k1 = j1;
        if (!flag) {
            k1 = j <= 0 ? l : l + this.width;
        } else if (flag2) {
            --k1;
            --j1;
        }
        if (s.length() > 0 && flag && j < s.length()) {
            j1 = this.fontRenderer.drawStringWithShadow(s.substring(j), j1, i1, i);
        }
        if (flag1) {
            if (flag2) {
                Gui.drawRect(k1, i1 - 1, k1 + 1, i1 + 1 + this.fontRenderer.FONT_HEIGHT, -3092272);
            } else {
                this.fontRenderer.drawStringWithShadow("_", k1, i1, i);
            }
        }
        if (k != j) {
            int l1 = l + this.fontRenderer.getStringWidth(s.substring(0, k));
            this.func_50029_c(k1, i1 - 1, l1 - 1, i1 + 1 + this.fontRenderer.FONT_HEIGHT);
        }
    }

    private void func_50029_c(int par1, int par2, int par3, int par4) {
        if (par1 < par3) {
            int i = par1;
            par1 = par3;
            par3 = i;
        }
        if (par2 < par4) {
            int j = par2;
            par2 = par4;
            par4 = j;
        }
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.startDrawingQuads();
        tessellator.addVertex(par1, par4, 0.0);
        tessellator.addVertex(par3, par4, 0.0);
        tessellator.addVertex(par3, par2, 0.0);
        tessellator.addVertex(par1, par2, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    public void setMaxStringLength(int par1) {
        this.maxStringLength = par1;
        if (this.text.length() > par1) {
            this.text = this.text.substring(0, par1);
        }
    }

    public int func_50040_g() {
        return this.maxStringLength;
    }

    public int func_50035_h() {
        return this.field_50042_o;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean par1) {
        this.enableBackgroundDrawing = par1;
    }

    public void setFocused(boolean par1) {
        if (par1 && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = par1;
    }

    public boolean getIsFocused() {
        return this.isFocused;
    }

    public int func_50036_k() {
        return this.field_50048_p;
    }

    public int func_50019_l() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void func_50032_g(int par1) {
        int i = this.text.length();
        if (par1 > i) {
            par1 = i;
        }
        if (par1 < 0) {
            par1 = 0;
        }
        this.field_50048_p = par1;
        if (this.fontRenderer != null) {
            if (this.field_50041_n > i) {
                this.field_50041_n = i;
            }
            int j = this.func_50019_l();
            String s = this.fontRenderer.trimStringToWidth(this.text.substring(this.field_50041_n), j);
            int k = s.length() + this.field_50041_n;
            if (par1 == this.field_50041_n) {
                this.field_50041_n -= this.fontRenderer.trimStringToWidth(this.text, j, true).length();
            }
            if (par1 > k) {
                this.field_50041_n += par1 - k;
            } else if (par1 <= this.field_50041_n) {
                this.field_50041_n -= this.field_50041_n - par1;
            }
            if (this.field_50041_n < 0) {
                this.field_50041_n = 0;
            }
            if (this.field_50041_n > i) {
                this.field_50041_n = i;
            }
        }
    }

    public void func_50026_c(boolean par1) {
        this.field_50045_k = par1;
    }
}

