/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSmallButton;
import net.minecraft.src.GuiTexturePackSlot;
import net.minecraft.src.StringTranslate;
import org.lwjgl.Sys;

public class GuiTexturePacks
extends GuiScreen {
    protected GuiScreen guiScreen;
    private int refreshTimer = -1;
    private String fileLocation = "";
    private GuiTexturePackSlot guiTexturePackSlot;

    public GuiTexturePacks(GuiScreen par1GuiScreen) {
        this.guiScreen = par1GuiScreen;
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.controlList.add(new GuiSmallButton(5, this.width / 2 - 154, this.height - 48, stringtranslate.translateKey("texturePack.openFolder")));
        this.controlList.add(new GuiSmallButton(6, this.width / 2 + 4, this.height - 48, stringtranslate.translateKey("gui.done")));
        this.mc.texturePackList.updateAvaliableTexturePacks();
        this.fileLocation = new File(Minecraft.getMinecraftDir(), "texturepacks").getAbsolutePath();
        this.guiTexturePackSlot = new GuiTexturePackSlot(this);
        this.guiTexturePackSlot.registerScrollButtons(this.controlList, 7, 8);
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == 5) {
            boolean flag = false;
            try {
                Class<?> class1 = Class.forName("java.awt.Desktop");
                Object obj = class1.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                class1.getMethod("browse", URI.class).invoke(obj, new File(Minecraft.getMinecraftDir(), "texturepacks").toURI());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                flag = true;
            }
            if (flag) {
                System.out.println("Opening via Sys class!");
                Sys.openURL((String)("file://" + this.fileLocation));
            }
        } else if (par1GuiButton.id == 6) {
            this.mc.renderEngine.refreshTextures();
            this.mc.displayGuiScreen(this.guiScreen);
        } else {
            this.guiTexturePackSlot.actionPerformed(par1GuiButton);
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) {
        super.mouseClicked(par1, par2, par3);
    }

    @Override
    protected void mouseMovedOrUp(int par1, int par2, int par3) {
        super.mouseMovedOrUp(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.guiTexturePackSlot.drawScreen(par1, par2, par3);
        if (this.refreshTimer <= 0) {
            this.mc.texturePackList.updateAvaliableTexturePacks();
            this.refreshTimer += 20;
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("texturePack.title"), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("texturePack.folderInfo"), this.width / 2 - 77, this.height - 26, 0x808080);
        super.drawScreen(par1, par2, par3);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        --this.refreshTimer;
    }

    static Minecraft func_22124_a(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22126_b(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22119_c(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22122_d(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22117_e(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_35307_f(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_35308_g(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22118_f(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22116_g(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22121_h(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static Minecraft func_22123_i(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.mc;
    }

    static FontRenderer func_22127_j(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.fontRenderer;
    }

    static FontRenderer func_22120_k(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.fontRenderer;
    }

    static FontRenderer func_22125_l(GuiTexturePacks par0GuiTexturePacks) {
        return par0GuiTexturePacks.fontRenderer;
    }
}

