/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.IntHashMapEntry;

public class IntHashMap {
    private transient IntHashMapEntry[] slots;
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;
    private volatile transient int versionStamp;
    private Set keySet = new HashSet();

    public IntHashMap() {
        this.slots = new IntHashMapEntry[16];
    }

    private static int computeHash(int par0) {
        par0 ^= par0 >>> 20 ^ par0 >>> 12;
        return par0 ^ par0 >>> 7 ^ par0 >>> 4;
    }

    private static int getSlotIndex(int par0, int par1) {
        return par0 & par1 - 1;
    }

    public Object lookup(int par1) {
        int i = IntHashMap.computeHash(par1);
        IntHashMapEntry inthashmapentry = this.slots[IntHashMap.getSlotIndex(i, this.slots.length)];
        while (inthashmapentry != null) {
            if (inthashmapentry.hashEntry == par1) {
                return inthashmapentry.valueEntry;
            }
            inthashmapentry = inthashmapentry.nextEntry;
        }
        return null;
    }

    public boolean containsItem(int par1) {
        return this.lookupEntry(par1) != null;
    }

    final IntHashMapEntry lookupEntry(int par1) {
        int i = IntHashMap.computeHash(par1);
        IntHashMapEntry inthashmapentry = this.slots[IntHashMap.getSlotIndex(i, this.slots.length)];
        while (inthashmapentry != null) {
            if (inthashmapentry.hashEntry == par1) {
                return inthashmapentry;
            }
            inthashmapentry = inthashmapentry.nextEntry;
        }
        return null;
    }

    public void addKey(int par1, Object par2Obj) {
        this.keySet.add(par1);
        int i = IntHashMap.computeHash(par1);
        int j = IntHashMap.getSlotIndex(i, this.slots.length);
        IntHashMapEntry inthashmapentry = this.slots[j];
        while (inthashmapentry != null) {
            if (inthashmapentry.hashEntry == par1) {
                inthashmapentry.valueEntry = par2Obj;
            }
            inthashmapentry = inthashmapentry.nextEntry;
        }
        ++this.versionStamp;
        this.insert(i, par1, par2Obj, j);
    }

    private void grow(int par1) {
        IntHashMapEntry[] ainthashmapentry = this.slots;
        int i = ainthashmapentry.length;
        if (i == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        IntHashMapEntry[] ainthashmapentry1 = new IntHashMapEntry[par1];
        this.copyTo(ainthashmapentry1);
        this.slots = ainthashmapentry1;
        this.threshold = (int)((float)par1 * 0.75f);
    }

    private void copyTo(IntHashMapEntry[] par1ArrayOfIntHashMapEntry) {
        IntHashMapEntry[] ainthashmapentry = this.slots;
        int i = par1ArrayOfIntHashMapEntry.length;
        for (int j = 0; j < ainthashmapentry.length; ++j) {
            IntHashMapEntry inthashmapentry1;
            IntHashMapEntry inthashmapentry = ainthashmapentry[j];
            if (inthashmapentry == null) continue;
            ainthashmapentry[j] = null;
            do {
                inthashmapentry1 = inthashmapentry.nextEntry;
                int k = IntHashMap.getSlotIndex(inthashmapentry.slotHash, i);
                inthashmapentry.nextEntry = par1ArrayOfIntHashMapEntry[k];
                par1ArrayOfIntHashMapEntry[k] = inthashmapentry;
            } while ((inthashmapentry = inthashmapentry1) != null);
        }
    }

    public Object removeObject(int par1) {
        this.keySet.remove(par1);
        IntHashMapEntry inthashmapentry = this.removeEntry(par1);
        return inthashmapentry != null ? inthashmapentry.valueEntry : null;
    }

    final IntHashMapEntry removeEntry(int par1) {
        IntHashMapEntry inthashmapentry;
        int i = IntHashMap.computeHash(par1);
        int j = IntHashMap.getSlotIndex(i, this.slots.length);
        IntHashMapEntry inthashmapentry1 = inthashmapentry = this.slots[j];
        while (inthashmapentry1 != null) {
            IntHashMapEntry inthashmapentry2 = inthashmapentry1.nextEntry;
            if (inthashmapentry1.hashEntry == par1) {
                ++this.versionStamp;
                --this.count;
                if (inthashmapentry == inthashmapentry1) {
                    this.slots[j] = inthashmapentry2;
                } else {
                    inthashmapentry.nextEntry = inthashmapentry2;
                }
                return inthashmapentry1;
            }
            inthashmapentry = inthashmapentry1;
            inthashmapentry1 = inthashmapentry2;
        }
        return inthashmapentry1;
    }

    public void clearMap() {
        ++this.versionStamp;
        IntHashMapEntry[] ainthashmapentry = this.slots;
        for (int i = 0; i < ainthashmapentry.length; ++i) {
            ainthashmapentry[i] = null;
        }
        this.count = 0;
    }

    private void insert(int par1, int par2, Object par3Obj, int par4) {
        IntHashMapEntry inthashmapentry = this.slots[par4];
        this.slots[par4] = new IntHashMapEntry(par1, par2, par3Obj, inthashmapentry);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    public Set getKeySet() {
        return this.keySet;
    }

    static int getHash(int par0) {
        return IntHashMap.computeHash(par0);
    }
}

