/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;

public class InventoryCrafting
implements IInventory {
    private ItemStack[] stackList;
    private int inventoryWidth;
    private Container eventHandler;

    public InventoryCrafting(Container par1Container, int par2, int par3) {
        int i = par2 * par3;
        this.stackList = new ItemStack[i];
        this.eventHandler = par1Container;
        this.inventoryWidth = par2;
    }

    @Override
    public int getSizeInventory() {
        return this.stackList.length;
    }

    @Override
    public ItemStack getStackInSlot(int par1) {
        if (par1 >= this.getSizeInventory()) {
            return null;
        }
        return this.stackList[par1];
    }

    public ItemStack getStackInRowAndColumn(int par1, int par2) {
        if (par1 < 0 || par1 >= this.inventoryWidth) {
            return null;
        }
        int i = par1 + par2 * this.inventoryWidth;
        return this.getStackInSlot(i);
    }

    @Override
    public String getInvName() {
        return "container.crafting";
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.stackList[par1] != null) {
            ItemStack itemstack = this.stackList[par1];
            this.stackList[par1] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public ItemStack decrStackSize(int par1, int par2) {
        if (this.stackList[par1] != null) {
            if (this.stackList[par1].stackSize <= par2) {
                ItemStack itemstack = this.stackList[par1];
                this.stackList[par1] = null;
                this.eventHandler.onCraftMatrixChanged(this);
                return itemstack;
            }
            ItemStack itemstack1 = this.stackList[par1].splitStack(par2);
            if (this.stackList[par1].stackSize == 0) {
                this.stackList[par1] = null;
            }
            this.eventHandler.onCraftMatrixChanged(this);
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.stackList[par1] = par2ItemStack;
        this.eventHandler.onCraftMatrixChanged(this);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return true;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }
}

