/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;

public class InventoryPlayer
implements IInventory {
    public ItemStack[] mainInventory = new ItemStack[36];
    public ItemStack[] armorInventory = new ItemStack[4];
    public int currentItem = 0;
    public EntityPlayer player;
    private ItemStack itemStack;
    public boolean inventoryChanged = false;

    public InventoryPlayer(EntityPlayer par1EntityPlayer) {
        this.player = par1EntityPlayer;
    }

    public ItemStack getCurrentItem() {
        if (this.currentItem < 9 && this.currentItem >= 0) {
            return this.mainInventory[this.currentItem];
        }
        return null;
    }

    private int getInventorySlotContainItem(int par1) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null || this.mainInventory[i].itemID != par1) continue;
            return i;
        }
        return -1;
    }

    private int getInventorySlotContainItemAndDamage(int par1, int par2) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null || this.mainInventory[i].itemID != par1 || this.mainInventory[i].getItemDamage() != par2) continue;
            return i;
        }
        return -1;
    }

    private int storeItemStack(ItemStack par1ItemStack) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null || this.mainInventory[i].itemID != par1ItemStack.itemID || !this.mainInventory[i].isStackable() || this.mainInventory[i].stackSize >= this.mainInventory[i].getMaxStackSize() || this.mainInventory[i].stackSize >= this.getInventoryStackLimit() || this.mainInventory[i].getHasSubtypes() && this.mainInventory[i].getItemDamage() != par1ItemStack.getItemDamage() || !ItemStack.func_46154_a(this.mainInventory[i], par1ItemStack)) continue;
            return i;
        }
        return -1;
    }

    private int getFirstEmptyStack() {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public void setCurrentItem(int par1, int par2, boolean par3, boolean par4) {
        int i = -1;
        i = par3 ? this.getInventorySlotContainItemAndDamage(par1, par2) : this.getInventorySlotContainItem(par1);
        if (i >= 0 && i < 9) {
            this.currentItem = i;
            return;
        }
        if (par4 && par1 > 0) {
            int j = this.getFirstEmptyStack();
            if (j >= 0 && j < 9) {
                this.currentItem = j;
            }
            this.func_52006_a(Item.itemsList[par1], par2);
        }
    }

    public void changeCurrentItem(int par1) {
        if (par1 > 0) {
            par1 = 1;
        }
        if (par1 < 0) {
            par1 = -1;
        }
        this.currentItem -= par1;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    public void func_52006_a(Item par1Item, int par2) {
        if (par1Item != null) {
            int i = this.getInventorySlotContainItemAndDamage(par1Item.shiftedIndex, par2);
            if (i >= 0) {
                this.mainInventory[i] = this.mainInventory[this.currentItem];
            }
            this.mainInventory[this.currentItem] = new ItemStack(Item.itemsList[par1Item.shiftedIndex], 1, par2);
        }
    }

    private int storePartialItemStack(ItemStack par1ItemStack) {
        int i1;
        int i = par1ItemStack.itemID;
        int j = par1ItemStack.stackSize;
        if (par1ItemStack.getMaxStackSize() == 1) {
            int k = this.getFirstEmptyStack();
            if (k < 0) {
                return j;
            }
            if (this.mainInventory[k] == null) {
                this.mainInventory[k] = ItemStack.copyItemStack(par1ItemStack);
            }
            return 0;
        }
        int l = this.storeItemStack(par1ItemStack);
        if (l < 0) {
            l = this.getFirstEmptyStack();
        }
        if (l < 0) {
            return j;
        }
        if (this.mainInventory[l] == null) {
            this.mainInventory[l] = new ItemStack(i, 0, par1ItemStack.getItemDamage());
            if (par1ItemStack.hasTagCompound()) {
                this.mainInventory[l].setTagCompound((NBTTagCompound)par1ItemStack.getTagCompound().copy());
            }
        }
        if ((i1 = j) > this.mainInventory[l].getMaxStackSize() - this.mainInventory[l].stackSize) {
            i1 = this.mainInventory[l].getMaxStackSize() - this.mainInventory[l].stackSize;
        }
        if (i1 > this.getInventoryStackLimit() - this.mainInventory[l].stackSize) {
            i1 = this.getInventoryStackLimit() - this.mainInventory[l].stackSize;
        }
        if (i1 == 0) {
            return j;
        }
        this.mainInventory[l].stackSize += i1;
        this.mainInventory[l].animationsToGo = 5;
        return j -= i1;
    }

    public void decrementAnimations() {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            this.mainInventory[i].updateAnimation(this.player.worldObj, this.player, i, this.currentItem == i);
        }
    }

    public boolean consumeInventoryItem(int par1) {
        int i = this.getInventorySlotContainItem(par1);
        if (i < 0) {
            return false;
        }
        if (--this.mainInventory[i].stackSize <= 0) {
            this.mainInventory[i] = null;
        }
        return true;
    }

    public boolean hasItem(int par1) {
        int i = this.getInventorySlotContainItem(par1);
        return i >= 0;
    }

    public boolean addItemStackToInventory(ItemStack par1ItemStack) {
        if (!par1ItemStack.isItemDamaged()) {
            int i;
            do {
                i = par1ItemStack.stackSize;
                par1ItemStack.stackSize = this.storePartialItemStack(par1ItemStack);
            } while (par1ItemStack.stackSize > 0 && par1ItemStack.stackSize < i);
            if (par1ItemStack.stackSize == i && this.player.capabilities.isCreativeMode) {
                par1ItemStack.stackSize = 0;
                return true;
            }
            return par1ItemStack.stackSize < i;
        }
        int j = this.getFirstEmptyStack();
        if (j >= 0) {
            this.mainInventory[j] = ItemStack.copyItemStack(par1ItemStack);
            this.mainInventory[j].animationsToGo = 5;
            par1ItemStack.stackSize = 0;
            return true;
        }
        if (this.player.capabilities.isCreativeMode) {
            par1ItemStack.stackSize = 0;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack decrStackSize(int par1, int par2) {
        ItemStack[] aitemstack = this.mainInventory;
        if (par1 >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            par1 -= this.mainInventory.length;
        }
        if (aitemstack[par1] != null) {
            if (aitemstack[par1].stackSize <= par2) {
                ItemStack itemstack = aitemstack[par1];
                aitemstack[par1] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[par1].splitStack(par2);
            if (aitemstack[par1].stackSize == 0) {
                aitemstack[par1] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        ItemStack[] aitemstack = this.mainInventory;
        if (par1 >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            par1 -= this.mainInventory.length;
        }
        if (aitemstack[par1] != null) {
            ItemStack itemstack = aitemstack[par1];
            aitemstack[par1] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (par1 >= aitemstack.length) {
            par1 -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        aitemstack[par1] = par2ItemStack;
    }

    public float getStrVsBlock(Block par1Block) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(par1Block);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList par1NBTTagList) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            this.mainInventory[i].writeToNBT(nbttagcompound);
            par1NBTTagList.appendTag(nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)(j + 100));
            this.armorInventory[j].writeToNBT(nbttagcompound1);
            par1NBTTagList.appendTag(nbttagcompound1);
        }
        return par1NBTTagList;
    }

    public void readFromNBT(NBTTagList par1NBTTagList) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        for (int i = 0; i < par1NBTTagList.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)par1NBTTagList.tagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT(nbttagcompound);
            if (itemstack == null) continue;
            if (j >= 0 && j < this.mainInventory.length) {
                this.mainInventory[j] = itemstack;
            }
            if (j < 100 || j >= this.armorInventory.length + 100) continue;
            this.armorInventory[j - 100] = itemstack;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + 4;
    }

    @Override
    public ItemStack getStackInSlot(int par1) {
        ItemStack[] aitemstack = this.mainInventory;
        if (par1 >= aitemstack.length) {
            par1 -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        return aitemstack[par1];
    }

    @Override
    public String getInvName() {
        return "container.inventory";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int getDamageVsEntity(Entity par1Entity) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.getDamageVsEntity(par1Entity);
        }
        return 1;
    }

    public boolean canHarvestBlock(Block par1Block) {
        if (par1Block.blockMaterial.isHarvestable()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.canHarvestBlock(par1Block);
        }
        return false;
    }

    public ItemStack armorItemInSlot(int par1) {
        return this.armorInventory[par1];
    }

    public int getTotalArmorValue() {
        int i = 0;
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null || !(this.armorInventory[j].getItem() instanceof ItemArmor)) continue;
            int k = ((ItemArmor)this.armorInventory[j].getItem()).damageReduceAmount;
            i += k;
        }
        return i;
    }

    public void damageArmor(int par1) {
        if ((par1 /= 4) < 1) {
            par1 = 1;
        }
        for (int i = 0; i < this.armorInventory.length; ++i) {
            if (this.armorInventory[i] == null || !(this.armorInventory[i].getItem() instanceof ItemArmor)) continue;
            this.armorInventory[i].damageItem(par1, this.player);
            if (this.armorInventory[i].stackSize != 0) continue;
            this.armorInventory[i].onItemDestroyedByUse(this.player);
            this.armorInventory[i] = null;
        }
    }

    public void dropAllItems() {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            this.player.dropPlayerItemWithRandomChoice(this.mainInventory[i], true);
            this.mainInventory[i] = null;
        }
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null) continue;
            this.player.dropPlayerItemWithRandomChoice(this.armorInventory[j], true);
            this.armorInventory[j] = null;
        }
    }

    @Override
    public void onInventoryChanged() {
        this.inventoryChanged = true;
    }

    public void setItemStack(ItemStack par1ItemStack) {
        this.itemStack = par1ItemStack;
        this.player.onItemStackChanged(par1ItemStack);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        if (this.player.isDead) {
            return false;
        }
        return par1EntityPlayer.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean hasItemStack(ItemStack par1ItemStack) {
        for (int i = 0; i < this.armorInventory.length; ++i) {
            if (this.armorInventory[i] == null || !this.armorInventory[i].isStackEqual(par1ItemStack)) continue;
            return true;
        }
        for (int j = 0; j < this.mainInventory.length; ++j) {
            if (this.mainInventory[j] == null || !this.mainInventory[j].isStackEqual(par1ItemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }

    public void copyInventory(InventoryPlayer par1InventoryPlayer) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            this.mainInventory[i] = ItemStack.copyItemStack(par1InventoryPlayer.mainInventory[i]);
        }
        for (int j = 0; j < this.armorInventory.length; ++j) {
            this.armorInventory[j] = ItemStack.copyItemStack(par1InventoryPlayer.armorInventory[j]);
        }
    }
}

