/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityEggInfo;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Facing;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatCollector;
import net.minecraft.src.World;

public class ItemMonsterPlacer
extends Item {
    public ItemMonsterPlacer(int par1) {
        super(par1);
        this.setHasSubtypes(true);
    }

    @Override
    public String getItemDisplayName(ItemStack par1ItemStack) {
        String s = ("" + StatCollector.translateToLocal(this.getItemName() + ".name")).trim();
        String s1 = EntityList.getStringFromID(par1ItemStack.getItemDamage());
        if (s1 != null) {
            s = s + " " + StatCollector.translateToLocal("entity." + s1 + ".name");
        }
        return s;
    }

    @Override
    public int getColorFromDamage(int par1, int par2) {
        EntityEggInfo entityegginfo = (EntityEggInfo)EntityList.entityEggs.get(par1);
        if (entityegginfo != null) {
            if (par2 == 0) {
                return entityegginfo.primaryColor;
            }
            return entityegginfo.secondaryColor;
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean func_46058_c() {
        return true;
    }

    @Override
    public int func_46057_a(int par1, int par2) {
        if (par2 > 0) {
            return super.func_46057_a(par1, par2) + 16;
        }
        return super.func_46057_a(par1, par2);
    }

    @Override
    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7) {
        if (par3World.isRemote) {
            return true;
        }
        int i = par3World.getBlockId(par4, par5, par6);
        par4 += Facing.offsetsXForSide[par7];
        par5 += Facing.offsetsYForSide[par7];
        par6 += Facing.offsetsZForSide[par7];
        double d = 0.0;
        if (par7 == 1 && i == Block.fence.blockID || i == Block.netherFence.blockID) {
            d = 0.5;
        }
        if (ItemMonsterPlacer.func_48440_a(par3World, par1ItemStack.getItemDamage(), (double)par4 + 0.5, (double)par5 + d, (double)par6 + 0.5) && !par2EntityPlayer.capabilities.isCreativeMode) {
            --par1ItemStack.stackSize;
        }
        return true;
    }

    public static boolean func_48440_a(World par0World, int par1, double par2, double par4, double par6) {
        if (!EntityList.entityEggs.containsKey(par1)) {
            return false;
        }
        Entity entity = EntityList.createEntityByID(par1, par0World);
        if (entity != null) {
            entity.setLocationAndAngles(par2, par4, par6, par0World.rand.nextFloat() * 360.0f, 0.0f);
            par0World.spawnEntityInWorld(entity);
            ((EntityLiving)entity).playLivingSound();
        }
        return entity != null;
    }
}

