/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.List;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPotion;
import net.minecraft.src.EnumAction;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Potion;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.PotionHelper;
import net.minecraft.src.StatCollector;
import net.minecraft.src.World;

public class ItemPotion
extends Item {
    private HashMap effectCache = new HashMap();

    public ItemPotion(int par1) {
        super(par1);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    public List getEffects(ItemStack par1ItemStack) {
        return this.getEffects(par1ItemStack.getItemDamage());
    }

    public List getEffects(int par1) {
        List list = (List)this.effectCache.get(par1);
        if (list == null) {
            list = PotionHelper.getPotionEffects(par1, false);
            this.effectCache.put(par1, list);
        }
        return list;
    }

    @Override
    public ItemStack onFoodEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        List list;
        --par1ItemStack.stackSize;
        if (!par2World.isRemote && (list = this.getEffects(par1ItemStack)) != null) {
            for (PotionEffect potioneffect : list) {
                par3EntityPlayer.addPotionEffect(new PotionEffect(potioneffect));
            }
        }
        if (par1ItemStack.stackSize <= 0) {
            return new ItemStack(Item.glassBottle);
        }
        par3EntityPlayer.inventory.addItemStackToInventory(new ItemStack(Item.glassBottle));
        return par1ItemStack;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (ItemPotion.isSplash(par1ItemStack.getItemDamage())) {
            --par1ItemStack.stackSize;
            par2World.playSoundAtEntity(par3EntityPlayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!par2World.isRemote) {
                par2World.spawnEntityInWorld(new EntityPotion(par2World, par3EntityPlayer, par1ItemStack.getItemDamage()));
            }
            return par1ItemStack;
        }
        par3EntityPlayer.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        return par1ItemStack;
    }

    @Override
    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int i, int j, int k, int l) {
        return false;
    }

    @Override
    public int getIconFromDamage(int par1) {
        return !ItemPotion.isSplash(par1) ? 140 : 154;
    }

    @Override
    public int func_46057_a(int par1, int par2) {
        if (par2 == 0) {
            return 141;
        }
        return super.func_46057_a(par1, par2);
    }

    public static boolean isSplash(int par0) {
        return (par0 & 0x4000) != 0;
    }

    @Override
    public int getColorFromDamage(int par1, int par2) {
        if (par2 > 0) {
            return 0xFFFFFF;
        }
        return PotionHelper.func_40358_a(par1, false);
    }

    @Override
    public boolean func_46058_c() {
        return true;
    }

    public boolean isEffectInstant(int par1) {
        List list = this.getEffects(par1);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (PotionEffect potioneffect : list) {
            if (!Potion.potionTypes[potioneffect.getPotionID()].isInstant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getItemDisplayName(ItemStack par1ItemStack) {
        List list;
        if (par1ItemStack.getItemDamage() == 0) {
            return StatCollector.translateToLocal("item.emptyPotion.name").trim();
        }
        String s = "";
        if (ItemPotion.isSplash(par1ItemStack.getItemDamage())) {
            s = StatCollector.translateToLocal("potion.prefix.grenade").trim() + " ";
        }
        if ((list = Item.potion.getEffects(par1ItemStack)) != null && !list.isEmpty()) {
            String s1 = ((PotionEffect)list.get(0)).getEffectName();
            s1 = s1 + ".postfix";
            return s + StatCollector.translateToLocal(s1).trim();
        }
        String s2 = PotionHelper.func_40359_b(par1ItemStack.getItemDamage());
        return StatCollector.translateToLocal(s2).trim() + " " + super.getItemDisplayName(par1ItemStack);
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, List par2List) {
        if (par1ItemStack.getItemDamage() == 0) {
            return;
        }
        List list = Item.potion.getEffects(par1ItemStack);
        if (list != null && !list.isEmpty()) {
            for (PotionEffect potioneffect : list) {
                String s1 = StatCollector.translateToLocal(potioneffect.getEffectName()).trim();
                if (potioneffect.getAmplifier() > 0) {
                    s1 = s1 + " " + StatCollector.translateToLocal("potion.potency." + potioneffect.getAmplifier()).trim();
                }
                if (potioneffect.getDuration() > 20) {
                    s1 = s1 + " (" + Potion.getDurationString(potioneffect) + ")";
                }
                if (Potion.potionTypes[potioneffect.getPotionID()].isBadEffect()) {
                    par2List.add("\u00a7c" + s1);
                    continue;
                }
                par2List.add("\u00a77" + s1);
            }
        } else {
            String s = StatCollector.translateToLocal("potion.empty").trim();
            par2List.add("\u00a77" + s);
        }
    }

    @Override
    public boolean hasEffect(ItemStack par1ItemStack) {
        List list = this.getEffects(par1ItemStack);
        return list != null && !list.isEmpty();
    }
}

