/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemReed
extends Item {
    private int spawnID;

    public ItemReed(int par1, Block par2Block) {
        super(par1);
        this.spawnID = par2Block.blockID;
    }

    @Override
    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7) {
        int i = par3World.getBlockId(par4, par5, par6);
        if (i == Block.snow.blockID) {
            par7 = 1;
        } else if (i != Block.vine.blockID && i != Block.tallGrass.blockID && i != Block.deadBush.blockID) {
            if (par7 == 0) {
                --par5;
            }
            if (par7 == 1) {
                ++par5;
            }
            if (par7 == 2) {
                --par6;
            }
            if (par7 == 3) {
                ++par6;
            }
            if (par7 == 4) {
                --par4;
            }
            if (par7 == 5) {
                ++par4;
            }
        }
        if (!par2EntityPlayer.canPlayerEdit(par4, par5, par6)) {
            return false;
        }
        if (par1ItemStack.stackSize == 0) {
            return false;
        }
        if (par3World.canBlockBePlacedAt(this.spawnID, par4, par5, par6, false, par7)) {
            Block block = Block.blocksList[this.spawnID];
            if (par3World.setBlockWithNotify(par4, par5, par6, this.spawnID)) {
                if (par3World.getBlockId(par4, par5, par6) == this.spawnID) {
                    Block.blocksList[this.spawnID].onBlockPlaced(par3World, par4, par5, par6, par7);
                    Block.blocksList[this.spawnID].onBlockPlacedBy(par3World, par4, par5, par6, par2EntityPlayer);
                }
                par3World.playSoundEffect((float)par4 + 0.5f, (float)par5 + 0.5f, (float)par6 + 0.5f, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --par1ItemStack.stackSize;
            }
        }
        return true;
    }
}

