/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.Enchantment;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumAction;
import net.minecraft.src.EnumRarity;
import net.minecraft.src.Item;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public final class ItemStack {
    public int stackSize = 0;
    public int animationsToGo;
    public int itemID;
    public NBTTagCompound stackTagCompound;
    private int itemDamage;

    public ItemStack(Block par1Block) {
        this(par1Block, 1);
    }

    public ItemStack(Block par1Block, int par2) {
        this(par1Block.blockID, par2, 0);
    }

    public ItemStack(Block par1Block, int par2, int par3) {
        this(par1Block.blockID, par2, par3);
    }

    public ItemStack(Item par1Item) {
        this(par1Item.shiftedIndex, 1, 0);
    }

    public ItemStack(Item par1Item, int par2) {
        this(par1Item.shiftedIndex, par2, 0);
    }

    public ItemStack(Item par1Item, int par2, int par3) {
        this(par1Item.shiftedIndex, par2, par3);
    }

    public ItemStack(int par1, int par2, int par3) {
        this.itemID = par1;
        this.stackSize = par2;
        this.itemDamage = par3;
    }

    public static ItemStack loadItemStackFromNBT(NBTTagCompound par0NBTTagCompound) {
        ItemStack itemstack = new ItemStack();
        itemstack.readFromNBT(par0NBTTagCompound);
        return itemstack.getItem() == null ? null : itemstack;
    }

    private ItemStack() {
    }

    public ItemStack splitStack(int par1) {
        ItemStack itemstack = new ItemStack(this.itemID, par1, this.itemDamage);
        if (this.stackTagCompound != null) {
            itemstack.stackTagCompound = (NBTTagCompound)this.stackTagCompound.copy();
        }
        this.stackSize -= par1;
        return itemstack;
    }

    public Item getItem() {
        return Item.itemsList[this.itemID];
    }

    public int getIconIndex() {
        return this.getItem().getIconIndex(this);
    }

    public boolean useItem(EntityPlayer par1EntityPlayer, World par2World, int par3, int par4, int par5, int par6) {
        boolean flag = this.getItem().onItemUse(this, par1EntityPlayer, par2World, par3, par4, par5, par6);
        if (flag) {
            par1EntityPlayer.addStat(StatList.objectUseStats[this.itemID], 1);
        }
        return flag;
    }

    public float getStrVsBlock(Block par1Block) {
        return this.getItem().getStrVsBlock(this, par1Block);
    }

    public ItemStack useItemRightClick(World par1World, EntityPlayer par2EntityPlayer) {
        return this.getItem().onItemRightClick(this, par1World, par2EntityPlayer);
    }

    public ItemStack onFoodEaten(World par1World, EntityPlayer par2EntityPlayer) {
        return this.getItem().onFoodEaten(this, par1World, par2EntityPlayer);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setShort("id", (short)this.itemID);
        par1NBTTagCompound.setByte("Count", (byte)this.stackSize);
        par1NBTTagCompound.setShort("Damage", (short)this.itemDamage);
        if (this.stackTagCompound != null) {
            par1NBTTagCompound.setTag("tag", this.stackTagCompound);
        }
        return par1NBTTagCompound;
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.itemID = par1NBTTagCompound.getShort("id");
        this.stackSize = par1NBTTagCompound.getByte("Count");
        this.itemDamage = par1NBTTagCompound.getShort("Damage");
        if (par1NBTTagCompound.hasKey("tag")) {
            this.stackTagCompound = par1NBTTagCompound.getCompoundTag("tag");
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getItemStackLimit();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        return Item.itemsList[this.itemID].getMaxDamage() > 0;
    }

    public boolean getHasSubtypes() {
        return Item.itemsList[this.itemID].getHasSubtypes();
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.itemDamage > 0;
    }

    public int getItemDamageForDisplay() {
        return this.itemDamage;
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public void setItemDamage(int par1) {
        this.itemDamage = par1;
    }

    public int getMaxDamage() {
        return Item.itemsList[this.itemID].getMaxDamage();
    }

    public void damageItem(int par1, EntityLiving par2EntityLiving) {
        int i;
        if (!this.isItemStackDamageable()) {
            return;
        }
        if (par1 > 0 && par2EntityLiving instanceof EntityPlayer && (i = EnchantmentHelper.getUnbreakingModifier(((EntityPlayer)par2EntityLiving).inventory)) > 0 && par2EntityLiving.worldObj.rand.nextInt(i + 1) > 0) {
            return;
        }
        this.itemDamage += par1;
        if (this.itemDamage > this.getMaxDamage()) {
            par2EntityLiving.renderBrokenItemStack(this);
            if (par2EntityLiving instanceof EntityPlayer) {
                ((EntityPlayer)par2EntityLiving).addStat(StatList.objectBreakStats[this.itemID], 1);
            }
            --this.stackSize;
            if (this.stackSize < 0) {
                this.stackSize = 0;
            }
            this.itemDamage = 0;
        }
    }

    public void hitEntity(EntityLiving par1EntityLiving, EntityPlayer par2EntityPlayer) {
        boolean flag = Item.itemsList[this.itemID].hitEntity(this, par1EntityLiving, par2EntityPlayer);
        if (flag) {
            par2EntityPlayer.addStat(StatList.objectUseStats[this.itemID], 1);
        }
    }

    public void onDestroyBlock(int par1, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        boolean flag = Item.itemsList[this.itemID].onBlockDestroyed(this, par1, par2, par3, par4, par5EntityPlayer);
        if (flag) {
            par5EntityPlayer.addStat(StatList.objectUseStats[this.itemID], 1);
        }
    }

    public int getDamageVsEntity(Entity par1Entity) {
        return Item.itemsList[this.itemID].getDamageVsEntity(par1Entity);
    }

    public boolean canHarvestBlock(Block par1Block) {
        return Item.itemsList[this.itemID].canHarvestBlock(par1Block);
    }

    public void onItemDestroyedByUse(EntityPlayer entityplayer) {
    }

    public void useItemOnEntity(EntityLiving par1EntityLiving) {
        Item.itemsList[this.itemID].useItemOnEntity(this, par1EntityLiving);
    }

    public ItemStack copy() {
        ItemStack itemstack = new ItemStack(this.itemID, this.stackSize, this.itemDamage);
        if (this.stackTagCompound != null) {
            itemstack.stackTagCompound = (NBTTagCompound)this.stackTagCompound.copy();
            if (!itemstack.stackTagCompound.equals(this.stackTagCompound)) {
                return itemstack;
            }
        }
        return itemstack;
    }

    public static boolean func_46154_a(ItemStack par0ItemStack, ItemStack par1ItemStack) {
        if (par0ItemStack == null && par1ItemStack == null) {
            return true;
        }
        if (par0ItemStack == null || par1ItemStack == null) {
            return false;
        }
        if (par0ItemStack.stackTagCompound == null && par1ItemStack.stackTagCompound != null) {
            return false;
        }
        return par0ItemStack.stackTagCompound == null || par0ItemStack.stackTagCompound.equals(par1ItemStack.stackTagCompound);
    }

    public static boolean areItemStacksEqual(ItemStack par0ItemStack, ItemStack par1ItemStack) {
        if (par0ItemStack == null && par1ItemStack == null) {
            return true;
        }
        if (par0ItemStack == null || par1ItemStack == null) {
            return false;
        }
        return par0ItemStack.isItemStackEqual(par1ItemStack);
    }

    private boolean isItemStackEqual(ItemStack par1ItemStack) {
        if (this.stackSize != par1ItemStack.stackSize) {
            return false;
        }
        if (this.itemID != par1ItemStack.itemID) {
            return false;
        }
        if (this.itemDamage != par1ItemStack.itemDamage) {
            return false;
        }
        if (this.stackTagCompound == null && par1ItemStack.stackTagCompound != null) {
            return false;
        }
        return this.stackTagCompound == null || this.stackTagCompound.equals(par1ItemStack.stackTagCompound);
    }

    public boolean isItemEqual(ItemStack par1ItemStack) {
        return this.itemID == par1ItemStack.itemID && this.itemDamage == par1ItemStack.itemDamage;
    }

    public static ItemStack copyItemStack(ItemStack par0ItemStack) {
        return par0ItemStack != null ? par0ItemStack.copy() : null;
    }

    public String toString() {
        return this.stackSize + "x" + Item.itemsList[this.itemID].getItemName() + "@" + this.itemDamage;
    }

    public void updateAnimation(World par1World, Entity par2Entity, int par3, boolean par4) {
        if (this.animationsToGo > 0) {
            --this.animationsToGo;
        }
        Item.itemsList[this.itemID].onUpdate(this, par1World, par2Entity, par3, par4);
    }

    public void onCrafting(World par1World, EntityPlayer par2EntityPlayer, int par3) {
        par2EntityPlayer.addStat(StatList.objectCraftStats[this.itemID], par3);
        Item.itemsList[this.itemID].onCreated(this, par1World, par2EntityPlayer);
    }

    public boolean isStackEqual(ItemStack par1ItemStack) {
        return this.itemID == par1ItemStack.itemID && this.stackSize == par1ItemStack.stackSize && this.itemDamage == par1ItemStack.itemDamage;
    }

    public int getMaxItemUseDuration() {
        return this.getItem().getMaxItemUseDuration(this);
    }

    public EnumAction getItemUseAction() {
        return this.getItem().getItemUseAction(this);
    }

    public void onPlayerStoppedUsing(World par1World, EntityPlayer par2EntityPlayer, int par3) {
        this.getItem().onPlayerStoppedUsing(this, par1World, par2EntityPlayer, par3);
    }

    public boolean hasTagCompound() {
        return this.stackTagCompound != null;
    }

    public NBTTagCompound getTagCompound() {
        return this.stackTagCompound;
    }

    public NBTTagList getEnchantmentTagList() {
        if (this.stackTagCompound == null) {
            return null;
        }
        return (NBTTagList)this.stackTagCompound.getTag("ench");
    }

    public void setTagCompound(NBTTagCompound par1NBTTagCompound) {
        this.stackTagCompound = par1NBTTagCompound;
    }

    public List getItemNameandInformation() {
        NBTTagList nbttaglist;
        ArrayList<String> arraylist = new ArrayList<String>();
        Item item = Item.itemsList[this.itemID];
        arraylist.add(item.getItemDisplayName(this));
        item.addInformation(this, arraylist);
        if (this.hasTagCompound() && (nbttaglist = this.getEnchantmentTagList()) != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                short word0 = ((NBTTagCompound)nbttaglist.tagAt(i)).getShort("id");
                short word1 = ((NBTTagCompound)nbttaglist.tagAt(i)).getShort("lvl");
                if (Enchantment.enchantmentsList[word0] == null) continue;
                arraylist.add(Enchantment.enchantmentsList[word0].getTranslatedName(word1));
            }
        }
        return arraylist;
    }

    public boolean hasEffect() {
        return this.getItem().hasEffect(this);
    }

    public EnumRarity getRarity() {
        return this.getItem().getRarity(this);
    }

    public boolean isItemEnchantable() {
        if (!this.getItem().isItemTool(this)) {
            return false;
        }
        return !this.isItemEnchanted();
    }

    public void addEnchantment(Enchantment par1Enchantment, int par2) {
        if (this.stackTagCompound == null) {
            this.setTagCompound(new NBTTagCompound());
        }
        if (!this.stackTagCompound.hasKey("ench")) {
            this.stackTagCompound.setTag("ench", new NBTTagList("ench"));
        }
        NBTTagList nbttaglist = (NBTTagList)this.stackTagCompound.getTag("ench");
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setShort("id", (short)par1Enchantment.effectId);
        nbttagcompound.setShort("lvl", (byte)par2);
        nbttaglist.appendTag(nbttagcompound);
    }

    public boolean isItemEnchanted() {
        return this.stackTagCompound != null && this.stackTagCompound.hasKey("ench");
    }
}

