/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.LongHashMapEntry;

public class LongHashMap {
    private transient LongHashMapEntry[] hashArray = new LongHashMapEntry[16];
    private transient int numHashElements;
    private int capacity = 12;
    private final float percentUseable = 0.75f;
    private volatile transient int modCount;

    private static int getHashedKey(long par0) {
        return LongHashMap.hash((int)(par0 ^ par0 >>> 32));
    }

    private static int hash(int par0) {
        par0 ^= par0 >>> 20 ^ par0 >>> 12;
        return par0 ^ par0 >>> 7 ^ par0 >>> 4;
    }

    private static int getHashIndex(int par0, int par1) {
        return par0 & par1 - 1;
    }

    public int getNumHashElements() {
        return this.numHashElements;
    }

    public Object getValueByKey(long par1) {
        int i = LongHashMap.getHashedKey(par1);
        LongHashMapEntry longhashmapentry = this.hashArray[LongHashMap.getHashIndex(i, this.hashArray.length)];
        while (longhashmapentry != null) {
            if (longhashmapentry.key == par1) {
                return longhashmapentry.value;
            }
            longhashmapentry = longhashmapentry.nextEntry;
        }
        return null;
    }

    public boolean containsItem(long par1) {
        return this.getEntry(par1) != null;
    }

    final LongHashMapEntry getEntry(long par1) {
        int i = LongHashMap.getHashedKey(par1);
        LongHashMapEntry longhashmapentry = this.hashArray[LongHashMap.getHashIndex(i, this.hashArray.length)];
        while (longhashmapentry != null) {
            if (longhashmapentry.key == par1) {
                return longhashmapentry;
            }
            longhashmapentry = longhashmapentry.nextEntry;
        }
        return null;
    }

    public void add(long par1, Object par3Obj) {
        int i = LongHashMap.getHashedKey(par1);
        int j = LongHashMap.getHashIndex(i, this.hashArray.length);
        LongHashMapEntry longhashmapentry = this.hashArray[j];
        while (longhashmapentry != null) {
            if (longhashmapentry.key == par1) {
                longhashmapentry.value = par3Obj;
            }
            longhashmapentry = longhashmapentry.nextEntry;
        }
        ++this.modCount;
        this.createKey(i, par1, par3Obj, j);
    }

    private void resizeTable(int par1) {
        LongHashMapEntry[] alonghashmapentry = this.hashArray;
        int i = alonghashmapentry.length;
        if (i == 0x40000000) {
            this.capacity = Integer.MAX_VALUE;
            return;
        }
        LongHashMapEntry[] alonghashmapentry1 = new LongHashMapEntry[par1];
        this.copyHashTableTo(alonghashmapentry1);
        this.hashArray = alonghashmapentry1;
        this.capacity = (int)((float)par1 * 0.75f);
    }

    private void copyHashTableTo(LongHashMapEntry[] par1ArrayOfLongHashMapEntry) {
        LongHashMapEntry[] alonghashmapentry = this.hashArray;
        int i = par1ArrayOfLongHashMapEntry.length;
        for (int j = 0; j < alonghashmapentry.length; ++j) {
            LongHashMapEntry longhashmapentry1;
            LongHashMapEntry longhashmapentry = alonghashmapentry[j];
            if (longhashmapentry == null) continue;
            alonghashmapentry[j] = null;
            do {
                longhashmapentry1 = longhashmapentry.nextEntry;
                int k = LongHashMap.getHashIndex(longhashmapentry.hash, i);
                longhashmapentry.nextEntry = par1ArrayOfLongHashMapEntry[k];
                par1ArrayOfLongHashMapEntry[k] = longhashmapentry;
            } while ((longhashmapentry = longhashmapentry1) != null);
        }
    }

    public Object remove(long par1) {
        LongHashMapEntry longhashmapentry = this.removeKey(par1);
        return longhashmapentry != null ? longhashmapentry.value : null;
    }

    final LongHashMapEntry removeKey(long par1) {
        LongHashMapEntry longhashmapentry;
        int i = LongHashMap.getHashedKey(par1);
        int j = LongHashMap.getHashIndex(i, this.hashArray.length);
        LongHashMapEntry longhashmapentry1 = longhashmapentry = this.hashArray[j];
        while (longhashmapentry1 != null) {
            LongHashMapEntry longhashmapentry2 = longhashmapentry1.nextEntry;
            if (longhashmapentry1.key == par1) {
                ++this.modCount;
                --this.numHashElements;
                if (longhashmapentry == longhashmapentry1) {
                    this.hashArray[j] = longhashmapentry2;
                } else {
                    longhashmapentry.nextEntry = longhashmapentry2;
                }
                return longhashmapentry1;
            }
            longhashmapentry = longhashmapentry1;
            longhashmapentry1 = longhashmapentry2;
        }
        return longhashmapentry1;
    }

    private void createKey(int par1, long par2, Object par4Obj, int par5) {
        LongHashMapEntry longhashmapentry = this.hashArray[par5];
        this.hashArray[par5] = new LongHashMapEntry(par1, par2, par4Obj, longhashmapentry);
        if (this.numHashElements++ >= this.capacity) {
            this.resizeTable(2 * this.hashArray.length);
        }
    }

    static int getHashCode(long par0) {
        return LongHashMap.getHashedKey(par0);
    }
}

