/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.ComponentStrongholdStairs2;
import net.minecraft.src.MapGenStructure;
import net.minecraft.src.StructureStart;
import net.minecraft.src.StructureStrongholdStart;

public class MapGenStronghold
extends MapGenStructure {
    private BiomeGenBase[] allowedBiomeGenBases = new BiomeGenBase[]{BiomeGenBase.desert, BiomeGenBase.forest, BiomeGenBase.extremeHills, BiomeGenBase.swampland, BiomeGenBase.taiga, BiomeGenBase.icePlains, BiomeGenBase.iceMountains, BiomeGenBase.desertHills, BiomeGenBase.forestHills, BiomeGenBase.extremeHillsEdge, BiomeGenBase.jungle, BiomeGenBase.jungleHills};
    private boolean ranBiomeCheck;
    private ChunkCoordIntPair[] structureCoords = new ChunkCoordIntPair[3];

    @Override
    protected boolean canSpawnStructureAtCoords(int par1, int par2) {
        if (!this.ranBiomeCheck) {
            Random random = new Random();
            random.setSeed(this.worldObj.getSeed());
            double d = random.nextDouble() * Math.PI * 2.0;
            for (int k = 0; k < this.structureCoords.length; ++k) {
                double d1 = (1.25 + random.nextDouble()) * 32.0;
                int l = (int)Math.round(Math.cos(d) * d1);
                int i1 = (int)Math.round(Math.sin(d) * d1);
                ArrayList<BiomeGenBase> arraylist = new ArrayList<BiomeGenBase>();
                for (BiomeGenBase biomegenbase : this.allowedBiomeGenBases) {
                    arraylist.add(biomegenbase);
                }
                ChunkPosition chunkposition = this.worldObj.getWorldChunkManager().findBiomePosition((l << 4) + 8, (i1 << 4) + 8, 112, arraylist, random);
                if (chunkposition != null) {
                    l = chunkposition.x >> 4;
                    i1 = chunkposition.z >> 4;
                } else {
                    System.out.println("Placed stronghold in INVALID biome at (" + l + ", " + i1 + ")");
                }
                this.structureCoords[k] = new ChunkCoordIntPair(l, i1);
                d += Math.PI * 2 / (double)this.structureCoords.length;
            }
            this.ranBiomeCheck = true;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.structureCoords) {
            if (par1 != chunkcoordintpair.chunkXPos || par2 != chunkcoordintpair.chunkZPosition) continue;
            System.out.println(par1 + ", " + par2);
            return true;
        }
        return false;
    }

    @Override
    protected List func_40482_a() {
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>();
        for (ChunkCoordIntPair chunkcoordintpair : this.structureCoords) {
            if (chunkcoordintpair == null) continue;
            arraylist.add(chunkcoordintpair.getChunkPosition(64));
        }
        return arraylist;
    }

    @Override
    protected StructureStart getStructureStart(int par1, int par2) {
        StructureStrongholdStart structurestrongholdstart = new StructureStrongholdStart(this.worldObj, this.rand, par1, par2);
        while (structurestrongholdstart.getComponents().isEmpty() || ((ComponentStrongholdStairs2)structurestrongholdstart.getComponents().get((int)0)).portalRoom == null) {
            structurestrongholdstart = new StructureStrongholdStart(this.worldObj, this.rand, par1, par2);
        }
        return structurestrongholdstart;
    }
}

