/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Achievement;
import net.minecraft.src.BaseMod;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.BiomeGenEnd;
import net.minecraft.src.BiomeGenHell;
import net.minecraft.src.Block;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityEggInfo;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityRendererProxy;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.FurnaceRecipes;
import net.minecraft.src.GenLayerBiome;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IInventory;
import net.minecraft.src.IRecipe;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.KeyBinding;
import net.minecraft.src.MLProp;
import net.minecraft.src.ModTextureStatic;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.Profiler;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderPlayer;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatCrafting;
import net.minecraft.src.StatList;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.UnexpectedThrowable;
import net.minecraft.src.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class ModLoader {
    private static final List animList = new LinkedList();
    private static final Map blockModels = new HashMap();
    private static final Map blockSpecialInv = new HashMap();
    private static final File cfgdir;
    private static final File cfgfile;
    public static Level cfgLoggingLevel;
    private static Map classMap;
    private static long clock;
    public static final boolean DEBUG = false;
    private static Field field_animList;
    private static Field field_armorList;
    private static Field field_modifiers;
    private static Field field_TileEntityRenderers;
    private static boolean hasInit;
    private static int highestEntityId;
    private static final Map inGameHooks;
    private static final Map inGUIHooks;
    private static Minecraft instance;
    private static int itemSpriteIndex;
    private static int itemSpritesLeft;
    private static final Map keyList;
    private static String langPack;
    private static Map localizedStrings;
    private static final File logfile;
    private static final Logger logger;
    private static FileHandler logHandler;
    private static Method method_RegisterEntityID;
    private static Method method_RegisterTileEntity;
    private static final File modDir;
    private static final LinkedList modList;
    private static int nextBlockModelID;
    private static final Map overrides;
    private static final Map packetChannels;
    public static final Properties props;
    private static BiomeGenBase[] standardBiomes;
    private static int terrainSpriteIndex;
    private static int terrainSpritesLeft;
    private static String texPack;
    private static boolean texturesAdded;
    private static final boolean[] usedItemSprites;
    private static final boolean[] usedTerrainSprites;
    public static final String VERSION = "ModLoader 1.2.5";
    private static NetClientHandler netHandler;

    public static void addAchievementDesc(Achievement achievement, String s, String s1) {
        try {
            if (achievement.getName().contains(".")) {
                String[] as = achievement.getName().split("\\.");
                if (as.length == 2) {
                    String s2 = as[1];
                    ModLoader.addLocalization("achievement." + s2, s);
                    ModLoader.addLocalization("achievement." + s2 + ".desc", s1);
                    ModLoader.setPrivateValue(StatBase.class, (Object)achievement, 1, (Object)StatCollector.translateToLocal("achievement." + s2));
                    ModLoader.setPrivateValue(Achievement.class, (Object)achievement, 3, (Object)StatCollector.translateToLocal("achievement." + s2 + ".desc"));
                } else {
                    ModLoader.setPrivateValue(StatBase.class, (Object)achievement, 1, (Object)s);
                    ModLoader.setPrivateValue(Achievement.class, (Object)achievement, 3, (Object)s1);
                }
            } else {
                ModLoader.setPrivateValue(StatBase.class, (Object)achievement, 1, (Object)s);
                ModLoader.setPrivateValue(Achievement.class, (Object)achievement, 3, (Object)s1);
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.throwing("ModLoader", "AddAchievementDesc", illegalargumentexception);
            ModLoader.throwException(illegalargumentexception);
        }
        catch (SecurityException securityexception) {
            logger.throwing("ModLoader", "AddAchievementDesc", securityexception);
            ModLoader.throwException(securityexception);
        }
        catch (NoSuchFieldException nosuchfieldexception) {
            logger.throwing("ModLoader", "AddAchievementDesc", nosuchfieldexception);
            ModLoader.throwException(nosuchfieldexception);
        }
    }

    public static int addAllFuel(int i, int j) {
        logger.finest("Finding fuel for " + i);
        int k = 0;
        Iterator iterator = modList.iterator();
        while (iterator.hasNext() && k == 0) {
            k = ((BaseMod)iterator.next()).addFuel(i, j);
        }
        if (k != 0) {
            logger.finest("Returned " + k);
        }
        return k;
    }

    public static void addAllRenderers(Map map) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        for (BaseMod basemod : modList) {
            basemod.addRenderer(map);
        }
    }

    public static void addAnimation(TextureFX texturefx) {
        logger.finest("Adding animation " + texturefx.toString());
        for (TextureFX texturefx1 : animList) {
            if (texturefx1.iconIndex != texturefx.iconIndex || texturefx1.tileImage != texturefx.tileImage) continue;
            animList.remove(texturefx);
            break;
        }
        animList.add(texturefx);
    }

    public static int addArmor(String s) {
        try {
            String[] as = (String[])field_armorList.get(null);
            List<String> list = Arrays.asList(as);
            ArrayList<String> arraylist = new ArrayList<String>();
            arraylist.addAll(list);
            if (!arraylist.contains(s)) {
                arraylist.add(s);
            }
            int i = arraylist.indexOf(s);
            field_armorList.set(null, arraylist.toArray(new String[0]));
            return i;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.throwing("ModLoader", "AddArmor", illegalargumentexception);
            ModLoader.throwException("An impossible error has occured!", illegalargumentexception);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "AddArmor", illegalaccessexception);
            ModLoader.throwException("An impossible error has occured!", illegalaccessexception);
        }
        return -1;
    }

    public static void addBiome(BiomeGenBase biomegenbase) {
        BiomeGenBase[] abiomegenbase = GenLayerBiome.biomeArray;
        List<BiomeGenBase> list = Arrays.asList(abiomegenbase);
        ArrayList<BiomeGenBase> arraylist = new ArrayList<BiomeGenBase>();
        arraylist.addAll(list);
        if (!arraylist.contains(biomegenbase)) {
            arraylist.add(biomegenbase);
        }
        GenLayerBiome.biomeArray = arraylist.toArray(new BiomeGenBase[0]);
    }

    public static void addLocalization(String s, String s1) {
        ModLoader.addLocalization(s, "en_US", s1);
    }

    public static void addLocalization(String s, String s1, String s2) {
        Map obj;
        if (localizedStrings.containsKey(s1)) {
            obj = (Map)localizedStrings.get(s1);
        } else {
            obj = new HashMap();
            localizedStrings.put(s1, obj);
        }
        ((Map)obj).put(s, s2);
    }

    private static void addMod(ClassLoader classloader, String s) {
        try {
            Class<?> class1;
            String s1 = s.split("\\.")[0];
            if (s1.contains("$")) {
                return;
            }
            if (props.containsKey(s1) && (props.getProperty(s1).equalsIgnoreCase("no") || props.getProperty(s1).equalsIgnoreCase("off"))) {
                return;
            }
            Package package1 = ModLoader.class.getPackage();
            if (package1 != null) {
                s1 = String.valueOf(package1.getName()) + "." + s1;
            }
            if (!BaseMod.class.isAssignableFrom(class1 = classloader.loadClass(s1))) {
                return;
            }
            ModLoader.setupProperties(class1);
            BaseMod basemod = (BaseMod)class1.newInstance();
            if (basemod != null) {
                modList.add(basemod);
                logger.fine("Mod Initialized: \"" + basemod.toString() + "\" from " + s);
                System.out.println("Mod Initialized: " + basemod.toString());
            }
        }
        catch (Throwable throwable) {
            logger.fine("Failed to load mod from \"" + s + "\"");
            System.out.println("Failed to load mod from \"" + s + "\"");
            logger.throwing("ModLoader", "addMod", throwable);
            ModLoader.throwException(throwable);
        }
    }

    public static void addName(Object obj, String s) {
        ModLoader.addName(obj, "en_US", s);
    }

    public static void addName(Object obj, String s, String s1) {
        String s2 = null;
        if (obj instanceof Item) {
            Item item = (Item)obj;
            if (item.getItemName() != null) {
                s2 = String.valueOf(item.getItemName()) + ".name";
            }
        } else if (obj instanceof Block) {
            Block block = (Block)obj;
            if (block.getBlockName() != null) {
                s2 = String.valueOf(block.getBlockName()) + ".name";
            }
        } else if (obj instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)obj;
            String s3 = Item.itemsList[itemstack.itemID].getItemNameIS(itemstack);
            if (s3 != null) {
                s2 = String.valueOf(s3) + ".name";
            }
        } else {
            Exception exception = new Exception(String.valueOf(obj.getClass().getName()) + " cannot have name attached to it!");
            logger.throwing("ModLoader", "AddName", exception);
            ModLoader.throwException(exception);
        }
        if (s2 != null) {
            ModLoader.addLocalization(s2, s, s1);
        } else {
            Exception exception1 = new Exception(obj + " is missing name tag!");
            logger.throwing("ModLoader", "AddName", exception1);
            ModLoader.throwException(exception1);
        }
    }

    public static int addOverride(String s, String s1) {
        try {
            int i = ModLoader.getUniqueSpriteIndex(s);
            ModLoader.addOverride(s, s1, i);
            return i;
        }
        catch (Throwable throwable) {
            logger.throwing("ModLoader", "addOverride", throwable);
            ModLoader.throwException(throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static void addOverride(String s, String s1, int i) {
        int j = -1;
        int k = 0;
        if (s.equals("/terrain.png")) {
            j = 0;
            k = terrainSpritesLeft;
        } else if (s.equals("/gui/items.png")) {
            j = 1;
            k = itemSpritesLeft;
        } else {
            return;
        }
        System.out.println("Overriding " + s + " with " + s1 + " @ " + i + ". " + k + " left.");
        logger.finer("addOverride(" + s + "," + s1 + "," + i + "). " + k + " left.");
        HashMap<String, Integer> obj = (HashMap<String, Integer>)overrides.get(j);
        if (obj == null) {
            obj = new HashMap<String, Integer>();
            overrides.put(j, obj);
        }
        obj.put(s1, i);
    }

    public static void addRecipe(ItemStack itemstack, Object[] aobj) {
        CraftingManager.getInstance().addRecipe(itemstack, aobj);
    }

    public static void addShapelessRecipe(ItemStack itemstack, Object[] aobj) {
        CraftingManager.getInstance().addShapelessRecipe(itemstack, aobj);
    }

    public static void addSmelting(int i, ItemStack itemstack) {
        FurnaceRecipes.smelting().addSmelting(i, itemstack);
    }

    public static void addSpawn(Class class1, int i, int j, int k, EnumCreatureType enumcreaturetype) {
        ModLoader.addSpawn(class1, i, j, k, enumcreaturetype, null);
    }

    public static void addSpawn(Class class1, int i, int j, int k, EnumCreatureType enumcreaturetype, BiomeGenBase[] abiomegenbase) {
        if (class1 == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (enumcreaturetype == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (abiomegenbase == null) {
            abiomegenbase = standardBiomes;
        }
        for (int l = 0; l < abiomegenbase.length; ++l) {
            List list = abiomegenbase[l].getSpawnableList(enumcreaturetype);
            if (list == null) continue;
            boolean flag = false;
            for (SpawnListEntry spawnlistentry : list) {
                if (spawnlistentry.entityClass != class1) continue;
                spawnlistentry.itemWeight = i;
                spawnlistentry.minGroupCount = j;
                spawnlistentry.maxGroupCount = k;
                flag = true;
                break;
            }
            if (flag) continue;
            list.add(new SpawnListEntry(class1, i, j, k));
        }
    }

    public static void addSpawn(String s, int i, int j, int k, EnumCreatureType enumcreaturetype) {
        ModLoader.addSpawn(s, i, j, k, enumcreaturetype, null);
    }

    public static void addSpawn(String s, int i, int j, int k, EnumCreatureType enumcreaturetype, BiomeGenBase[] abiomegenbase) {
        Class class1 = (Class)classMap.get(s);
        if (class1 != null && EntityLiving.class.isAssignableFrom(class1)) {
            ModLoader.addSpawn(class1, i, j, k, enumcreaturetype, abiomegenbase);
        }
    }

    public static boolean dispenseEntity(World world, double d, double d1, double d2, int i, int j, ItemStack itemstack) {
        boolean flag = false;
        Iterator iterator = modList.iterator();
        while (iterator.hasNext() && !flag) {
            flag = ((BaseMod)iterator.next()).dispenseEntity(world, d, d1, d2, i, j, itemstack);
        }
        return flag;
    }

    public static void genericContainerRemoval(World world, int i, int j, int k) {
        IInventory iinventory = (IInventory)((Object)world.getBlockTileEntity(i, j, k));
        if (iinventory != null) {
            for (int l = 0; l < iinventory.getSizeInventory(); ++l) {
                ItemStack itemstack = iinventory.getStackInSlot(l);
                if (itemstack == null) continue;
                double d = world.rand.nextDouble() * 0.8 + 0.1;
                double d1 = world.rand.nextDouble() * 0.8 + 0.1;
                double d2 = world.rand.nextDouble() * 0.8 + 0.1;
                while (itemstack.stackSize > 0) {
                    int i1 = world.rand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                    double d3 = 0.05;
                    entityitem.motionX = world.rand.nextGaussian() * d3;
                    entityitem.motionY = world.rand.nextGaussian() * d3 + 0.2;
                    entityitem.motionZ = world.rand.nextGaussian() * d3;
                    if (itemstack.hasTagCompound()) {
                        entityitem.item.setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                    }
                    world.spawnEntityInWorld(entityitem);
                }
                iinventory.setInventorySlotContents(l, null);
            }
        }
    }

    public static List getLoadedMods() {
        return Collections.unmodifiableList(modList);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Minecraft getMinecraftInstance() {
        if (instance == null) {
            try {
                ThreadGroup threadgroup = Thread.currentThread().getThreadGroup();
                int i = threadgroup.activeCount();
                Thread[] athread = new Thread[i];
                threadgroup.enumerate(athread);
                for (int j = 0; j < athread.length; ++j) {
                    System.out.println(athread[j].getName());
                }
                for (int k = 0; k < athread.length; ++k) {
                    if (!athread[k].getName().equals("Minecraft main thread")) continue;
                    instance = (Minecraft)ModLoader.getPrivateValue(Thread.class, (Object)athread[k], "target");
                    break;
                }
            }
            catch (SecurityException securityexception) {
                logger.throwing("ModLoader", "getMinecraftInstance", securityexception);
                throw new RuntimeException(securityexception);
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                logger.throwing("ModLoader", "getMinecraftInstance", nosuchfieldexception);
                throw new RuntimeException(nosuchfieldexception);
            }
        }
        return instance;
    }

    public static Object getPrivateValue(Class class1, Object obj, int i) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = class1.getDeclaredFields()[i];
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "getPrivateValue", illegalaccessexception);
            ModLoader.throwException("An impossible error has occured!", illegalaccessexception);
            return null;
        }
    }

    public static Object getPrivateValue(Class class1, Object obj, String s) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = class1.getDeclaredField(s);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "getPrivateValue", illegalaccessexception);
            ModLoader.throwException("An impossible error has occured!", illegalaccessexception);
            return null;
        }
    }

    public static int getUniqueBlockModelID(BaseMod basemod, boolean flag) {
        int i = nextBlockModelID++;
        blockModels.put(i, basemod);
        blockSpecialInv.put(i, flag);
        return i;
    }

    public static int getUniqueEntityId() {
        return highestEntityId++;
    }

    private static int getUniqueItemSpriteIndex() {
        while (itemSpriteIndex < usedItemSprites.length) {
            if (!usedItemSprites[itemSpriteIndex]) {
                ModLoader.usedItemSprites[ModLoader.itemSpriteIndex] = true;
                --itemSpritesLeft;
                return itemSpriteIndex++;
            }
            ++itemSpriteIndex;
        }
        Exception exception = new Exception("No more empty item sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", exception);
        ModLoader.throwException(exception);
        return 0;
    }

    public static int getUniqueSpriteIndex(String s) {
        if (s.equals("/gui/items.png")) {
            return ModLoader.getUniqueItemSpriteIndex();
        }
        if (s.equals("/terrain.png")) {
            return ModLoader.getUniqueTerrainSpriteIndex();
        }
        Exception exception = new Exception("No registry for this texture: " + s);
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", exception);
        ModLoader.throwException(exception);
        return 0;
    }

    private static int getUniqueTerrainSpriteIndex() {
        while (terrainSpriteIndex < usedTerrainSprites.length) {
            if (!usedTerrainSprites[terrainSpriteIndex]) {
                ModLoader.usedTerrainSprites[ModLoader.terrainSpriteIndex] = true;
                --terrainSpritesLeft;
                return terrainSpriteIndex++;
            }
            ++terrainSpriteIndex;
        }
        Exception exception = new Exception("No more empty terrain sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", exception);
        ModLoader.throwException(exception);
        return 0;
    }

    private static void init() {
        hasInit = true;
        String s = "1111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111110111111111111111000111111111111101111111110000000101111111000000010101111100000000000000110000000000000000000000000000000000000000000000001111111111111111";
        String s1 = "1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111000000001111111100000111111111100000001111111110000001111111111111111111";
        for (int i = 0; i < 256; ++i) {
            boolean bl = ModLoader.usedItemSprites[i] = s.charAt(i) == '1';
            if (!usedItemSprites[i]) {
                ++itemSpritesLeft;
            }
            boolean bl2 = ModLoader.usedTerrainSprites[i] = s1.charAt(i) == '1';
            if (usedTerrainSprites[i]) continue;
            ++terrainSpritesLeft;
        }
        try {
            instance = (Minecraft)ModLoader.getPrivateValue(Minecraft.class, null, 1);
            ModLoader.instance.entityRenderer = new EntityRendererProxy(instance);
            classMap = (Map)ModLoader.getPrivateValue(EntityList.class, null, 0);
            field_modifiers = Field.class.getDeclaredField("modifiers");
            field_modifiers.setAccessible(true);
            field_TileEntityRenderers = TileEntityRenderer.class.getDeclaredFields()[0];
            field_TileEntityRenderers.setAccessible(true);
            field_armorList = RenderPlayer.class.getDeclaredFields()[3];
            field_modifiers.setInt(field_armorList, field_armorList.getModifiers() & 0xFFFFFFEF);
            field_armorList.setAccessible(true);
            field_animList = RenderEngine.class.getDeclaredFields()[6];
            field_animList.setAccessible(true);
            Field[] afield = BiomeGenBase.class.getDeclaredFields();
            LinkedList<BiomeGenBase> linkedlist = new LinkedList<BiomeGenBase>();
            for (int j = 0; j < afield.length; ++j) {
                BiomeGenBase biomegenbase;
                Class<BiomeGenBase> class1 = afield[j].getType();
                if ((afield[j].getModifiers() & 8) == 0 || !class1.isAssignableFrom(BiomeGenBase.class) || (biomegenbase = (BiomeGenBase)afield[j].get(null)) instanceof BiomeGenHell || biomegenbase instanceof BiomeGenEnd) continue;
                linkedlist.add(biomegenbase);
            }
            standardBiomes = linkedlist.toArray(new BiomeGenBase[0]);
            try {
                method_RegisterTileEntity = TileEntity.class.getDeclaredMethod("a", Class.class, String.class);
            }
            catch (NoSuchMethodException nosuchmethodexception1) {
                method_RegisterTileEntity = TileEntity.class.getDeclaredMethod("addMapping", Class.class, String.class);
            }
            method_RegisterTileEntity.setAccessible(true);
            try {
                method_RegisterEntityID = EntityList.class.getDeclaredMethod("a", Class.class, String.class, Integer.TYPE);
            }
            catch (NoSuchMethodException nosuchmethodexception2) {
                method_RegisterEntityID = EntityList.class.getDeclaredMethod("addMapping", Class.class, String.class, Integer.TYPE);
            }
            method_RegisterEntityID.setAccessible(true);
        }
        catch (SecurityException securityexception) {
            logger.throwing("ModLoader", "init", securityexception);
            ModLoader.throwException(securityexception);
            throw new RuntimeException(securityexception);
        }
        catch (NoSuchFieldException nosuchfieldexception) {
            logger.throwing("ModLoader", "init", nosuchfieldexception);
            ModLoader.throwException(nosuchfieldexception);
            throw new RuntimeException(nosuchfieldexception);
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            logger.throwing("ModLoader", "init", nosuchmethodexception);
            ModLoader.throwException(nosuchmethodexception);
            throw new RuntimeException(nosuchmethodexception);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.throwing("ModLoader", "init", illegalargumentexception);
            ModLoader.throwException(illegalargumentexception);
            throw new RuntimeException(illegalargumentexception);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "init", illegalaccessexception);
            ModLoader.throwException(illegalaccessexception);
            throw new RuntimeException(illegalaccessexception);
        }
        try {
            ModLoader.loadConfig();
            if (props.containsKey("loggingLevel")) {
                cfgLoggingLevel = Level.parse(props.getProperty("loggingLevel"));
            }
            if (props.containsKey("grassFix")) {
                RenderBlocks.cfgGrassFix = Boolean.parseBoolean(props.getProperty("grassFix"));
            }
            logger.setLevel(cfgLoggingLevel);
            if ((logfile.exists() || logfile.createNewFile()) && logfile.canWrite() && logHandler == null) {
                logHandler = new FileHandler(logfile.getPath());
                logHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(logHandler);
            }
            logger.fine("ModLoader 1.2.5 Initializing...");
            System.out.println("ModLoader 1.2.5 Initializing...");
            File file = new File(ModLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            modDir.mkdirs();
            ModLoader.readFromClassPath(file);
            ModLoader.readFromModFolder(modDir);
            ModLoader.sortModList();
            for (BaseMod basemod : modList) {
                basemod.load();
                logger.fine("Mod Loaded: \"" + basemod.toString() + "\"");
                System.out.println("Mod Loaded: " + basemod.toString());
                if (props.containsKey(basemod.getClass().getSimpleName())) continue;
                props.setProperty(basemod.getClass().getSimpleName(), "on");
            }
            for (BaseMod basemod1 : modList) {
                basemod1.modsLoaded();
            }
            System.out.println("Done.");
            props.setProperty("loggingLevel", cfgLoggingLevel.getName());
            props.setProperty("grassFix", Boolean.toString(RenderBlocks.cfgGrassFix));
            ModLoader.instance.gameSettings.keyBindings = ModLoader.registerAllKeys(ModLoader.instance.gameSettings.keyBindings);
            ModLoader.instance.gameSettings.loadOptions();
            ModLoader.initStats();
            ModLoader.saveConfig();
        }
        catch (Throwable throwable) {
            logger.throwing("ModLoader", "init", throwable);
            ModLoader.throwException("ModLoader has failed to initialize.", throwable);
            if (logHandler != null) {
                logHandler.close();
            }
            throw new RuntimeException(throwable);
        }
    }

    private static void initStats() {
        for (int i = 0; i < Block.blocksList.length; ++i) {
            if (StatList.oneShotStats.containsKey(0x1000000 + i) || Block.blocksList[i] == null || !Block.blocksList[i].getEnableStats()) continue;
            String s = StatCollector.translateToLocalFormatted("stat.mineBlock", new Object[]{Block.blocksList[i].translateBlockName()});
            StatList.mineBlockStatArray[i] = new StatCrafting(0x1000000 + i, s, i).registerStat();
            StatList.objectMineStats.add(StatList.mineBlockStatArray[i]);
        }
        for (int j = 0; j < Item.itemsList.length; ++j) {
            if (!StatList.oneShotStats.containsKey(0x1020000 + j) && Item.itemsList[j] != null) {
                String s1 = StatCollector.translateToLocalFormatted("stat.useItem", new Object[]{Item.itemsList[j].getStatName()});
                StatList.objectUseStats[j] = new StatCrafting(0x1020000 + j, s1, j).registerStat();
                if (j >= Block.blocksList.length) {
                    StatList.itemStats.add(StatList.objectUseStats[j]);
                }
            }
            if (StatList.oneShotStats.containsKey(0x1030000 + j) || Item.itemsList[j] == null || !Item.itemsList[j].isDamageable()) continue;
            String s2 = StatCollector.translateToLocalFormatted("stat.breakItem", new Object[]{Item.itemsList[j].getStatName()});
            StatList.objectBreakStats[j] = new StatCrafting(0x1030000 + j, s2, j).registerStat();
        }
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (Object obj : CraftingManager.getInstance().getRecipeList()) {
            hashset.add(((IRecipe)obj).getRecipeOutput().itemID);
        }
        for (Object obj1 : FurnaceRecipes.smelting().getSmeltingList().values()) {
            hashset.add(((ItemStack)obj1).itemID);
        }
        Iterator iterator2 = hashset.iterator();
        while (iterator2.hasNext()) {
            int k = (Integer)iterator2.next();
            if (StatList.oneShotStats.containsKey(0x1010000 + k) || Item.itemsList[k] == null) continue;
            String s3 = StatCollector.translateToLocalFormatted("stat.craftItem", new Object[]{Item.itemsList[k].getStatName()});
            StatList.objectCraftStats[k] = new StatCrafting(0x1010000 + k, s3, k).registerStat();
        }
    }

    public static boolean isGUIOpen(Class class1) {
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        if (class1 == null) {
            return minecraft.currentScreen == null;
        }
        if (minecraft.currentScreen == null && class1 != null) {
            return false;
        }
        return class1.isInstance(minecraft.currentScreen);
    }

    public static boolean isModLoaded(String s) {
        for (BaseMod basemod : modList) {
            if (!s.contentEquals(basemod.getName())) continue;
            return true;
        }
        return false;
    }

    public static void loadConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canRead()) {
            FileInputStream fileinputstream = new FileInputStream(cfgfile);
            props.load(fileinputstream);
            fileinputstream.close();
        }
    }

    public static BufferedImage loadImage(RenderEngine renderengine, String s) throws Exception {
        TexturePackList texturepacklist = (TexturePackList)ModLoader.getPrivateValue(RenderEngine.class, (Object)renderengine, 11);
        InputStream inputstream = texturepacklist.selectedTexturePack.getResourceAsStream(s);
        if (inputstream == null) {
            throw new Exception("Image not found: " + s);
        }
        BufferedImage bufferedimage = ImageIO.read(inputstream);
        if (bufferedimage == null) {
            throw new Exception("Image corrupted: " + s);
        }
        return bufferedimage;
    }

    public static void onItemPickup(EntityPlayer entityplayer, ItemStack itemstack) {
        for (BaseMod basemod : modList) {
            basemod.onItemPickup(entityplayer, itemstack);
        }
    }

    public static void onTick(float f, Minecraft minecraft) {
        Profiler.endSection();
        Profiler.endSection();
        Profiler.startSection("modtick");
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        if (texPack == null || minecraft.gameSettings.skin != texPack) {
            texturesAdded = false;
            texPack = minecraft.gameSettings.skin;
        }
        if (langPack == null || StringTranslate.getInstance().getCurrentLanguage() != langPack) {
            Properties properties = null;
            try {
                properties = (Properties)ModLoader.getPrivateValue(StringTranslate.class, (Object)StringTranslate.getInstance(), 1);
            }
            catch (SecurityException securityexception) {
                logger.throwing("ModLoader", "AddLocalization", securityexception);
                ModLoader.throwException(securityexception);
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                logger.throwing("ModLoader", "AddLocalization", nosuchfieldexception);
                ModLoader.throwException(nosuchfieldexception);
            }
            langPack = StringTranslate.getInstance().getCurrentLanguage();
            if (properties != null) {
                if (localizedStrings.containsKey("en_US")) {
                    properties.putAll((Map<?, ?>)((Map)localizedStrings.get("en_US")));
                }
                if (!langPack.contentEquals("en_US") && localizedStrings.containsKey(langPack)) {
                    properties.putAll((Map<?, ?>)((Map)localizedStrings.get(langPack)));
                }
            }
        }
        if (!texturesAdded && minecraft.renderEngine != null) {
            ModLoader.registerAllTextureOverrides(minecraft.renderEngine);
            texturesAdded = true;
        }
        long l = 0L;
        if (minecraft.theWorld != null) {
            l = minecraft.theWorld.getWorldTime();
            Iterator iterator = inGameHooks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry1 = iterator.next();
                if (clock == l && ((Boolean)entry1.getValue()).booleanValue() || ((BaseMod)entry1.getKey()).onTickInGame(f, minecraft)) continue;
                iterator.remove();
            }
        }
        if (minecraft.standardGalacticFontRenderer != null) {
            Iterator iterator1 = inGUIHooks.entrySet().iterator();
            while (iterator1.hasNext()) {
                Map.Entry entry2 = iterator1.next();
                if (clock == l && (Boolean)entry2.getValue() & minecraft.theWorld != null || ((BaseMod)entry2.getKey()).onTickInGUI(f, minecraft, minecraft.currentScreen)) continue;
                iterator1.remove();
            }
        }
        if (clock != l) {
            for (Map.Entry entry : keyList.entrySet()) {
                for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                    int i = ((KeyBinding)entry3.getKey()).keyCode;
                    boolean flag = i < 0 ? Mouse.isButtonDown((int)(i += 100)) : Keyboard.isKeyDown((int)i);
                    boolean[] aflag = (boolean[])entry3.getValue();
                    boolean flag1 = aflag[1];
                    aflag[1] = flag;
                    if (!flag || flag1 && !aflag[0]) continue;
                    ((BaseMod)entry.getKey()).keyboardEvent((KeyBinding)entry3.getKey());
                }
            }
        }
        clock = l;
        Profiler.endSection();
        Profiler.startSection("render");
        Profiler.startSection("gameRenderer");
    }

    public static void openGUI(EntityPlayer entityplayer, GuiScreen guiscreen) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        if (minecraft.renderViewEntity != entityplayer) {
            return;
        }
        if (guiscreen != null) {
            minecraft.displayGuiScreen(guiscreen);
        }
    }

    public static void populateChunk(IChunkProvider ichunkprovider, int i, int j, World world) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Random random = new Random(world.getSeed());
        long l = random.nextLong() / 2L * 2L + 1L;
        long l1 = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)i * l + (long)j * l1 ^ world.getSeed());
        for (BaseMod basemod : modList) {
            if (ichunkprovider.makeString().equals("RandomLevelSource")) {
                basemod.generateSurface(world, random, i << 4, j << 4);
                continue;
            }
            if (!ichunkprovider.makeString().equals("HellRandomLevelSource")) continue;
            basemod.generateNether(world, random, i << 4, j << 4);
        }
    }

    private static void readFromClassPath(File file) throws FileNotFoundException, IOException {
        logger.finer("Adding mods from " + file.getCanonicalPath());
        ClassLoader classloader = ModLoader.class.getClassLoader();
        if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
            ZipEntry zipentry;
            logger.finer("Zip found.");
            FileInputStream fileinputstream = new FileInputStream(file);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            Object obj = null;
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                String s1 = zipentry.getName();
                if (zipentry.isDirectory() || !s1.startsWith("mod_") || !s1.endsWith(".class")) continue;
                ModLoader.addMod(classloader, s1);
            }
            fileinputstream.close();
        } else if (file.isDirectory()) {
            Package package1 = ModLoader.class.getPackage();
            if (package1 != null) {
                String s = package1.getName().replace('.', File.separatorChar);
                file = new File(file, s);
            }
            logger.finer("Directory found.");
            File[] afile = file.listFiles();
            if (afile != null) {
                for (int i = 0; i < afile.length; ++i) {
                    String s2 = afile[i].getName();
                    if (!afile[i].isFile() || !s2.startsWith("mod_") || !s2.endsWith(".class")) continue;
                    ModLoader.addMod(classloader, s2);
                }
            }
        }
    }

    private static void readFromModFolder(File file) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        ClassLoader classloader = Minecraft.class.getClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("folder must be a Directory.");
        }
        Object[] afile = file.listFiles();
        Arrays.sort(afile);
        if (classloader instanceof URLClassLoader) {
            for (int i = 0; i < afile.length; ++i) {
                Object file1 = afile[i];
                if (!((File)file1).isDirectory() && (!((File)file1).isFile() || !((File)file1).getName().endsWith(".jar") && !((File)file1).getName().endsWith(".zip"))) continue;
                method.invoke((Object)classloader, ((File)file1).toURI().toURL());
            }
        }
        for (int j = 0; j < afile.length; ++j) {
            Object file2 = afile[j];
            if (!((File)file2).isDirectory() && (!((File)file2).isFile() || !((File)file2).getName().endsWith(".jar") && !((File)file2).getName().endsWith(".zip"))) continue;
            logger.finer("Adding mods from " + ((File)file2).getCanonicalPath());
            if (((File)file2).isFile()) {
                ZipEntry zipentry;
                logger.finer("Zip found.");
                FileInputStream fileinputstream = new FileInputStream((File)file2);
                ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
                Object obj = null;
                while ((zipentry = zipinputstream.getNextEntry()) != null) {
                    String s1 = zipentry.getName();
                    if (zipentry.isDirectory() || !s1.startsWith("mod_") || !s1.endsWith(".class")) continue;
                    ModLoader.addMod(classloader, s1);
                }
                zipinputstream.close();
                fileinputstream.close();
                continue;
            }
            if (!((File)file2).isDirectory()) continue;
            Package package1 = ModLoader.class.getPackage();
            if (package1 != null) {
                String s = package1.getName().replace('.', File.separatorChar);
                file2 = new File((File)file2, s);
            }
            logger.finer("Directory found.");
            File[] afile1 = ((File)file2).listFiles();
            if (afile1 == null) continue;
            for (int k = 0; k < afile1.length; ++k) {
                String s2 = afile1[k].getName();
                if (!afile1[k].isFile() || !s2.startsWith("mod_") || !s2.endsWith(".class")) continue;
                ModLoader.addMod(classloader, s2);
            }
        }
    }

    public static void receivePacket(Packet250CustomPayload packet250custompayload) {
        BaseMod basemod;
        if (packetChannels.containsKey(packet250custompayload.channel) && (basemod = (BaseMod)packetChannels.get(packet250custompayload.channel)) != null) {
            basemod.receiveCustomPacket(packet250custompayload);
        }
    }

    public static KeyBinding[] registerAllKeys(KeyBinding[] akeybinding) {
        LinkedList<KeyBinding> linkedlist = new LinkedList<KeyBinding>();
        linkedlist.addAll(Arrays.asList(akeybinding));
        for (Map map : keyList.values()) {
            linkedlist.addAll(map.keySet());
        }
        return linkedlist.toArray(new KeyBinding[0]);
    }

    public static void registerAllTextureOverrides(RenderEngine renderengine) {
        animList.clear();
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        for (BaseMod basemod : modList) {
            basemod.registerAnimation(minecraft);
        }
        for (TextureFX texturefx : animList) {
            renderengine.registerTextureFX(texturefx);
        }
        for (Map.Entry entry : overrides.entrySet()) {
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                String s = (String)entry1.getKey();
                int i = (Integer)entry1.getValue();
                int j = (Integer)entry.getKey();
                try {
                    BufferedImage bufferedimage = ModLoader.loadImage(renderengine, s);
                    ModTextureStatic modtexturestatic = new ModTextureStatic(i, j, bufferedimage);
                    renderengine.registerTextureFX(modtexturestatic);
                }
                catch (Exception exception) {
                    logger.throwing("ModLoader", "RegisterAllTextureOverrides", exception);
                    ModLoader.throwException(exception);
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static void registerBlock(Block block) {
        ModLoader.registerBlock(block, null);
    }

    public static void registerBlock(Block block, Class class1) {
        try {
            if (block == null) {
                throw new IllegalArgumentException("block parameter cannot be null.");
            }
            int i = block.blockID;
            ItemBlock itemblock = null;
            itemblock = class1 != null ? (ItemBlock)class1.getConstructor(Integer.TYPE).newInstance(i - 256) : new ItemBlock(i - 256);
            if (Block.blocksList[i] != null && Item.itemsList[i] == null) {
                Item.itemsList[i] = itemblock;
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.throwing("ModLoader", "RegisterBlock", illegalargumentexception);
            ModLoader.throwException(illegalargumentexception);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "RegisterBlock", illegalaccessexception);
            ModLoader.throwException(illegalaccessexception);
        }
        catch (SecurityException securityexception) {
            logger.throwing("ModLoader", "RegisterBlock", securityexception);
            ModLoader.throwException(securityexception);
        }
        catch (InstantiationException instantiationexception) {
            logger.throwing("ModLoader", "RegisterBlock", instantiationexception);
            ModLoader.throwException(instantiationexception);
        }
        catch (InvocationTargetException invocationtargetexception) {
            logger.throwing("ModLoader", "RegisterBlock", invocationtargetexception);
            ModLoader.throwException(invocationtargetexception);
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            logger.throwing("ModLoader", "RegisterBlock", nosuchmethodexception);
            ModLoader.throwException(nosuchmethodexception);
        }
    }

    public static void registerEntityID(Class class1, String s, int i) {
        try {
            method_RegisterEntityID.invoke(null, class1, s, i);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.throwing("ModLoader", "RegisterEntityID", illegalargumentexception);
            ModLoader.throwException(illegalargumentexception);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "RegisterEntityID", illegalaccessexception);
            ModLoader.throwException(illegalaccessexception);
        }
        catch (InvocationTargetException invocationtargetexception) {
            logger.throwing("ModLoader", "RegisterEntityID", invocationtargetexception);
            ModLoader.throwException(invocationtargetexception);
        }
    }

    public static void registerEntityID(Class class1, String s, int i, int j, int k) {
        ModLoader.registerEntityID(class1, s, i);
        EntityList.entityEggs.put(i, new EntityEggInfo(i, j, k));
    }

    public static void registerKey(BaseMod basemod, KeyBinding keybinding, boolean flag) {
        HashMap obj = (HashMap)keyList.get(basemod);
        if (obj == null) {
            obj = new HashMap();
        }
        boolean[] aflag = new boolean[2];
        aflag[0] = flag;
        ((Map)obj).put(keybinding, aflag);
        keyList.put(basemod, obj);
    }

    public static void registerPacketChannel(BaseMod basemod, String s) {
        if (s.length() >= 16) {
            throw new RuntimeException(String.format("Invalid channel name: %s. Must be less than 16 characters.", s));
        }
        packetChannels.put(s, basemod);
    }

    public static void registerTileEntity(Class class1, String s) {
        ModLoader.registerTileEntity(class1, s, null);
    }

    public static void registerTileEntity(Class class1, String s, TileEntitySpecialRenderer tileentityspecialrenderer) {
        try {
            method_RegisterTileEntity.invoke(null, class1, s);
            if (tileentityspecialrenderer != null) {
                TileEntityRenderer tileentityrenderer = TileEntityRenderer.instance;
                Map map = (Map)field_TileEntityRenderers.get(tileentityrenderer);
                map.put(class1, tileentityspecialrenderer);
                tileentityspecialrenderer.setTileEntityRenderer(tileentityrenderer);
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.throwing("ModLoader", "RegisterTileEntity", illegalargumentexception);
            ModLoader.throwException(illegalargumentexception);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "RegisterTileEntity", illegalaccessexception);
            ModLoader.throwException(illegalaccessexception);
        }
        catch (InvocationTargetException invocationtargetexception) {
            logger.throwing("ModLoader", "RegisterTileEntity", invocationtargetexception);
            ModLoader.throwException(invocationtargetexception);
        }
    }

    public static void removeBiome(BiomeGenBase biomegenbase) {
        BiomeGenBase[] abiomegenbase = GenLayerBiome.biomeArray;
        List<BiomeGenBase> list = Arrays.asList(abiomegenbase);
        ArrayList<BiomeGenBase> arraylist = new ArrayList<BiomeGenBase>();
        arraylist.addAll(list);
        if (arraylist.contains(biomegenbase)) {
            arraylist.remove(biomegenbase);
        }
        GenLayerBiome.biomeArray = arraylist.toArray(new BiomeGenBase[0]);
    }

    public static void removeSpawn(Class class1, EnumCreatureType enumcreaturetype) {
        ModLoader.removeSpawn(class1, enumcreaturetype, null);
    }

    public static void removeSpawn(Class class1, EnumCreatureType enumcreaturetype, BiomeGenBase[] abiomegenbase) {
        if (class1 == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (enumcreaturetype == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (abiomegenbase == null) {
            abiomegenbase = standardBiomes;
        }
        for (int i = 0; i < abiomegenbase.length; ++i) {
            List list = abiomegenbase[i].getSpawnableList(enumcreaturetype);
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SpawnListEntry spawnlistentry = (SpawnListEntry)iterator.next();
                if (spawnlistentry.entityClass != class1) continue;
                iterator.remove();
            }
        }
    }

    public static void removeSpawn(String s, EnumCreatureType enumcreaturetype) {
        ModLoader.removeSpawn(s, enumcreaturetype, null);
    }

    public static void removeSpawn(String s, EnumCreatureType enumcreaturetype, BiomeGenBase[] abiomegenbase) {
        Class class1 = (Class)classMap.get(s);
        if (class1 != null && EntityLiving.class.isAssignableFrom(class1)) {
            ModLoader.removeSpawn(class1, enumcreaturetype, abiomegenbase);
        }
    }

    public static boolean renderBlockIsItemFull3D(int i) {
        if (!blockSpecialInv.containsKey(i)) {
            return i == 16;
        }
        return (Boolean)blockSpecialInv.get(i);
    }

    public static void renderInvBlock(RenderBlocks renderblocks, Block block, int i, int j) {
        BaseMod basemod = (BaseMod)blockModels.get(j);
        if (basemod == null) {
            return;
        }
        basemod.renderInvBlock(renderblocks, block, i, j);
    }

    public static boolean renderWorldBlock(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int l) {
        BaseMod basemod = (BaseMod)blockModels.get(l);
        if (basemod == null) {
            return false;
        }
        return basemod.renderWorldBlock(renderblocks, iblockaccess, i, j, k, block, l);
    }

    public static void saveConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canWrite()) {
            FileOutputStream fileoutputstream = new FileOutputStream(cfgfile);
            props.store(fileoutputstream, "ModLoader Config");
            fileoutputstream.close();
        }
    }

    public static void serverChat(String s) {
        for (BaseMod basemod : modList) {
            basemod.receiveChatPacket(s);
        }
    }

    public static void serverConnect(NetClientHandler netclienthandler, Packet1Login packet1login) {
        netHandler = netclienthandler;
        if (packetChannels.size() > 0) {
            Packet250CustomPayload packet250custompayload = new Packet250CustomPayload();
            packet250custompayload.channel = "REGISTER";
            StringBuilder stringbuilder = new StringBuilder();
            Iterator iterator1 = packetChannels.keySet().iterator();
            stringbuilder.append((String)iterator1.next());
            while (iterator1.hasNext()) {
                stringbuilder.append("\u0000");
                stringbuilder.append((String)iterator1.next());
            }
            packet250custompayload.data = stringbuilder.toString().getBytes(Charset.forName("UTF8"));
            packet250custompayload.length = packet250custompayload.data.length;
            ModLoader.sendPacket(packet250custompayload);
        }
        for (BaseMod basemod : modList) {
            basemod.serverConnect(netHandler);
        }
    }

    public static void serverDisconnect() {
        for (BaseMod basemod : modList) {
            basemod.serverDisconnect();
        }
        netHandler = null;
    }

    public static void sendPacket(Packet packet) {
        if (netHandler != null) {
            netHandler.addToSendQueue(packet);
        }
    }

    public static void setInGameHook(BaseMod basemod, boolean flag, boolean flag1) {
        if (flag) {
            inGameHooks.put(basemod, flag1);
        } else {
            inGameHooks.remove(basemod);
        }
    }

    public static void setInGUIHook(BaseMod basemod, boolean flag, boolean flag1) {
        if (flag) {
            inGUIHooks.put(basemod, flag1);
        } else {
            inGUIHooks.remove(basemod);
        }
    }

    public static void setPrivateValue(Class class1, Object obj, int i, Object obj1) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = class1.getDeclaredFields()[i];
            field.setAccessible(true);
            int j = field_modifiers.getInt(field);
            if ((j & 0x10) != 0) {
                field_modifiers.setInt(field, j & 0xFFFFFFEF);
            }
            field.set(obj, obj1);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "setPrivateValue", illegalaccessexception);
            ModLoader.throwException("An impossible error has occured!", illegalaccessexception);
        }
    }

    public static void setPrivateValue(Class class1, Object obj, String s, Object obj1) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = class1.getDeclaredField(s);
            int i = field_modifiers.getInt(field);
            if ((i & 0x10) != 0) {
                field_modifiers.setInt(field, i & 0xFFFFFFEF);
            }
            field.setAccessible(true);
            field.set(obj, obj1);
        }
        catch (IllegalAccessException illegalaccessexception) {
            logger.throwing("ModLoader", "setPrivateValue", illegalaccessexception);
            ModLoader.throwException("An impossible error has occured!", illegalaccessexception);
        }
    }

    private static void setupProperties(Class class1) throws IllegalArgumentException, IllegalAccessException, IOException, SecurityException, NoSuchFieldException, NoSuchAlgorithmException, DigestException {
        LinkedList<Field> linkedlist = new LinkedList<Field>();
        Properties properties = new Properties();
        int i = 0;
        int j = 0;
        File file = new File(cfgdir, String.valueOf(class1.getSimpleName()) + ".cfg");
        if (file.exists() && file.canRead()) {
            properties.load(new FileInputStream(file));
        }
        if (properties.containsKey("checksum")) {
            j = Integer.parseInt(properties.getProperty("checksum"), 36);
        }
        for (Field field : class1.getDeclaredFields()) {
            if ((field.getModifiers() & 8) == 0 || !field.isAnnotationPresent(MLProp.class)) continue;
            linkedlist.add(field);
            Object obj = field.get(null);
            i += obj.hashCode();
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (Field field1 : linkedlist) {
            if ((field1.getModifiers() & 8) == 0 || !field1.isAnnotationPresent(MLProp.class)) continue;
            Class<Object> class2 = field1.getType();
            MLProp mlprop = field1.getAnnotation(MLProp.class);
            String s = mlprop.name().length() != 0 ? mlprop.name() : field1.getName();
            Object obj1 = field1.get(null);
            StringBuilder stringbuilder1 = new StringBuilder();
            if (mlprop.min() != Double.NEGATIVE_INFINITY) {
                stringbuilder1.append(String.format(",>=%.1f", mlprop.min()));
            }
            if (mlprop.max() != Double.POSITIVE_INFINITY) {
                stringbuilder1.append(String.format(",<=%.1f", mlprop.max()));
            }
            StringBuilder stringbuilder2 = new StringBuilder();
            if (mlprop.info().length() > 0) {
                stringbuilder2.append(" -- ");
                stringbuilder2.append(mlprop.info());
            }
            stringbuilder.append(String.format("%s (%s:%s%s)%s\n", s, class2.getName(), obj1, stringbuilder1, stringbuilder2));
            if (j == i && properties.containsKey(s)) {
                String s1 = properties.getProperty(s);
                Object obj2 = null;
                if (class2.isAssignableFrom(String.class)) {
                    obj2 = s1;
                } else if (class2.isAssignableFrom(Integer.TYPE)) {
                    obj2 = Integer.parseInt(s1);
                } else if (class2.isAssignableFrom(Short.TYPE)) {
                    obj2 = Short.parseShort(s1);
                } else if (class2.isAssignableFrom(Byte.TYPE)) {
                    obj2 = Byte.parseByte(s1);
                } else if (class2.isAssignableFrom(Boolean.TYPE)) {
                    obj2 = Boolean.parseBoolean(s1);
                } else if (class2.isAssignableFrom(Float.TYPE)) {
                    obj2 = Float.valueOf(Float.parseFloat(s1));
                } else if (class2.isAssignableFrom(Double.TYPE)) {
                    obj2 = Double.parseDouble(s1);
                }
                if (obj2 == null) continue;
                if (obj2 instanceof Number) {
                    double d = ((Number)obj2).doubleValue();
                    if (mlprop.min() != Double.NEGATIVE_INFINITY && d < mlprop.min() || mlprop.max() != Double.POSITIVE_INFINITY && d > mlprop.max()) continue;
                }
                logger.finer(String.valueOf(s) + " set to " + obj2);
                if (obj2.equals(obj1)) continue;
                field1.set(null, obj2);
                continue;
            }
            logger.finer(String.valueOf(s) + " not in config, using default: " + obj1);
            properties.setProperty(s, obj1.toString());
        }
        properties.put("checksum", Integer.toString(i, 36));
        if (!properties.isEmpty() && (file.exists() || file.createNewFile()) && file.canWrite()) {
            properties.store(new FileOutputStream(file), stringbuilder.toString());
        }
    }

    private static void sortModList() throws Exception {
        HashMap<String, BaseMod> hashmap = new HashMap<String, BaseMod>();
        for (BaseMod basemod : ModLoader.getLoadedMods()) {
            hashmap.put(basemod.getClass().getSimpleName(), basemod);
        }
        LinkedList<BaseMod> linkedlist = new LinkedList<BaseMod>();
        for (int i = 0; linkedlist.size() != modList.size() && i <= 10; ++i) {
            block2: for (BaseMod basemod1 : modList) {
                if (linkedlist.contains(basemod1)) continue;
                String s = basemod1.getPriorities();
                if (s == null || s.length() == 0 || s.indexOf(58) == -1) {
                    linkedlist.add(basemod1);
                    continue;
                }
                if (i <= 0) continue;
                int j = -1;
                int k = Integer.MIN_VALUE;
                int l = Integer.MAX_VALUE;
                String[] as = s.indexOf(59) > 0 ? s.split(";") : new String[]{s};
                for (int i1 = 0; i1 < as.length; ++i1) {
                    String s1 = as[i1];
                    if (s1.indexOf(58) == -1) continue;
                    String[] as1 = s1.split(":");
                    String s2 = as1[0];
                    String s3 = as1[1];
                    if (!s2.contentEquals("required-before") && !s2.contentEquals("before") && !s2.contentEquals("after") && !s2.contentEquals("required-after")) continue;
                    if (s3.contentEquals("*")) {
                        if (s2.contentEquals("required-before") || s2.contentEquals("before")) {
                            j = 0;
                            break;
                        }
                        if (!s2.contentEquals("required-after") && !s2.contentEquals("after")) break;
                        j = linkedlist.size();
                        break;
                    }
                    if ((s2.contentEquals("required-before") || s2.contentEquals("required-after")) && !hashmap.containsKey(s3)) {
                        throw new Exception(String.format("%s is missing dependency: %s", basemod1, s3));
                    }
                    BaseMod basemod2 = (BaseMod)hashmap.get(s3);
                    if (!linkedlist.contains(basemod2)) continue block2;
                    int j1 = linkedlist.indexOf(basemod2);
                    if (s2.contentEquals("required-before") || s2.contentEquals("before")) {
                        j = j1;
                        if (j < l) {
                            l = j;
                            continue;
                        }
                        j = l;
                        continue;
                    }
                    if (!s2.contentEquals("required-after") && !s2.contentEquals("after")) continue;
                    j = j1 + 1;
                    if (j > k) {
                        k = j;
                        continue;
                    }
                    j = k;
                }
                if (j == -1) continue;
                linkedlist.add(j, basemod1);
            }
        }
        modList.clear();
        modList.addAll(linkedlist);
    }

    public static void takenFromCrafting(EntityPlayer entityplayer, ItemStack itemstack, IInventory iinventory) {
        for (BaseMod basemod : modList) {
            basemod.takenFromCrafting(entityplayer, itemstack, iinventory);
        }
    }

    public static void takenFromFurnace(EntityPlayer entityplayer, ItemStack itemstack) {
        for (BaseMod basemod : modList) {
            basemod.takenFromFurnace(entityplayer, itemstack);
        }
    }

    public static void throwException(String s, Throwable throwable) {
        Minecraft minecraft = ModLoader.getMinecraftInstance();
        if (minecraft == null) {
            throw new RuntimeException(throwable);
        }
        minecraft.displayUnexpectedThrowable(new UnexpectedThrowable(s, throwable));
    }

    private static void throwException(Throwable throwable) {
        ModLoader.throwException("Exception occured in ModLoader", throwable);
    }

    private ModLoader() {
    }

    static {
        classMap = null;
        clock = 0L;
        field_animList = null;
        field_armorList = null;
        field_modifiers = null;
        field_TileEntityRenderers = null;
        hasInit = false;
        highestEntityId = 3000;
        inGameHooks = new HashMap();
        inGUIHooks = new HashMap();
        instance = null;
        itemSpriteIndex = 0;
        itemSpritesLeft = 0;
        keyList = new HashMap();
        langPack = null;
        localizedStrings = new HashMap();
        logfile = new File(Minecraft.getMinecraftDir(), "ModLoader.txt");
        logger = Logger.getLogger("ModLoader");
        logHandler = null;
        method_RegisterEntityID = null;
        method_RegisterTileEntity = null;
        modDir = new File(Minecraft.getMinecraftDir(), "/mods/");
        modList = new LinkedList();
        nextBlockModelID = 1000;
        overrides = new HashMap();
        packetChannels = new HashMap();
        props = new Properties();
        terrainSpriteIndex = 0;
        terrainSpritesLeft = 0;
        texPack = null;
        texturesAdded = false;
        usedItemSprites = new boolean[256];
        usedTerrainSprites = new boolean[256];
        netHandler = null;
        cfgdir = new File(Minecraft.getMinecraftDir(), "/config/");
        cfgfile = new File(cfgdir, "ModLoader.cfg");
        cfgLoggingLevel = Level.FINER;
    }
}

