/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TextureFX;
import org.lwjgl.opengl.GL11;

public class ModTextureStatic
extends TextureFX {
    private boolean oldanaglyph;
    private int[] pixels = null;

    public ModTextureStatic(int i, int j, BufferedImage bufferedimage) {
        this(i, 1, j, bufferedimage);
    }

    public ModTextureStatic(int i, int j, int k, BufferedImage bufferedimage) {
        super(i);
        this.tileSize = j;
        this.tileImage = k;
        this.bindImage(ModLoader.getMinecraftInstance().renderEngine);
        int l = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / 16;
        int i1 = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) / 16;
        int j1 = bufferedimage.getWidth();
        int k1 = bufferedimage.getHeight();
        this.pixels = new int[l * i1];
        this.imageData = new byte[l * i1 * 4];
        if (j1 != k1 || j1 != l) {
            BufferedImage bufferedimage1 = new BufferedImage(l, i1, 6);
            Graphics2D graphics2d = bufferedimage1.createGraphics();
            graphics2d.drawImage(bufferedimage, 0, 0, l, i1, 0, 0, j1, k1, null);
            bufferedimage1.getRGB(0, 0, l, i1, this.pixels, 0, l);
            graphics2d.dispose();
        } else {
            bufferedimage.getRGB(0, 0, j1, k1, this.pixels, 0, j1);
        }
        this.update();
    }

    public void update() {
        for (int i = 0; i < this.pixels.length; ++i) {
            int j = this.pixels[i] >> 24 & 0xFF;
            int k = this.pixels[i] >> 16 & 0xFF;
            int l = this.pixels[i] >> 8 & 0xFF;
            int i1 = this.pixels[i] >> 0 & 0xFF;
            if (this.anaglyphEnabled) {
                int j1;
                l = i1 = (j1 = (k + l + i1) / 3);
                k = i1;
            }
            this.imageData[i * 4 + 0] = (byte)k;
            this.imageData[i * 4 + 1] = (byte)l;
            this.imageData[i * 4 + 2] = (byte)i1;
            this.imageData[i * 4 + 3] = (byte)j;
        }
        this.oldanaglyph = this.anaglyphEnabled;
    }

    @Override
    public void onTick() {
        if (this.oldanaglyph != this.anaglyphEnabled) {
            this.update();
        }
    }

    public static BufferedImage scale2x(BufferedImage bufferedimage) {
        int j2 = bufferedimage.getWidth();
        int k2 = bufferedimage.getHeight();
        BufferedImage bufferedimage1 = new BufferedImage(j2 * 2, k2 * 2, 2);
        for (int l2 = 0; l2 < k2; ++l2) {
            for (int i3 = 0; i3 < j2; ++i3) {
                int i1;
                int l;
                int k;
                int j;
                int i = bufferedimage.getRGB(i3, l2);
                int j1 = l2 == 0 ? i : bufferedimage.getRGB(i3, l2 - 1);
                int k1 = i3 == 0 ? i : bufferedimage.getRGB(i3 - 1, l2);
                int l1 = i3 >= j2 - 1 ? i : bufferedimage.getRGB(i3 + 1, l2);
                int i2 = l2 >= k2 - 1 ? i : bufferedimage.getRGB(i3, l2 + 1);
                if (j1 != i2 && k1 != l1) {
                    j = k1 != j1 ? i : k1;
                    k = j1 != l1 ? i : l1;
                    l = k1 != i2 ? i : k1;
                    i1 = i2 != l1 ? i : l1;
                } else {
                    j = i;
                    k = i;
                    l = i;
                    i1 = i;
                }
                bufferedimage1.setRGB(i3 * 2, l2 * 2, j);
                bufferedimage1.setRGB(i3 * 2 + 1, l2 * 2, k);
                bufferedimage1.setRGB(i3 * 2, l2 * 2 + 1, l);
                bufferedimage1.setRGB(i3 * 2 + 1, l2 * 2 + 1, i1);
            }
        }
        return bufferedimage1;
    }
}

