/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagByte;
import net.minecraft.src.NBTTagByteArray;
import net.minecraft.src.NBTTagDouble;
import net.minecraft.src.NBTTagFloat;
import net.minecraft.src.NBTTagInt;
import net.minecraft.src.NBTTagIntArray;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.NBTTagLong;
import net.minecraft.src.NBTTagShort;
import net.minecraft.src.NBTTagString;

public class NBTTagCompound
extends NBTBase {
    private Map tagMap = new HashMap();

    public NBTTagCompound() {
        super("");
    }

    public NBTTagCompound(String par1Str) {
        super(par1Str);
    }

    @Override
    void write(DataOutput par1DataOutput) throws IOException {
        for (NBTBase nbtbase : this.tagMap.values()) {
            NBTBase.writeNamedTag(nbtbase, par1DataOutput);
        }
        par1DataOutput.writeByte(0);
    }

    @Override
    void load(DataInput par1DataInput) throws IOException {
        NBTBase nbtbase;
        this.tagMap.clear();
        while ((nbtbase = NBTBase.readNamedTag(par1DataInput)).getId() != 0) {
            this.tagMap.put(nbtbase.getName(), nbtbase);
        }
    }

    public Collection getTags() {
        return this.tagMap.values();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public void setTag(String par1Str, NBTBase par2NBTBase) {
        this.tagMap.put(par1Str, par2NBTBase.setName(par1Str));
    }

    public void setByte(String par1Str, byte par2) {
        this.tagMap.put(par1Str, new NBTTagByte(par1Str, par2));
    }

    public void setShort(String par1Str, short par2) {
        this.tagMap.put(par1Str, new NBTTagShort(par1Str, par2));
    }

    public void setInteger(String par1Str, int par2) {
        this.tagMap.put(par1Str, new NBTTagInt(par1Str, par2));
    }

    public void setLong(String par1Str, long par2) {
        this.tagMap.put(par1Str, new NBTTagLong(par1Str, par2));
    }

    public void setFloat(String par1Str, float par2) {
        this.tagMap.put(par1Str, new NBTTagFloat(par1Str, par2));
    }

    public void setDouble(String par1Str, double par2) {
        this.tagMap.put(par1Str, new NBTTagDouble(par1Str, par2));
    }

    public void setString(String par1Str, String par2Str) {
        this.tagMap.put(par1Str, new NBTTagString(par1Str, par2Str));
    }

    public void setByteArray(String par1Str, byte[] par2ArrayOfByte) {
        this.tagMap.put(par1Str, new NBTTagByteArray(par1Str, par2ArrayOfByte));
    }

    public void func_48183_a(String par1Str, int[] par2ArrayOfInteger) {
        this.tagMap.put(par1Str, new NBTTagIntArray(par1Str, par2ArrayOfInteger));
    }

    public void setCompoundTag(String par1Str, NBTTagCompound par2NBTTagCompound) {
        this.tagMap.put(par1Str, par2NBTTagCompound.setName(par1Str));
    }

    public void setBoolean(String par1Str, boolean par2) {
        this.setByte(par1Str, (byte)(par2 ? 1 : 0));
    }

    public NBTBase getTag(String par1Str) {
        return (NBTBase)this.tagMap.get(par1Str);
    }

    public boolean hasKey(String par1Str) {
        return this.tagMap.containsKey(par1Str);
    }

    public byte getByte(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return 0;
        }
        return ((NBTTagByte)this.tagMap.get((Object)par1Str)).data;
    }

    public short getShort(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return 0;
        }
        return ((NBTTagShort)this.tagMap.get((Object)par1Str)).data;
    }

    public int getInteger(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return 0;
        }
        return ((NBTTagInt)this.tagMap.get((Object)par1Str)).data;
    }

    public long getLong(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return 0L;
        }
        return ((NBTTagLong)this.tagMap.get((Object)par1Str)).data;
    }

    public float getFloat(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return 0.0f;
        }
        return ((NBTTagFloat)this.tagMap.get((Object)par1Str)).data;
    }

    public double getDouble(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return 0.0;
        }
        return ((NBTTagDouble)this.tagMap.get((Object)par1Str)).data;
    }

    public String getString(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return "";
        }
        return ((NBTTagString)this.tagMap.get((Object)par1Str)).data;
    }

    public byte[] getByteArray(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return new byte[0];
        }
        return ((NBTTagByteArray)this.tagMap.get((Object)par1Str)).byteArray;
    }

    public int[] func_48182_l(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return new int[0];
        }
        return ((NBTTagIntArray)this.tagMap.get((Object)par1Str)).field_48181_a;
    }

    public NBTTagCompound getCompoundTag(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return new NBTTagCompound(par1Str);
        }
        return (NBTTagCompound)this.tagMap.get(par1Str);
    }

    public NBTTagList getTagList(String par1Str) {
        if (!this.tagMap.containsKey(par1Str)) {
            return new NBTTagList(par1Str);
        }
        return (NBTTagList)this.tagMap.get(par1Str);
    }

    public boolean getBoolean(String par1Str) {
        return this.getByte(par1Str) != 0;
    }

    public String toString() {
        return "" + this.tagMap.size() + " entries";
    }

    @Override
    public NBTBase copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound(this.getName());
        for (String s : this.tagMap.keySet()) {
            nbttagcompound.setTag(s, ((NBTBase)this.tagMap.get(s)).copy());
        }
        return nbttagcompound;
    }

    @Override
    public boolean equals(Object par1Obj) {
        if (super.equals(par1Obj)) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)par1Obj;
            return ((Object)this.tagMap.entrySet()).equals(nbttagcompound.tagMap.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.tagMap).hashCode();
    }
}

