/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Container;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityCrit2FX;
import net.minecraft.src.EntityEgg;
import net.minecraft.src.EntityEnderCrystal;
import net.minecraft.src.EntityEnderEye;
import net.minecraft.src.EntityEnderPearl;
import net.minecraft.src.EntityExpBottle;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityFireball;
import net.minecraft.src.EntityFishHook;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityOtherPlayerMP;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPickupFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityPotion;
import net.minecraft.src.EntitySmallFireball;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.Explosion;
import net.minecraft.src.GuiDisconnected;
import net.minecraft.src.GuiDownloadTerrain;
import net.minecraft.src.GuiPlayerInfo;
import net.minecraft.src.GuiWinGame;
import net.minecraft.src.InventoryBasic;
import net.minecraft.src.Item;
import net.minecraft.src.ItemMap;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapStorage;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NetHandler;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet0KeepAlive;
import net.minecraft.src.Packet100OpenWindow;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet103SetSlot;
import net.minecraft.src.Packet104WindowItems;
import net.minecraft.src.Packet105UpdateProgressbar;
import net.minecraft.src.Packet106Transaction;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet130UpdateSign;
import net.minecraft.src.Packet131MapData;
import net.minecraft.src.Packet132TileEntityData;
import net.minecraft.src.Packet17Sleep;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet200Statistic;
import net.minecraft.src.Packet201PlayerInfo;
import net.minecraft.src.Packet202PlayerAbilities;
import net.minecraft.src.Packet20NamedEntitySpawn;
import net.minecraft.src.Packet21PickupSpawn;
import net.minecraft.src.Packet22Collect;
import net.minecraft.src.Packet23VehicleSpawn;
import net.minecraft.src.Packet24MobSpawn;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet25EntityPainting;
import net.minecraft.src.Packet26EntityExpOrb;
import net.minecraft.src.Packet28EntityVelocity;
import net.minecraft.src.Packet29DestroyEntity;
import net.minecraft.src.Packet2Handshake;
import net.minecraft.src.Packet30Entity;
import net.minecraft.src.Packet34EntityTeleport;
import net.minecraft.src.Packet35EntityHeadRotation;
import net.minecraft.src.Packet38EntityStatus;
import net.minecraft.src.Packet39AttachEntity;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet40EntityMetadata;
import net.minecraft.src.Packet41EntityEffect;
import net.minecraft.src.Packet42RemoveEntityEffect;
import net.minecraft.src.Packet43Experience;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet50PreChunk;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet52MultiBlockChange;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.Packet54PlayNoteBlock;
import net.minecraft.src.Packet5PlayerInventory;
import net.minecraft.src.Packet60Explosion;
import net.minecraft.src.Packet61DoorChange;
import net.minecraft.src.Packet6SpawnPosition;
import net.minecraft.src.Packet70Bed;
import net.minecraft.src.Packet71Weather;
import net.minecraft.src.Packet8UpdateHealth;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.PlayerControllerMP;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.StatList;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.WorldClient;
import net.minecraft.src.WorldProviderSurface;
import net.minecraft.src.WorldSettings;

public class NetClientHandler
extends NetHandler {
    private boolean disconnected = false;
    private NetworkManager netManager;
    public String field_1209_a;
    private Minecraft mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    public MapStorage mapStorage = new MapStorage(null);
    private Map playerInfoMap = new HashMap();
    public List playerNames = new ArrayList();
    public int currentServerMaxPlayers = 20;
    Random rand = new Random();

    public NetClientHandler(Minecraft par1Minecraft, String par2Str, int par3) throws UnknownHostException, IOException {
        this.mc = par1Minecraft;
        Socket socket = new Socket(InetAddress.getByName(par2Str), par3);
        this.netManager = new NetworkManager(socket, "Client", this);
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    @Override
    public void handleLogin(Packet1Login par1Packet1Login) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statFileWriter.readStat(StatList.joinMultiplayerStat, 1);
        this.worldClient = new WorldClient(this, new WorldSettings(0L, par1Packet1Login.serverMode, false, false, par1Packet1Login.terrainType), par1Packet1Login.field_48170_e, par1Packet1Login.difficultySetting);
        this.worldClient.isRemote = true;
        this.mc.changeWorld1(this.worldClient);
        this.mc.thePlayer.dimension = par1Packet1Login.field_48170_e;
        this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        this.mc.thePlayer.entityId = par1Packet1Login.protocolVersion;
        this.currentServerMaxPlayers = par1Packet1Login.maxPlayers;
        ((PlayerControllerMP)this.mc.playerController).setCreative(par1Packet1Login.serverMode == 1);
        ModLoader.serverConnect(this, par1Packet1Login);
    }

    @Override
    public void handlePickupSpawn(Packet21PickupSpawn par1Packet21PickupSpawn) {
        double d = (double)par1Packet21PickupSpawn.xPosition / 32.0;
        double d1 = (double)par1Packet21PickupSpawn.yPosition / 32.0;
        double d2 = (double)par1Packet21PickupSpawn.zPosition / 32.0;
        EntityItem entityitem = new EntityItem(this.worldClient, d, d1, d2, new ItemStack(par1Packet21PickupSpawn.itemID, par1Packet21PickupSpawn.count, par1Packet21PickupSpawn.itemDamage));
        entityitem.motionX = (double)par1Packet21PickupSpawn.rotation / 128.0;
        entityitem.motionY = (double)par1Packet21PickupSpawn.pitch / 128.0;
        entityitem.motionZ = (double)par1Packet21PickupSpawn.roll / 128.0;
        entityitem.serverPosX = par1Packet21PickupSpawn.xPosition;
        entityitem.serverPosY = par1Packet21PickupSpawn.yPosition;
        entityitem.serverPosZ = par1Packet21PickupSpawn.zPosition;
        this.worldClient.addEntityToWorld(par1Packet21PickupSpawn.entityId, entityitem);
    }

    @Override
    public void handleVehicleSpawn(Packet23VehicleSpawn par1Packet23VehicleSpawn) {
        double d = (double)par1Packet23VehicleSpawn.xPosition / 32.0;
        double d1 = (double)par1Packet23VehicleSpawn.yPosition / 32.0;
        double d2 = (double)par1Packet23VehicleSpawn.zPosition / 32.0;
        Entity obj = null;
        if (par1Packet23VehicleSpawn.type == 10) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 0);
        } else if (par1Packet23VehicleSpawn.type == 11) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 1);
        } else if (par1Packet23VehicleSpawn.type == 12) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 2);
        } else if (par1Packet23VehicleSpawn.type == 90) {
            obj = new EntityFishHook(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 60) {
            obj = new EntityArrow(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 61) {
            obj = new EntitySnowball(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 65) {
            obj = new EntityEnderPearl(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 72) {
            obj = new EntityEnderEye(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 63) {
            obj = new EntityFireball(this.worldClient, d, d1, d2, (double)par1Packet23VehicleSpawn.speedX / 8000.0, (double)par1Packet23VehicleSpawn.speedY / 8000.0, (double)par1Packet23VehicleSpawn.speedZ / 8000.0);
            par1Packet23VehicleSpawn.throwerEntityId = 0;
        } else if (par1Packet23VehicleSpawn.type == 64) {
            obj = new EntitySmallFireball(this.worldClient, d, d1, d2, (double)par1Packet23VehicleSpawn.speedX / 8000.0, (double)par1Packet23VehicleSpawn.speedY / 8000.0, (double)par1Packet23VehicleSpawn.speedZ / 8000.0);
            par1Packet23VehicleSpawn.throwerEntityId = 0;
        } else if (par1Packet23VehicleSpawn.type == 62) {
            obj = new EntityEgg(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 73) {
            obj = new EntityPotion(this.worldClient, d, d1, d2, par1Packet23VehicleSpawn.throwerEntityId);
            par1Packet23VehicleSpawn.throwerEntityId = 0;
        } else if (par1Packet23VehicleSpawn.type == 75) {
            obj = new EntityExpBottle(this.worldClient, d, d1, d2);
            par1Packet23VehicleSpawn.throwerEntityId = 0;
        } else if (par1Packet23VehicleSpawn.type == 1) {
            obj = new EntityBoat(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 50) {
            obj = new EntityTNTPrimed(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 51) {
            obj = new EntityEnderCrystal(this.worldClient, d, d1, d2);
        } else if (par1Packet23VehicleSpawn.type == 70) {
            obj = new EntityFallingSand(this.worldClient, d, d1, d2, Block.sand.blockID);
        } else if (par1Packet23VehicleSpawn.type == 71) {
            obj = new EntityFallingSand(this.worldClient, d, d1, d2, Block.gravel.blockID);
        } else if (par1Packet23VehicleSpawn.type == 74) {
            obj = new EntityFallingSand(this.worldClient, d, d1, d2, Block.dragonEgg.blockID);
        }
        if (obj != null) {
            obj.serverPosX = par1Packet23VehicleSpawn.xPosition;
            obj.serverPosY = par1Packet23VehicleSpawn.yPosition;
            obj.serverPosZ = par1Packet23VehicleSpawn.zPosition;
            obj.rotationYaw = 0.0f;
            obj.rotationPitch = 0.0f;
            Entity[] aentity = obj.getParts();
            if (aentity != null) {
                int i = par1Packet23VehicleSpawn.entityId - obj.entityId;
                for (int j = 0; j < aentity.length; ++j) {
                    aentity[j].entityId += i;
                }
            }
            obj.entityId = par1Packet23VehicleSpawn.entityId;
            this.worldClient.addEntityToWorld(par1Packet23VehicleSpawn.entityId, obj);
            if (par1Packet23VehicleSpawn.throwerEntityId > 0) {
                Entity entity;
                if (par1Packet23VehicleSpawn.type == 60 && (entity = this.getEntityByID(par1Packet23VehicleSpawn.throwerEntityId)) instanceof EntityLiving) {
                    ((EntityArrow)obj).shootingEntity = (EntityLiving)entity;
                }
                obj.setVelocity((double)par1Packet23VehicleSpawn.speedX / 8000.0, (double)par1Packet23VehicleSpawn.speedY / 8000.0, (double)par1Packet23VehicleSpawn.speedZ / 8000.0);
            }
        }
    }

    @Override
    public void handleEntityExpOrb(Packet26EntityExpOrb par1Packet26EntityExpOrb) {
        EntityXPOrb entityxporb = new EntityXPOrb(this.worldClient, par1Packet26EntityExpOrb.posX, par1Packet26EntityExpOrb.posY, par1Packet26EntityExpOrb.posZ, par1Packet26EntityExpOrb.xpValue);
        entityxporb.serverPosX = par1Packet26EntityExpOrb.posX;
        entityxporb.serverPosY = par1Packet26EntityExpOrb.posY;
        entityxporb.serverPosZ = par1Packet26EntityExpOrb.posZ;
        entityxporb.rotationYaw = 0.0f;
        entityxporb.rotationPitch = 0.0f;
        entityxporb.entityId = par1Packet26EntityExpOrb.entityId;
        this.worldClient.addEntityToWorld(par1Packet26EntityExpOrb.entityId, entityxporb);
    }

    @Override
    public void handleWeather(Packet71Weather par1Packet71Weather) {
        double d = (double)par1Packet71Weather.posX / 32.0;
        double d1 = (double)par1Packet71Weather.posY / 32.0;
        double d2 = (double)par1Packet71Weather.posZ / 32.0;
        EntityLightningBolt entitylightningbolt = null;
        if (par1Packet71Weather.isLightningBolt == 1) {
            entitylightningbolt = new EntityLightningBolt(this.worldClient, d, d1, d2);
        }
        if (entitylightningbolt != null) {
            entitylightningbolt.serverPosX = par1Packet71Weather.posX;
            entitylightningbolt.serverPosY = par1Packet71Weather.posY;
            entitylightningbolt.serverPosZ = par1Packet71Weather.posZ;
            entitylightningbolt.rotationYaw = 0.0f;
            entitylightningbolt.rotationPitch = 0.0f;
            entitylightningbolt.entityId = par1Packet71Weather.entityID;
            this.worldClient.addWeatherEffect(entitylightningbolt);
        }
    }

    @Override
    public void handleEntityPainting(Packet25EntityPainting par1Packet25EntityPainting) {
        EntityPainting entitypainting = new EntityPainting(this.worldClient, par1Packet25EntityPainting.xPosition, par1Packet25EntityPainting.yPosition, par1Packet25EntityPainting.zPosition, par1Packet25EntityPainting.direction, par1Packet25EntityPainting.title);
        this.worldClient.addEntityToWorld(par1Packet25EntityPainting.entityId, entitypainting);
    }

    @Override
    public void handleEntityVelocity(Packet28EntityVelocity par1Packet28EntityVelocity) {
        Entity entity = this.getEntityByID(par1Packet28EntityVelocity.entityId);
        if (entity != null) {
            entity.setVelocity((double)par1Packet28EntityVelocity.motionX / 8000.0, (double)par1Packet28EntityVelocity.motionY / 8000.0, (double)par1Packet28EntityVelocity.motionZ / 8000.0);
        }
    }

    @Override
    public void handleEntityMetadata(Packet40EntityMetadata par1Packet40EntityMetadata) {
        Entity entity = this.getEntityByID(par1Packet40EntityMetadata.entityId);
        if (entity != null && par1Packet40EntityMetadata.getMetadata() != null) {
            entity.getDataWatcher().updateWatchedObjectsFromList(par1Packet40EntityMetadata.getMetadata());
        }
    }

    @Override
    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn par1Packet20NamedEntitySpawn) {
        double d = (double)par1Packet20NamedEntitySpawn.xPosition / 32.0;
        double d1 = (double)par1Packet20NamedEntitySpawn.yPosition / 32.0;
        double d2 = (double)par1Packet20NamedEntitySpawn.zPosition / 32.0;
        float f = (float)(par1Packet20NamedEntitySpawn.rotation * 360) / 256.0f;
        float f1 = (float)(par1Packet20NamedEntitySpawn.pitch * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.mc.theWorld, par1Packet20NamedEntitySpawn.name);
        entityotherplayermp.serverPosX = par1Packet20NamedEntitySpawn.xPosition;
        entityotherplayermp.prevPosX = entityotherplayermp.lastTickPosX = (double)entityotherplayermp.serverPosX;
        entityotherplayermp.serverPosY = par1Packet20NamedEntitySpawn.yPosition;
        entityotherplayermp.prevPosY = entityotherplayermp.lastTickPosY = (double)entityotherplayermp.serverPosY;
        entityotherplayermp.serverPosZ = par1Packet20NamedEntitySpawn.zPosition;
        entityotherplayermp.prevPosZ = entityotherplayermp.lastTickPosZ = (double)entityotherplayermp.serverPosZ;
        int i = par1Packet20NamedEntitySpawn.currentItem;
        entityotherplayermp.inventory.mainInventory[entityotherplayermp.inventory.currentItem] = i == 0 ? null : new ItemStack(i, 1, 0);
        entityotherplayermp.setPositionAndRotation(d, d1, d2, f, f1);
        this.worldClient.addEntityToWorld(par1Packet20NamedEntitySpawn.entityId, entityotherplayermp);
    }

    @Override
    public void handleEntityTeleport(Packet34EntityTeleport par1Packet34EntityTeleport) {
        Entity entity = this.getEntityByID(par1Packet34EntityTeleport.entityId);
        if (entity != null) {
            entity.serverPosX = par1Packet34EntityTeleport.xPosition;
            entity.serverPosY = par1Packet34EntityTeleport.yPosition;
            entity.serverPosZ = par1Packet34EntityTeleport.zPosition;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = (float)(par1Packet34EntityTeleport.yaw * 360) / 256.0f;
            float f1 = (float)(par1Packet34EntityTeleport.pitch * 360) / 256.0f;
            entity.setPositionAndRotation2(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntity(Packet30Entity par1Packet30Entity) {
        Entity entity = this.getEntityByID(par1Packet30Entity.entityId);
        if (entity != null) {
            entity.serverPosX += par1Packet30Entity.xPosition;
            entity.serverPosY += par1Packet30Entity.yPosition;
            entity.serverPosZ += par1Packet30Entity.zPosition;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = par1Packet30Entity.rotating ? (float)(par1Packet30Entity.yaw * 360) / 256.0f : entity.rotationYaw;
            float f1 = par1Packet30Entity.rotating ? (float)(par1Packet30Entity.pitch * 360) / 256.0f : entity.rotationPitch;
            entity.setPositionAndRotation2(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntityHeadRotation(Packet35EntityHeadRotation par1Packet35EntityHeadRotation) {
        Entity entity = this.getEntityByID(par1Packet35EntityHeadRotation.entityId);
        if (entity != null) {
            float f = (float)(par1Packet35EntityHeadRotation.headRotationYaw * 360) / 256.0f;
            entity.func_48079_f(f);
        }
    }

    @Override
    public void handleDestroyEntity(Packet29DestroyEntity par1Packet29DestroyEntity) {
        this.worldClient.removeEntityFromWorld(par1Packet29DestroyEntity.entityId);
    }

    @Override
    public void handleFlying(Packet10Flying par1Packet10Flying) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.posX;
        double d1 = entityplayersp.posY;
        double d2 = entityplayersp.posZ;
        float f = entityplayersp.rotationYaw;
        float f1 = entityplayersp.rotationPitch;
        if (par1Packet10Flying.moving) {
            d = par1Packet10Flying.xPosition;
            d1 = par1Packet10Flying.yPosition;
            d2 = par1Packet10Flying.zPosition;
        }
        if (par1Packet10Flying.rotating) {
            f = par1Packet10Flying.yaw;
            f1 = par1Packet10Flying.pitch;
        }
        entityplayersp.ySize = 0.0f;
        entityplayersp.motionZ = 0.0;
        entityplayersp.motionY = 0.0;
        entityplayersp.motionX = 0.0;
        entityplayersp.setPositionAndRotation(d, d1, d2, f, f1);
        par1Packet10Flying.xPosition = entityplayersp.posX;
        par1Packet10Flying.yPosition = entityplayersp.boundingBox.minY;
        par1Packet10Flying.zPosition = entityplayersp.posZ;
        par1Packet10Flying.stance = entityplayersp.posY;
        this.netManager.addToSendQueue(par1Packet10Flying);
        if (!this.field_1210_g) {
            this.mc.thePlayer.prevPosX = this.mc.thePlayer.posX;
            this.mc.thePlayer.prevPosY = this.mc.thePlayer.posY;
            this.mc.thePlayer.prevPosZ = this.mc.thePlayer.posZ;
            this.field_1210_g = true;
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    public void handlePreChunk(Packet50PreChunk par1Packet50PreChunk) {
        this.worldClient.doPreChunk(par1Packet50PreChunk.xPosition, par1Packet50PreChunk.yPosition, par1Packet50PreChunk.mode);
    }

    @Override
    public void handleMultiBlockChange(Packet52MultiBlockChange par1Packet52MultiBlockChange) {
        int i = par1Packet52MultiBlockChange.xPosition * 16;
        int j = par1Packet52MultiBlockChange.zPosition * 16;
        if (par1Packet52MultiBlockChange.metadataArray != null) {
            DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(par1Packet52MultiBlockChange.metadataArray));
            try {
                for (int k = 0; k < par1Packet52MultiBlockChange.size; ++k) {
                    short word0 = datainputstream.readShort();
                    short word1 = datainputstream.readShort();
                    int l = (word1 & 0xFFF) >> 4;
                    int i1 = word1 & 0xF;
                    int j1 = word0 >> 12 & 0xF;
                    int k1 = word0 >> 8 & 0xF;
                    int l1 = word0 & 0xFF;
                    this.worldClient.setBlockAndMetadataAndInvalidate(j1 + i, l1, k1 + j, l, i1);
                }
            }
            catch (IOException ioexception) {
                // empty catch block
            }
        }
    }

    @Override
    public void func_48487_a(Packet51MapChunk par1Packet51MapChunk) {
        this.worldClient.invalidateBlockReceiveRegion(par1Packet51MapChunk.xCh << 4, 0, par1Packet51MapChunk.zCh << 4, (par1Packet51MapChunk.xCh << 4) + 15, 256, (par1Packet51MapChunk.zCh << 4) + 15);
        Chunk chunk = this.worldClient.getChunkFromChunkCoords(par1Packet51MapChunk.xCh, par1Packet51MapChunk.zCh);
        if (par1Packet51MapChunk.includeInitialize && chunk == null) {
            this.worldClient.doPreChunk(par1Packet51MapChunk.xCh, par1Packet51MapChunk.zCh, true);
            chunk = this.worldClient.getChunkFromChunkCoords(par1Packet51MapChunk.xCh, par1Packet51MapChunk.zCh);
        }
        if (chunk != null) {
            chunk.func_48494_a(par1Packet51MapChunk.chunkData, par1Packet51MapChunk.yChMin, par1Packet51MapChunk.yChMax, par1Packet51MapChunk.includeInitialize);
            this.worldClient.markBlocksDirty(par1Packet51MapChunk.xCh << 4, 0, par1Packet51MapChunk.zCh << 4, (par1Packet51MapChunk.xCh << 4) + 15, 256, (par1Packet51MapChunk.zCh << 4) + 15);
            if (!par1Packet51MapChunk.includeInitialize || !(this.worldClient.worldProvider instanceof WorldProviderSurface)) {
                chunk.resetRelightChecks();
            }
        }
    }

    @Override
    public void handleBlockChange(Packet53BlockChange par1Packet53BlockChange) {
        this.worldClient.setBlockAndMetadataAndInvalidate(par1Packet53BlockChange.xPosition, par1Packet53BlockChange.yPosition, par1Packet53BlockChange.zPosition, par1Packet53BlockChange.type, par1Packet53BlockChange.metadata);
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect par1Packet255KickDisconnect) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        ModLoader.serverDisconnect();
        this.mc.changeWorld1(null);
        this.mc.displayGuiScreen(new GuiDisconnected("disconnect.disconnected", "disconnect.genericReason", new Object[]{par1Packet255KickDisconnect.reason}));
    }

    @Override
    public void handleErrorMessage(String par1Str, Object[] par2ArrayOfObj) {
        if (!this.disconnected) {
            this.disconnected = true;
            ModLoader.serverDisconnect();
            this.mc.changeWorld1(null);
            this.mc.displayGuiScreen(new GuiDisconnected("disconnect.lost", par1Str, par2ArrayOfObj));
        }
    }

    public void quitWithPacket(Packet par1Packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(par1Packet);
            this.netManager.serverShutdown();
        }
    }

    public void addToSendQueue(Packet par1Packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(par1Packet);
        }
    }

    @Override
    public void handleCollect(Packet22Collect par1Packet22Collect) {
        Entity entity = this.getEntityByID(par1Packet22Collect.collectedEntityId);
        EntityLiving obj = (EntityLiving)this.getEntityByID(par1Packet22Collect.collectorEntityId);
        if (obj == null) {
            obj = this.mc.thePlayer;
        }
        if (entity != null) {
            if (entity instanceof EntityXPOrb) {
                this.worldClient.playSoundAtEntity(entity, "random.orb", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            } else {
                this.worldClient.playSoundAtEntity(entity, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, entity, obj, -0.5f));
            this.worldClient.removeEntityFromWorld(par1Packet22Collect.collectedEntityId);
        }
    }

    @Override
    public void handleChat(Packet3Chat par1Packet3Chat) {
        this.mc.ingameGUI.addChatMessage(par1Packet3Chat.message);
        ModLoader.serverChat(par1Packet3Chat.message);
    }

    @Override
    public void handleAnimation(Packet18Animation par1Packet18Animation) {
        Entity entity = this.getEntityByID(par1Packet18Animation.entityId);
        if (entity != null) {
            if (par1Packet18Animation.animate == 1) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.swingItem();
            } else if (par1Packet18Animation.animate == 2) {
                entity.performHurtAnimation();
            } else if (par1Packet18Animation.animate == 3) {
                EntityPlayer entityplayer1 = (EntityPlayer)entity;
                entityplayer1.wakeUpPlayer(false, false, false);
            } else if (par1Packet18Animation.animate == 4) {
                EntityPlayer entityplayer2 = (EntityPlayer)entity;
                entityplayer2.func_6420_o();
            } else if (par1Packet18Animation.animate == 6) {
                this.mc.effectRenderer.addEffect(new EntityCrit2FX(this.mc.theWorld, entity));
            } else if (par1Packet18Animation.animate == 7) {
                EntityCrit2FX entitycrit2fx = new EntityCrit2FX(this.mc.theWorld, entity, "magicCrit");
                this.mc.effectRenderer.addEffect(entitycrit2fx);
            } else if (par1Packet18Animation.animate != 5 || !(entity instanceof EntityOtherPlayerMP)) {
                // empty if block
            }
        }
    }

    @Override
    public void handleSleep(Packet17Sleep par1Packet17Sleep) {
        Entity entity = this.getEntityByID(par1Packet17Sleep.entityID);
        if (entity != null && par1Packet17Sleep.field_22046_e == 0) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.sleepInBedAt(par1Packet17Sleep.bedX, par1Packet17Sleep.bedY, par1Packet17Sleep.bedZ);
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake par1Packet2Handshake) {
        boolean flag = true;
        String s = par1Packet2Handshake.username;
        if (s != null && s.trim().length() != 0) {
            if (!s.equals("-")) {
                try {
                    Long.parseLong(s, 16);
                }
                catch (NumberFormatException numberformatexception) {
                    flag = false;
                }
            }
        } else {
            flag = false;
        }
        if (!flag) {
            this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"The server responded with an invalid server key"});
        } else if (par1Packet2Handshake.username.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.session.username, 29));
        } else {
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + par1Packet2Handshake.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s1 = bufferedreader.readLine();
                bufferedreader.close();
                if (s1.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.session.username, 29));
                } else {
                    this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s1});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + exception.toString()});
            }
        }
    }

    public void disconnect() {
        this.disconnected = true;
        ModLoader.serverDisconnect();
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(Packet24MobSpawn par1Packet24MobSpawn) {
        double d = (double)par1Packet24MobSpawn.xPosition / 32.0;
        double d1 = (double)par1Packet24MobSpawn.yPosition / 32.0;
        double d2 = (double)par1Packet24MobSpawn.zPosition / 32.0;
        float f = (float)(par1Packet24MobSpawn.yaw * 360) / 256.0f;
        float f1 = (float)(par1Packet24MobSpawn.pitch * 360) / 256.0f;
        EntityLiving entityliving = (EntityLiving)EntityList.createEntityByID(par1Packet24MobSpawn.type, this.mc.theWorld);
        entityliving.serverPosX = par1Packet24MobSpawn.xPosition;
        entityliving.serverPosY = par1Packet24MobSpawn.yPosition;
        entityliving.serverPosZ = par1Packet24MobSpawn.zPosition;
        entityliving.rotationYawHead = (float)(par1Packet24MobSpawn.field_48169_h * 360) / 256.0f;
        Entity[] aentity = entityliving.getParts();
        if (aentity != null) {
            int i = par1Packet24MobSpawn.entityId - entityliving.entityId;
            for (int j = 0; j < aentity.length; ++j) {
                aentity[j].entityId += i;
            }
        }
        entityliving.entityId = par1Packet24MobSpawn.entityId;
        entityliving.setPositionAndRotation(d, d1, d2, f, f1);
        this.worldClient.addEntityToWorld(par1Packet24MobSpawn.entityId, entityliving);
        List list = par1Packet24MobSpawn.getMetadata();
        if (list != null) {
            entityliving.getDataWatcher().updateWatchedObjectsFromList(list);
        }
    }

    @Override
    public void handleUpdateTime(Packet4UpdateTime par1Packet4UpdateTime) {
        this.mc.theWorld.setWorldTime(par1Packet4UpdateTime.time);
    }

    @Override
    public void handleSpawnPosition(Packet6SpawnPosition par1Packet6SpawnPosition) {
        this.mc.thePlayer.setSpawnChunk(new ChunkCoordinates(par1Packet6SpawnPosition.xPosition, par1Packet6SpawnPosition.yPosition, par1Packet6SpawnPosition.zPosition));
        this.mc.theWorld.getWorldInfo().setSpawnPosition(par1Packet6SpawnPosition.xPosition, par1Packet6SpawnPosition.yPosition, par1Packet6SpawnPosition.zPosition);
    }

    @Override
    public void handleAttachEntity(Packet39AttachEntity par1Packet39AttachEntity) {
        Entity obj = this.getEntityByID(par1Packet39AttachEntity.entityId);
        Entity entity = this.getEntityByID(par1Packet39AttachEntity.vehicleEntityId);
        if (par1Packet39AttachEntity.entityId == this.mc.thePlayer.entityId) {
            obj = this.mc.thePlayer;
        }
        if (obj != null) {
            obj.mountEntity(entity);
        }
    }

    @Override
    public void handleEntityStatus(Packet38EntityStatus par1Packet38EntityStatus) {
        Entity entity = this.getEntityByID(par1Packet38EntityStatus.entityId);
        if (entity != null) {
            entity.handleHealthUpdate(par1Packet38EntityStatus.entityStatus);
        }
    }

    private Entity getEntityByID(int par1) {
        return par1 != this.mc.thePlayer.entityId ? this.worldClient.getEntityByID(par1) : this.mc.thePlayer;
    }

    @Override
    public void handleUpdateHealth(Packet8UpdateHealth par1Packet8UpdateHealth) {
        this.mc.thePlayer.setHealth(par1Packet8UpdateHealth.healthMP);
        this.mc.thePlayer.getFoodStats().setFoodLevel(par1Packet8UpdateHealth.food);
        this.mc.thePlayer.getFoodStats().setFoodSaturationLevel(par1Packet8UpdateHealth.foodSaturation);
    }

    @Override
    public void handleExperience(Packet43Experience par1Packet43Experience) {
        this.mc.thePlayer.setXPStats(par1Packet43Experience.experience, par1Packet43Experience.experienceTotal, par1Packet43Experience.experienceLevel);
    }

    @Override
    public void handleRespawn(Packet9Respawn par1Packet9Respawn) {
        if (par1Packet9Respawn.respawnDimension != this.mc.thePlayer.dimension) {
            this.field_1210_g = false;
            this.worldClient = new WorldClient(this, new WorldSettings(0L, par1Packet9Respawn.creativeMode, false, false, par1Packet9Respawn.terrainType), par1Packet9Respawn.respawnDimension, par1Packet9Respawn.difficulty);
            this.worldClient.isRemote = true;
            this.mc.changeWorld1(this.worldClient);
            this.mc.thePlayer.dimension = par1Packet9Respawn.respawnDimension;
            this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        }
        this.mc.respawn(true, par1Packet9Respawn.respawnDimension, false);
        ((PlayerControllerMP)this.mc.playerController).setCreative(par1Packet9Respawn.creativeMode == 1);
    }

    @Override
    public void handleExplosion(Packet60Explosion par1Packet60Explosion) {
        Explosion explosion = new Explosion(this.mc.theWorld, null, par1Packet60Explosion.explosionX, par1Packet60Explosion.explosionY, par1Packet60Explosion.explosionZ, par1Packet60Explosion.explosionSize);
        explosion.destroyedBlockPositions = par1Packet60Explosion.destroyedBlockPositions;
        explosion.doExplosionB(true);
    }

    @Override
    public void handleOpenWindow(Packet100OpenWindow par1Packet100OpenWindow) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        switch (par1Packet100OpenWindow.inventoryType) {
            case 0: {
                entityplayersp.displayGUIChest(new InventoryBasic(par1Packet100OpenWindow.windowTitle, par1Packet100OpenWindow.slotsCount));
                entityplayersp.craftingInventory.windowId = par1Packet100OpenWindow.windowId;
                break;
            }
            case 1: {
                entityplayersp.displayWorkbenchGUI(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
                entityplayersp.craftingInventory.windowId = par1Packet100OpenWindow.windowId;
                break;
            }
            case 2: {
                entityplayersp.displayGUIFurnace(new TileEntityFurnace());
                entityplayersp.craftingInventory.windowId = par1Packet100OpenWindow.windowId;
                break;
            }
            case 3: {
                entityplayersp.displayGUIDispenser(new TileEntityDispenser());
                entityplayersp.craftingInventory.windowId = par1Packet100OpenWindow.windowId;
                break;
            }
            case 4: {
                entityplayersp.displayGUIEnchantment(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
                entityplayersp.craftingInventory.windowId = par1Packet100OpenWindow.windowId;
                break;
            }
            case 5: {
                entityplayersp.displayGUIBrewingStand(new TileEntityBrewingStand());
                entityplayersp.craftingInventory.windowId = par1Packet100OpenWindow.windowId;
            }
        }
    }

    @Override
    public void handleSetSlot(Packet103SetSlot par1Packet103SetSlot) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        if (par1Packet103SetSlot.windowId == -1) {
            entityplayersp.inventory.setItemStack(par1Packet103SetSlot.myItemStack);
        } else if (par1Packet103SetSlot.windowId == 0 && par1Packet103SetSlot.itemSlot >= 36 && par1Packet103SetSlot.itemSlot < 45) {
            ItemStack itemstack = entityplayersp.inventorySlots.getSlot(par1Packet103SetSlot.itemSlot).getStack();
            if (par1Packet103SetSlot.myItemStack != null && (itemstack == null || itemstack.stackSize < par1Packet103SetSlot.myItemStack.stackSize)) {
                par1Packet103SetSlot.myItemStack.animationsToGo = 5;
            }
            entityplayersp.inventorySlots.putStackInSlot(par1Packet103SetSlot.itemSlot, par1Packet103SetSlot.myItemStack);
        } else if (par1Packet103SetSlot.windowId == entityplayersp.craftingInventory.windowId) {
            entityplayersp.craftingInventory.putStackInSlot(par1Packet103SetSlot.itemSlot, par1Packet103SetSlot.myItemStack);
        }
    }

    @Override
    public void handleTransaction(Packet106Transaction par1Packet106Transaction) {
        Container container = null;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        if (par1Packet106Transaction.windowId == 0) {
            container = entityplayersp.inventorySlots;
        } else if (par1Packet106Transaction.windowId == entityplayersp.craftingInventory.windowId) {
            container = entityplayersp.craftingInventory;
        }
        if (container != null) {
            if (par1Packet106Transaction.accepted) {
                container.func_20113_a(par1Packet106Transaction.shortWindowId);
            } else {
                container.func_20110_b(par1Packet106Transaction.shortWindowId);
                this.addToSendQueue(new Packet106Transaction(par1Packet106Transaction.windowId, par1Packet106Transaction.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleWindowItems(Packet104WindowItems par1Packet104WindowItems) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        if (par1Packet104WindowItems.windowId == 0) {
            entityplayersp.inventorySlots.putStacksInSlots(par1Packet104WindowItems.itemStack);
        } else if (par1Packet104WindowItems.windowId == entityplayersp.craftingInventory.windowId) {
            entityplayersp.craftingInventory.putStacksInSlots(par1Packet104WindowItems.itemStack);
        }
    }

    @Override
    public void handleUpdateSign(Packet130UpdateSign par1Packet130UpdateSign) {
        TileEntitySign tileentitysign;
        TileEntity tileentity;
        if (this.mc.theWorld.blockExists(par1Packet130UpdateSign.xPosition, par1Packet130UpdateSign.yPosition, par1Packet130UpdateSign.zPosition) && (tileentity = this.mc.theWorld.getBlockTileEntity(par1Packet130UpdateSign.xPosition, par1Packet130UpdateSign.yPosition, par1Packet130UpdateSign.zPosition)) instanceof TileEntitySign && (tileentitysign = (TileEntitySign)tileentity).isEditable()) {
            for (int i = 0; i < 4; ++i) {
                tileentitysign.signText[i] = par1Packet130UpdateSign.signLines[i];
            }
            tileentitysign.onInventoryChanged();
        }
    }

    @Override
    public void handleTileEntityData(Packet132TileEntityData par1Packet132TileEntityData) {
        TileEntity tileentity;
        if (this.mc.theWorld.blockExists(par1Packet132TileEntityData.xPosition, par1Packet132TileEntityData.yPosition, par1Packet132TileEntityData.zPosition) && (tileentity = this.mc.theWorld.getBlockTileEntity(par1Packet132TileEntityData.xPosition, par1Packet132TileEntityData.yPosition, par1Packet132TileEntityData.zPosition)) != null && par1Packet132TileEntityData.actionType == 1 && tileentity instanceof TileEntityMobSpawner) {
            ((TileEntityMobSpawner)tileentity).setMobID(EntityList.getStringFromID(par1Packet132TileEntityData.customParam1));
        }
    }

    @Override
    public void handleUpdateProgressbar(Packet105UpdateProgressbar par1Packet105UpdateProgressbar) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        this.registerPacket(par1Packet105UpdateProgressbar);
        if (entityplayersp.craftingInventory != null && entityplayersp.craftingInventory.windowId == par1Packet105UpdateProgressbar.windowId) {
            entityplayersp.craftingInventory.updateProgressBar(par1Packet105UpdateProgressbar.progressBar, par1Packet105UpdateProgressbar.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(Packet5PlayerInventory par1Packet5PlayerInventory) {
        Entity entity = this.getEntityByID(par1Packet5PlayerInventory.entityID);
        if (entity != null) {
            entity.outfitWithItem(par1Packet5PlayerInventory.slot, par1Packet5PlayerInventory.itemID, par1Packet5PlayerInventory.itemDamage);
        }
    }

    @Override
    public void handleCloseWindow(Packet101CloseWindow par1Packet101CloseWindow) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handlePlayNoteBlock(Packet54PlayNoteBlock par1Packet54PlayNoteBlock) {
        this.mc.theWorld.playNoteAt(par1Packet54PlayNoteBlock.xLocation, par1Packet54PlayNoteBlock.yLocation, par1Packet54PlayNoteBlock.zLocation, par1Packet54PlayNoteBlock.instrumentType, par1Packet54PlayNoteBlock.pitch);
    }

    @Override
    public void handleBed(Packet70Bed par1Packet70Bed) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        int i = par1Packet70Bed.bedState;
        if (i >= 0 && i < Packet70Bed.bedChat.length && Packet70Bed.bedChat[i] != null) {
            entityplayersp.addChatMessage(Packet70Bed.bedChat[i]);
        }
        if (i == 1) {
            this.worldClient.getWorldInfo().setRaining(true);
            this.worldClient.setRainStrength(1.0f);
        } else if (i == 2) {
            this.worldClient.getWorldInfo().setRaining(false);
            this.worldClient.setRainStrength(0.0f);
        } else if (i == 3) {
            ((PlayerControllerMP)this.mc.playerController).setCreative(par1Packet70Bed.gameMode == 1);
        } else if (i == 4) {
            this.mc.displayGuiScreen(new GuiWinGame());
        }
    }

    @Override
    public void handleMapData(Packet131MapData par1Packet131MapData) {
        if (par1Packet131MapData.itemID == Item.map.shiftedIndex) {
            ItemMap.getMPMapData(par1Packet131MapData.uniqueID, this.mc.theWorld).func_28171_a(par1Packet131MapData.itemData);
        } else {
            System.out.println("Unknown itemid: " + par1Packet131MapData.uniqueID);
        }
    }

    @Override
    public void handleDoorChange(Packet61DoorChange par1Packet61DoorChange) {
        this.mc.theWorld.playAuxSFX(par1Packet61DoorChange.sfxID, par1Packet61DoorChange.posX, par1Packet61DoorChange.posY, par1Packet61DoorChange.posZ, par1Packet61DoorChange.auxData);
    }

    @Override
    public void handleStatistic(Packet200Statistic par1Packet200Statistic) {
        ((EntityClientPlayerMP)this.mc.thePlayer).incrementStat(StatList.getOneShotStat(par1Packet200Statistic.statisticId), par1Packet200Statistic.amount);
    }

    @Override
    public void handleEntityEffect(Packet41EntityEffect par1Packet41EntityEffect) {
        Entity entity = this.getEntityByID(par1Packet41EntityEffect.entityId);
        if (entity != null && entity instanceof EntityLiving) {
            ((EntityLiving)entity).addPotionEffect(new PotionEffect(par1Packet41EntityEffect.effectId, par1Packet41EntityEffect.duration, par1Packet41EntityEffect.effectAmplifier));
        }
    }

    @Override
    public void handleRemoveEntityEffect(Packet42RemoveEntityEffect par1Packet42RemoveEntityEffect) {
        Entity entity = this.getEntityByID(par1Packet42RemoveEntityEffect.entityId);
        if (entity != null && entity instanceof EntityLiving) {
            ((EntityLiving)entity).removePotionEffect(par1Packet42RemoveEntityEffect.effectId);
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handlePlayerInfo(Packet201PlayerInfo par1Packet201PlayerInfo) {
        GuiPlayerInfo guiplayerinfo = (GuiPlayerInfo)this.playerInfoMap.get(par1Packet201PlayerInfo.playerName);
        if (guiplayerinfo == null && par1Packet201PlayerInfo.isConnected) {
            guiplayerinfo = new GuiPlayerInfo(par1Packet201PlayerInfo.playerName);
            this.playerInfoMap.put(par1Packet201PlayerInfo.playerName, guiplayerinfo);
            this.playerNames.add(guiplayerinfo);
        }
        if (guiplayerinfo != null && !par1Packet201PlayerInfo.isConnected) {
            this.playerInfoMap.remove(par1Packet201PlayerInfo.playerName);
            this.playerNames.remove(guiplayerinfo);
        }
        if (par1Packet201PlayerInfo.isConnected && guiplayerinfo != null) {
            guiplayerinfo.responseTime = par1Packet201PlayerInfo.ping;
        }
    }

    @Override
    public void handleKeepAlive(Packet0KeepAlive par1Packet0KeepAlive) {
        this.addToSendQueue(new Packet0KeepAlive(par1Packet0KeepAlive.randomId));
    }

    @Override
    public void handlePlayerAbilities(Packet202PlayerAbilities par1Packet202PlayerAbilities) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        entityplayersp.capabilities.isFlying = par1Packet202PlayerAbilities.isFlying;
        entityplayersp.capabilities.isCreativeMode = par1Packet202PlayerAbilities.isCreativeMode;
        entityplayersp.capabilities.disableDamage = par1Packet202PlayerAbilities.disableDamage;
        entityplayersp.capabilities.allowFlying = par1Packet202PlayerAbilities.allowFlying;
    }

    @Override
    public void handleCustomPayload(Packet250CustomPayload packet250custompayload) {
        ModLoader.receivePacket(packet250custompayload);
    }
}

