/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordD;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_EntityLaserParticleFX;
import net.minecraft.src.PC_IBeamHandler;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;

public abstract class PC_BeamTracerBase {
    private Random rand = new Random();
    private PC_CoordI startCoord;
    private PC_CoordI startMove;
    private PC_Color origColor;
    private PC_IBeamHandler handler;
    protected World world;
    private boolean canChangeColor = false;
    private boolean particlesBidi = false;
    private boolean canHitEntity = false;
    private int particle_count = 2;
    private static final int particles_range = 20;
    private int maxTotalLength = 8000;
    private int crystal_add = 40;
    private int start_limit = 40;
    private int maximum_current_limit = 80;
    private int totalLength = 0;

    public PC_BeamTracerBase(World worldObj, PC_IBeamHandler handler) {
        this.handler = handler;
        this.world = worldObj;
    }

    public PC_BeamTracerBase setCanChangeColor(boolean state) {
        this.canChangeColor = state;
        return this;
    }

    public PC_BeamTracerBase setStartLength(int length) {
        this.start_limit = length;
        return this;
    }

    public PC_BeamTracerBase setMaxLengthAfterCrystal(int length) {
        this.maximum_current_limit = length;
        return this;
    }

    public PC_BeamTracerBase setCrystalAddedLength(int length) {
        this.crystal_add = length;
        return this;
    }

    public PC_BeamTracerBase setTotalLengthLimit(int length) {
        this.maxTotalLength = length;
        return this;
    }

    public PC_BeamTracerBase setParticleCount(int particles) {
        this.particle_count = particles;
        return this;
    }

    public PC_BeamTracerBase setStartCoord(int x, int y, int z) {
        this.startCoord = new PC_CoordI(x, y, z);
        return this;
    }

    public PC_BeamTracerBase setStartCoord(PC_CoordI coord) {
        this.startCoord = coord.copy();
        return this;
    }

    public PC_BeamTracerBase setStartMove(int x, int y, int z) {
        this.startMove = new PC_CoordI(x, y, z);
        return this;
    }

    public PC_BeamTracerBase setStartMove(PC_CoordI coord) {
        this.startMove = coord.copy();
        return this;
    }

    public PC_BeamTracerBase setColor(PC_Color color) {
        this.origColor = color.copy();
        return this;
    }

    public PC_BeamTracerBase setColor(double r, double g, double b, int meta) {
        this.origColor = new PC_Color(r, g, b);
        this.origColor.setMeta(meta);
        return this;
    }

    public PC_BeamTracerBase setParticlesBidirectional(boolean bidi) {
        this.particlesBidi = bidi;
        return this;
    }

    public PC_BeamTracerBase setDetectEntities(boolean state) {
        this.canHitEntity = state;
        return this;
    }

    public void flash() {
        this.totalLength = 0;
        this.forkBeam(this.startCoord, this.startMove, this.origColor, this.start_limit);
    }

    protected void forkBeam(PC_CoordI par_cnt, PC_CoordI par_move, PC_Color par_color, int limit) {
        PC_CoordI cnt = par_cnt.copy();
        PC_CoordI move = par_move.copy();
        PC_Color color = par_color.copy();
        boolean chdir = false;
        PC_CoordI moveOld = move.copy();
        for (int c = 0; c < limit && ++this.totalLength <= this.maxTotalLength; ++c) {
            List hitList;
            chdir = false;
            cnt.add(move);
            int id = cnt.getId(this.world);
            int meta = cnt.getMeta(this.world);
            if (id == mod_PCcore.powerCrystal.blockID) {
                if (this.canChangeColor) {
                    color.setTo(PC_Color.crystal_colors[meta]);
                    color.setMeta(meta);
                }
                if ((limit += this.crystal_add) > this.maximum_current_limit) {
                    limit = this.maximum_current_limit;
                }
            } else {
                result res = this.onBlockHit(cnt, move, moveOld, color, limit - c);
                if (res == result.FALLBACK) {
                    boolean stop = this.handler.onBlockHit(this.world, cnt, this.startCoord);
                    if (stop) {
                        return;
                    }
                } else if (res != result.CONTINUE) {
                    if (res == result.CONTINUE_DIR_CHANGE) {
                        chdir = true;
                    } else if (res == result.STOP) {
                        return;
                    }
                }
            }
            if (color.isVisible() && this.shouldSpawnParticle(cnt)) {
                for (int f = 0; f < this.particle_count; ++f) {
                    if (!chdir) {
                        this.spawnParticles(cnt, move, 0, color);
                        continue;
                    }
                    this.spawnParticles(cnt, moveOld, 1, color);
                    this.spawnParticles(cnt, move, 2, color);
                }
            }
            if (!this.canHitEntity || (hitList = this.world.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBoxFromPool(cnt.x, cnt.y, cnt.z, cnt.x + 1, cnt.y + 1, cnt.z + 1))).size() <= 0 || !this.handler.onEntityHit(this.world, hitList.toArray(new Entity[hitList.size()]), this.startCoord)) continue;
            return;
        }
    }

    private boolean shouldSpawnParticle(PC_CoordI coord) {
        return this.world.getClosestPlayer((double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5, 20.0) != null;
    }

    protected void spawnParticles(PC_CoordI cnt, PC_CoordI move, int half, PC_Color color) {
        if (!color.isVisible()) {
            return;
        }
        double shift = 0.0;
        if (half == 0) {
            shift = -0.5 + (double)this.rand.nextFloat() * 1.0;
        }
        if (half == 1) {
            shift = (double)(-this.rand.nextFloat()) * 0.5;
        }
        if (half == 2) {
            shift = (double)this.rand.nextFloat() * 0.5;
        }
        PC_CoordD particle = cnt.offset(0.5, 0.5, 0.5);
        if (move.x > 0) {
            particle.x += shift;
        }
        if (move.y > 0) {
            particle.y += shift;
        }
        if (move.z > 0) {
            particle.z += shift;
        }
        if (move.x < 0) {
            particle.x -= shift;
        }
        if (move.y < 0) {
            particle.y -= shift;
        }
        if (move.z < 0) {
            particle.z -= shift;
        }
        if (this.particlesBidi && this.rand.nextBoolean()) {
            ModLoader.getMinecraftInstance().effectRenderer.addEffect(new PC_EntityLaserParticleFX(this.world, particle, color, move.getInverted(), half));
        } else {
            ModLoader.getMinecraftInstance().effectRenderer.addEffect(new PC_EntityLaserParticleFX(this.world, particle, color, move, half));
        }
    }

    public abstract result onBlockHit(PC_CoordI var1, PC_CoordI var2, PC_CoordI var3, PC_Color var4, int var5);

    protected static enum result {
        FALLBACK,
        CONTINUE,
        CONTINUE_DIR_CHANGE,
        STOP;

    }
}

