/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_INBT;

public class PC_Color
implements PC_INBT {
    public double r;
    public double g;
    public double b;
    private int powerCrystalMeta = -1;
    private boolean invisible = false;
    public static final int[] crystal_colors = new int[]{0xFF9900, 0xFF1111, 3800849, 0x5555FF, 0xCCCCFF, 0xFF33FF, 0x33FFFF, 0xFFFF00};
    public static final int[] light_colors = new int[]{0x333333, 0xFF0000, 39168, 0x553300, 0x3333FF, 0x9900FF, 65535, 0x666666, 0x434343, 15237544, 4325172, 0xFFFF00, 0x6666FF, 0xFF0099, 0xFF9900, 0xF0F0F0};

    public PC_Color(double r, double g, double b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public PC_Color(int hex) {
        this.r = PC_Color.red(hex);
        this.g = PC_Color.green(hex);
        this.b = PC_Color.blue(hex);
    }

    public PC_Color(PC_Color source) {
        this.r = source.r;
        this.g = source.g;
        this.b = source.b;
    }

    public PC_Color() {
        this.b = 1.0;
        this.g = 1.0;
        this.r = 1.0;
    }

    public int getHex() {
        int r255 = (int)Math.round(this.r * 255.0);
        int g255 = (int)Math.round(this.g * 255.0);
        int b255 = (int)Math.round(this.b * 255.0);
        return r255 << 16 | g255 << 8 | b255;
    }

    public int getMeta() {
        return this.powerCrystalMeta;
    }

    public PC_Color setMeta(int meta) {
        this.powerCrystalMeta = meta;
        return this;
    }

    public PC_Color setVisible(boolean visibility) {
        this.invisible = !visibility;
        return this;
    }

    public boolean isVisible() {
        return !this.invisible;
    }

    public PC_Color mixWith(PC_Color color) {
        return new PC_Color((this.r + color.r) / 2.0, (this.g + color.g) / 2.0, (this.b + color.b) / 2.0);
    }

    public PC_Color mixWith(double cr, double cg, double cb) {
        return new PC_Color((this.r + cr) / 2.0, (this.g + cg) / 2.0, (this.b + cb) / 2.0);
    }

    public static PC_Color valueOf(int hex) {
        return new PC_Color(PC_Color.red(hex), PC_Color.green(hex), PC_Color.blue(hex));
    }

    public PC_Color copy() {
        return new PC_Color(this.r, this.g, this.b);
    }

    public void setTo(int hex) {
        this.r = PC_Color.red(hex);
        this.g = PC_Color.green(hex);
        this.b = PC_Color.blue(hex);
    }

    public void setTo(double cr, double cg, double cb) {
        this.r = cr;
        this.g = cg;
        this.b = cb;
    }

    public static double red(int hex) {
        return 0.00392156862745098 * (double)((hex & 0xFF0000) >> 16);
    }

    public static double green(int hex) {
        return 0.00392156862745098 * (double)((hex & 0xFF00) >> 8);
    }

    public static double blue(int hex) {
        return 0.00392156862745098 * (double)(hex & 0xFF);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.setDouble("r", this.r);
        tag.setDouble("g", this.g);
        tag.setDouble("b", this.b);
        tag.setInteger("xtal_meta", this.powerCrystalMeta);
        tag.setBoolean("invisible", this.invisible);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.r = tag.getDouble("r");
        this.g = tag.getDouble("g");
        this.b = tag.getDouble("b");
        this.powerCrystalMeta = tag.getInteger("xtal_meta");
        this.invisible = tag.getBoolean("invisible");
    }

    public static enum cloth {
        BLACK(15),
        RED(14),
        GREEN(13),
        BROWN(12),
        BLUE(11),
        PURPLE(10),
        CYAN(9),
        LIGHTGRAY(8),
        GRAY(7),
        PINK(6),
        LIME(5),
        YELLOW(4),
        LIGHTBLUE(3),
        MAGENTA(2),
        ORANGE(1),
        WHITE(0);

        public int meta;

        private cloth(int m) {
            this.meta = m;
        }
    }

    public static enum dye {
        BLACK(0),
        RED(1),
        GREEN(2),
        BROWN(3),
        BLUE(4),
        PURPLE(5),
        CYAN(6),
        LIGHTGRAY(7),
        GRAY(8),
        PINK(9),
        LIME(10),
        YELLOW(11),
        LIGHTBLUE(12),
        MAGENTA(13),
        ORANGE(14),
        WHITE(15);

        public int meta;

        private dye(int m) {
            this.meta = m;
        }
    }
}

