/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_CoordF;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_ICoord;
import net.minecraft.src.PC_INBT;

public class PC_CoordD
implements PC_ICoord,
PC_INBT {
    public double x;
    public double y;
    public double z;

    public String toString() {
        return "[" + this.x + ";" + this.y + ";" + this.z + "]";
    }

    public PC_CoordD() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public PC_CoordD(double a, double b, double c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordD(float a, float b, float c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordD(int a, int b, int c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordD(long a, long b, long c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordD(PC_CoordD c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public PC_CoordD(PC_CoordF c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public PC_CoordD(PC_CoordI c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public PC_CoordD copy() {
        return new PC_CoordD(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return ((PC_CoordD)obj).x == this.x && ((PC_CoordD)obj).y == this.y && ((PC_CoordD)obj).z == this.z;
    }

    public int hashCode() {
        return new Double(this.x + 17.0).hashCode() ^ new Double(this.y - 156.0).hashCode() ^ new Double(this.z).hashCode();
    }

    public PC_CoordD setTo(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PC_CoordD setTo(PC_CoordD src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        return this;
    }

    public PC_CoordD setTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PC_CoordD setTo(PC_CoordF src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        return this;
    }

    public PC_CoordD setTo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PC_CoordD setTo(PC_CoordI src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        return this;
    }

    public PC_CoordD setTo(long x, long y, long z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public PC_CoordD getInverted() {
        return new PC_CoordD(-this.x, -this.y, -this.z);
    }

    public boolean equalsXZ(PC_CoordD matched) {
        return this.x == matched.x && this.z == matched.z;
    }

    public PC_CoordD add(PC_CoordD added) {
        this.x += added.x;
        this.y += added.y;
        this.z += added.z;
        return this;
    }

    public PC_CoordD add(int x, int y, int z) {
        this.x += (double)x;
        this.y += (double)y;
        this.z += (double)z;
        return this;
    }

    public PC_CoordD add(int x, int y) {
        this.x += (double)x;
        this.y += (double)y;
        return this;
    }

    public PC_CoordD add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public PC_CoordD add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public PC_CoordD add(float x, float y, float z) {
        this.x += (double)x;
        this.y += (double)y;
        this.z += (double)z;
        return this;
    }

    public PC_CoordD add(float x, float y) {
        this.x += (double)x;
        this.y += (double)y;
        return this;
    }

    public PC_CoordD add(long x, long y, long z) {
        this.x += (double)x;
        this.y += (double)y;
        this.z += (double)z;
        return this;
    }

    public PC_CoordD add(long x, long y) {
        this.x += (double)x;
        this.y += (double)y;
        return this;
    }

    @Override
    public PC_CoordD offset(PC_CoordI added) {
        return new PC_CoordD(this.x + (double)added.x, this.y + (double)added.y, this.z + (double)added.z);
    }

    @Override
    public PC_CoordD offset(PC_CoordF added) {
        return new PC_CoordD(this.x + (double)added.x, this.y + (double)added.y, this.z + (double)added.z);
    }

    @Override
    public PC_CoordD offset(PC_CoordD added) {
        return new PC_CoordD(this.x + added.x, this.y + added.y, this.z + added.z);
    }

    @Override
    public PC_CoordD offset(int xm, int ym, int zm) {
        return new PC_CoordD(this.x + (double)xm, this.y + (double)ym, this.z + (double)zm);
    }

    @Override
    public PC_CoordD offset(float xm, float ym, float zm) {
        return new PC_CoordD(this.x + (double)xm, this.y + (double)ym, this.z + (double)zm);
    }

    @Override
    public PC_CoordD offset(double xm, double ym, double zm) {
        return new PC_CoordD(this.x + xm, this.y + ym, this.z + zm);
    }

    @Override
    public PC_CoordD offset(long xm, long ym, long zm) {
        return new PC_CoordD(this.x + (double)xm, this.y + (double)ym, this.z + (double)zm);
    }

    public PC_CoordD setX(double xx) {
        return new PC_CoordD(xx, this.y, this.z);
    }

    public PC_CoordD setY(double yy) {
        return new PC_CoordD(this.x, yy, this.z);
    }

    public PC_CoordD setZ(double zz) {
        return new PC_CoordD(this.x, this.y, zz);
    }

    public double distanceTo(PC_CoordD pos) {
        return Math.sqrt((this.x - pos.x) * (this.x - pos.x) + (this.y - pos.y) * (this.y - pos.y) + (this.z - pos.z) * (this.z - pos.z));
    }

    public PC_CoordD getVectorTo(PC_CoordD pos) {
        return new PC_CoordD(pos.x - this.x, pos.y - this.y, pos.z - this.z);
    }

    public static PC_CoordD getVector(PC_CoordD pos1, PC_CoordD pos2) {
        return new PC_CoordD(pos2.x - pos1.x, pos2.y - pos1.y, pos2.z - pos1.z);
    }

    @Override
    public PC_CoordI round() {
        return new PC_CoordI(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    @Override
    public PC_CoordI floor() {
        return new PC_CoordI(Math.round(Math.floor(this.x)), Math.round(Math.floor(this.y)), Math.round(Math.floor(this.z)));
    }

    @Override
    public PC_CoordI ceil() {
        return new PC_CoordI(Math.round(Math.ceil(this.x)), Math.round(Math.ceil(this.y)), Math.round(Math.ceil(this.z)));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.setDouble("dx", this.x);
        tag.setDouble("dy", this.y);
        tag.setDouble("dz", this.z);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.x = tag.getDouble("dx");
        this.y = tag.getDouble("dy");
        this.z = tag.getDouble("dz");
    }
}

