/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_CoordD;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_ICoord;
import net.minecraft.src.PC_INBT;

public class PC_CoordF
implements PC_ICoord,
PC_INBT {
    public float x;
    public float y;
    public float z;

    public String toString() {
        return "[" + this.x + ";" + this.y + ";" + this.z + "]";
    }

    public PC_CoordF() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public PC_CoordF(float a, float b, float c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordF(int a, int b, int c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordF(long a, long b, long c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordF(double a, double b, double c) {
        this.x = (float)a;
        this.y = (float)b;
        this.z = (float)c;
    }

    public PC_CoordF(PC_CoordF c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public PC_CoordF(PC_CoordI c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public PC_CoordF(PC_CoordD c) {
        this.x = (float)c.x;
        this.y = (float)c.y;
        this.z = (float)c.z;
    }

    public PC_CoordF copy() {
        return new PC_CoordF(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return ((PC_CoordF)obj).x == this.x && ((PC_CoordF)obj).y == this.y && ((PC_CoordF)obj).z == this.z;
    }

    public int hashCode() {
        return new Float(this.x + 17.0f).hashCode() ^ new Float(this.y - 156.0f).hashCode() ^ new Float(this.z).hashCode();
    }

    public PC_CoordF setTo(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    public PC_CoordF setTo(PC_CoordD src) {
        this.x = (float)src.x;
        this.y = (float)src.y;
        this.z = (float)src.z;
        return this;
    }

    public PC_CoordF setTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PC_CoordF setTo(PC_CoordF src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        return this;
    }

    public PC_CoordF setTo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PC_CoordF setTo(PC_CoordI src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        return this;
    }

    public PC_CoordF setTo(long x, long y, long z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public PC_CoordF getInverted() {
        return new PC_CoordF(-this.x, -this.y, -this.z);
    }

    public boolean equalsXZ(PC_CoordF matched) {
        return this.x == matched.x && this.z == matched.z;
    }

    public PC_CoordF add(PC_CoordF added) {
        this.x += added.x;
        this.y += added.y;
        this.z += added.z;
        return this;
    }

    public PC_CoordF add(int x, int y, int z) {
        this.x += (float)x;
        this.y += (float)y;
        this.z += (float)z;
        return this;
    }

    public PC_CoordF add(int x, int y) {
        this.x += (float)x;
        this.y += (float)y;
        return this;
    }

    public PC_CoordF add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public PC_CoordF add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public PC_CoordF add(double x, double y, double z) {
        this.x = (float)((double)this.x + x);
        this.y = (float)((double)this.y + y);
        this.z = (float)((double)this.z + z);
        return this;
    }

    public PC_CoordF add(double x, double y) {
        this.x = (float)((double)this.x + x);
        this.y = (float)((double)this.y + y);
        return this;
    }

    public PC_CoordF add(long x, long y, long z) {
        this.x += (float)x;
        this.y += (float)y;
        this.z += (float)z;
        return this;
    }

    public PC_CoordF add(long x, long y) {
        this.x += (float)x;
        this.y += (float)y;
        return this;
    }

    @Override
    public PC_CoordF offset(PC_CoordI added) {
        return new PC_CoordF(this.x + (float)added.x, this.y + (float)added.y, this.z + (float)added.z);
    }

    @Override
    public PC_CoordF offset(PC_CoordF added) {
        return new PC_CoordF(this.x + added.x, this.y + added.y, this.z + added.z);
    }

    @Override
    public PC_CoordF offset(PC_CoordD added) {
        return new PC_CoordF((double)this.x + added.x, (double)this.y + added.y, (double)this.z + added.z);
    }

    @Override
    public PC_CoordF offset(int xm, int ym, int zm) {
        return new PC_CoordF(this.x + (float)xm, this.y + (float)ym, this.z + (float)zm);
    }

    @Override
    public PC_CoordF offset(float xm, float ym, float zm) {
        return new PC_CoordF(this.x + xm, this.y + ym, this.z + zm);
    }

    @Override
    public PC_CoordF offset(double xm, double ym, double zm) {
        return new PC_CoordF((double)this.x + xm, (double)this.y + ym, (double)this.z + zm);
    }

    @Override
    public PC_CoordF offset(long xm, long ym, long zm) {
        return new PC_CoordF(this.x + (float)xm, this.y + (float)ym, this.z + (float)zm);
    }

    public PC_CoordF setX(float xx) {
        return new PC_CoordF(xx, this.y, this.z);
    }

    public PC_CoordF setY(float yy) {
        return new PC_CoordF(this.x, yy, this.z);
    }

    public PC_CoordF setZ(float zz) {
        return new PC_CoordF(this.x, this.y, zz);
    }

    public double distanceTo(PC_CoordF pos) {
        return Math.sqrt((this.x - pos.x) * (this.x - pos.x) + (this.y - pos.y) * (this.y - pos.y) + (this.z - pos.z) * (this.z - pos.z));
    }

    public PC_CoordD getVectorTo(PC_CoordF pos) {
        return new PC_CoordD(pos.x - this.x, pos.y - this.y, pos.z - this.z);
    }

    public static PC_CoordD getVector(PC_CoordF pos1, PC_CoordF pos2) {
        return new PC_CoordD(pos2.x - pos1.x, pos2.y - pos1.y, pos2.z - pos1.z);
    }

    @Override
    public PC_CoordI round() {
        return new PC_CoordI(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    @Override
    public PC_CoordI floor() {
        return new PC_CoordI(Math.round(Math.floor(this.x)), Math.round(Math.floor(this.y)), Math.round(Math.floor(this.z)));
    }

    @Override
    public PC_CoordI ceil() {
        return new PC_CoordI(Math.round(Math.ceil(this.x)), Math.round(Math.ceil(this.y)), Math.round(Math.ceil(this.z)));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.setFloat("fx", this.x);
        tag.setFloat("fy", this.y);
        tag.setFloat("fz", this.z);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.x = tag.getFloat("fx");
        this.y = tag.getFloat("fy");
        this.z = tag.getFloat("fz");
    }
}

