/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PC_CropHarvestingManager {
    private int new_id;
    private int new_meta_mature;
    private int new_meta_replant;
    private PC_CropEntry new_entry;
    private boolean new_started = false;
    private static final File folder = new File(Minecraft.getMinecraftDir() + "/PowerCraft" + "/crops");
    private static boolean cropsLoaded = false;
    private static Hashtable<Integer, PC_CropEntry> crops = new Hashtable();

    public void startCrop(int id, int meta_mature, int meta_replant) {
        if (this.new_started) {
            PC_Logger.severe("Crop manager - startCrop - Crop entry already started!");
        }
        this.new_id = id;
        this.new_meta_mature = meta_mature;
        this.new_meta_replant = meta_replant;
        this.new_started = true;
        this.new_entry = new PC_CropEntry();
        this.new_entry.setBlockInfo(this.new_id, this.new_meta_mature, this.new_meta_replant);
    }

    public void addDropItem(int id, int metaFrom, int metaTo, int countFrom, int countTo, int rarityNumenator, int rarityDenominator, int itemPriority) {
        if (!this.new_started) {
            PC_Logger.severe("Crop manager - addDropItem - Crop entry not started!");
            return;
        }
        this.new_entry.addDropItem(id, metaFrom, metaTo, countFrom, countTo, rarityNumenator, rarityDenominator, itemPriority);
    }

    public void saveCrop() {
        if (!this.new_started) {
            PC_Logger.severe("Crop manager - endCrop - Crop entry not started!");
        }
        crops.put(this.new_id, this.new_entry);
        this.new_started = false;
        this.new_entry = null;
    }

    public void cancelCrop() {
        if (!this.new_started) {
            PC_Logger.warning("Crop manager - cancelCrop - Crop entry not started!");
        }
        this.new_entry = null;
        this.new_started = false;
    }

    public static int getReplantMeta(int block_id) {
        PC_CropEntry entry = crops.get(block_id);
        if (entry == null) {
            return -1;
        }
        return entry.getReplantMetadata();
    }

    public static boolean isBlockRegisteredCrop(int block_id) {
        PC_CropEntry entry = crops.get(block_id);
        return entry != null;
    }

    public static boolean canHarvestBlock(int block_id, int block_meta) {
        PC_CropEntry entry = crops.get(block_id);
        if (entry == null) {
            return false;
        }
        return entry.canHarvestBlock(block_id, block_meta);
    }

    public static ItemStack[] getHarvestedStacks(int block_id, int block_meta) {
        PC_CropEntry entry = crops.get(block_id);
        if (entry == null) {
            return null;
        }
        if (!entry.canHarvestBlock(block_id, block_meta)) {
            return null;
        }
        return entry.getHarvestedStacks(block_id, block_meta);
    }

    public static void loadCrops() {
        String[] files;
        if (cropsLoaded) {
            return;
        }
        PC_Logger.finer("Loading XML configuration for crops.");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!new File(folder + "/" + "default.xml").exists()) {
            try {
                PC_Logger.finest("Generating default crops config in /PowerCraft/crops/default.xml");
                FileWriter out = new FileWriter(new File(folder + "/" + "default.xml"));
                out.write("<?xml version='1.1' encoding='UTF-8' ?>\n<!-- \n  BLOCK HARVESTER CONFIG FILE\n  You can add your own crops into this file.\n  Any other xml files in this folder will be parsed too.\n\n  If you make a setup file for some mod, please post it on forums.\n\n  Special values:\n    metaMature  = -1  ...  any metadata\n    metaReplant = -1  ...  do not replant\n\n    Item meta   <  0  ...  get item with meta = blockMeta & abs(THIS_NUMBER) - useful for leaves\n\n  Item meta can be ranged - use 4-7 for random meta in range 4 to 7 (inclusive).\n  You can also use range for item count (eg. 0-5). \n\n  Higher rarity number means more rare. Use 1 for regular drops. \n-->\n\n<crops>\n\n\t<crop name='Wheat'>\n\t\t<block id='59' metaMature='7' metaReplant='0' />\n\t\t<item id='296' meta='0' count='1' rarity='1' priority='1' /><!-- wheat -->\n\t\t<item id='295' meta='0' count='0-2' rarity='1' priority='1' /><!-- seeds -->\n\t</crop>\n\n\t<crop name='Nether Wart'>\n\t\t<block id='115' metaMature='3' metaReplant='0' />\n\t\t<item id='372' meta='0' count='2-5' rarity='1' priority='1' /><!-- wart seeds -->\n\t</crop>\n\n\t<crop name='Leaves'>\n\t\t<block id='18' metaMature='-1' metaReplant='-1' />\n\t\t<item id='260' meta='0'  count='1' rarity='1/200' priority='1' /><!-- apple -->\n\t\t<item id='6'   meta='-3' count='1' rarity='1/20'  priority='2' /><!-- sapling -->\n\t\t<item id='18'  meta='-3' count='1' rarity='1'   priority='3' /><!-- leaf -->\n\t</crop>\n\n</crops>");
                out.close();
            }
            catch (IOException e) {
                PC_Logger.severe("Generating default crops config file failed due to an IOException.");
                e.printStackTrace();
            }
        }
        for (String filename : files = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.matches("[^.]+[.]xml");
            }
        })) {
            PC_Logger.finest("* loading file " + filename + "...");
            File file = new File(folder + "/" + filename);
            PC_CropHarvestingManager.parseFile(file);
        }
        PC_Logger.finer("Crops configuration loaded.");
        cropsLoaded = true;
    }

    private static void parseFile(File file) {
        try {
            PC_CropHarvestingManager manager = new PC_CropHarvestingManager();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList cropsList = doc.getElementsByTagName("crop");
            block6: for (int i = 0; i < cropsList.getLength(); ++i) {
                Node cropNode = cropsList.item(i);
                if (cropNode.getNodeType() != 1) continue;
                Element crop = (Element)cropNode;
                NodeList blocks = crop.getElementsByTagName("block");
                if (blocks.getLength() != 1) {
                    PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - invalid no. of <block>s in one <crop>");
                    continue;
                }
                Element block = (Element)blocks.item(0);
                NodeList items = crop.getElementsByTagName("item");
                if (blocks.getLength() < 1) {
                    PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - no <item>s in <crop>");
                    continue;
                }
                int itemCount = items.getLength();
                String block_id_s = block.getAttribute("id");
                if (block_id_s.equals("") || !block_id_s.matches("[0-9]+")) {
                    PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad block ID");
                    continue;
                }
                int block_id = Integer.parseInt(block_id_s);
                String block_meta_replant_s = block.getAttribute("metaReplant");
                if (block_meta_replant_s.equals("") || !block_meta_replant_s.matches("[-]?[0-9]+")) {
                    PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad replant meta");
                    continue;
                }
                int meta_replant = Integer.parseInt(block_meta_replant_s);
                String block_meta_mature_s = block.getAttribute("metaMature");
                if (block_meta_mature_s.equals("") || !block_meta_mature_s.matches("[-]?[0-9]+")) {
                    PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad mature meta");
                    continue;
                }
                int meta_mature = Integer.parseInt(block_meta_mature_s);
                manager.startCrop(block_id, meta_mature, meta_replant);
                for (int j = 0; j < itemCount; ++j) {
                    try {
                        int itemCountA;
                        int itemCountB;
                        int itemMetaA;
                        int itemMetaB;
                        int itemRarityB;
                        int itemRarityA;
                        Element item = (Element)items.item(j);
                        String item_id_s = item.getAttribute("id");
                        if (item_id_s.equals("") || !item_id_s.matches("[0-9]+")) {
                            PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad item ID");
                            continue block6;
                        }
                        int itemId = Integer.parseInt(item_id_s);
                        String item_priority_s = item.getAttribute("priority");
                        if (item_id_s.equals("")) {
                            item_priority_s = "1";
                        } else if (!item_id_s.matches("[0-9]+")) {
                            PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad item ID");
                            continue block6;
                        }
                        int itemPriority = Integer.parseInt(item_priority_s);
                        String item_rarity_s = item.getAttribute("rarity");
                        if (item_rarity_s.equals("")) {
                            item_rarity_s = "1";
                        }
                        if (!item_rarity_s.matches("[0-9]+([/][0-9]+)?")) {
                            PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad item rarity");
                            continue block6;
                        }
                        String[] item_rarity_parts = item_rarity_s.split("/");
                        if (item_rarity_parts.length == 1) {
                            itemRarityA = 1;
                            itemRarityB = Integer.parseInt(item_rarity_parts[0]);
                        } else {
                            itemRarityA = Integer.parseInt(item_rarity_parts[0]);
                            if (itemRarityA > (itemRarityB = Integer.parseInt(item_rarity_parts[1]))) {
                                itemRarityB = 1;
                                itemRarityA = 1;
                            }
                        }
                        String item_meta_s = item.getAttribute("meta");
                        if (item_meta_s.equals("")) {
                            item_meta_s = "0";
                        } else if (!item_meta_s.matches("[-]?[0-9]+") && !item_meta_s.matches("[0-9]+[-][0-9]+")) {
                            PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad item meta");
                            continue block6;
                        }
                        String[] item_meta_parts = item_meta_s.matches("[-]?[0-9]+") ? new String[]{item_meta_s} : item_meta_s.split("-");
                        if (item_meta_parts.length == 1) {
                            itemMetaA = itemMetaB = Integer.parseInt(item_meta_parts[0]);
                        } else {
                            itemMetaA = Integer.parseInt(item_meta_parts[0]);
                            itemMetaB = Integer.parseInt(item_meta_parts[1]);
                            if (itemMetaB < itemMetaA) {
                                itemMetaB = itemMetaA;
                            }
                        }
                        String item_count_s = item.getAttribute("count");
                        if (item_count_s.equals("")) {
                            item_count_s = "1";
                        } else if (!item_count_s.matches("[0-9]+(-[0-9]+)?")) {
                            PC_Logger.warning("Crop manager - parseFile - Error while parsing " + file + " - bad item count");
                            continue block6;
                        }
                        String[] item_count_parts = item_count_s.split("-");
                        if (item_count_parts.length == 1) {
                            itemCountA = itemCountB = Integer.parseInt(item_count_parts[0]);
                        } else {
                            itemCountA = Integer.parseInt(item_count_parts[0]);
                            itemCountB = Integer.parseInt(item_count_parts[1]);
                            if (itemCountB < itemCountA) {
                                itemCountB = itemCountA;
                            }
                        }
                        manager.addDropItem(itemId, itemMetaA, itemMetaB, itemCountA, itemCountB, itemRarityA, itemRarityB, itemPriority);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                PC_Logger.finest("   - Loaded crop \"" + crop.getAttribute("name") + "\".");
                manager.saveCrop();
            }
        }
        catch (SAXParseException err) {
            PC_Logger.severe("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            PC_Logger.severe(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private class PC_CropEntry {
        private int blockID;
        private int metaReplant;
        private int metaMature;
        private ArrayList<Integer> itemId = new ArrayList();
        private ArrayList<Integer> metaStart = new ArrayList();
        private ArrayList<Integer> metaEnd = new ArrayList();
        private ArrayList<Integer> countStart = new ArrayList();
        private ArrayList<Integer> countEnd = new ArrayList();
        private ArrayList<Integer> rarityNum = new ArrayList();
        private ArrayList<Integer> rarityDenom = new ArrayList();
        private ArrayList<Integer> priority = new ArrayList();
        private int itemsCount = 0;
        private Random rand = new Random();

        private PC_CropEntry() {
        }

        public void setBlockInfo(int id, int metadataMature, int metadataReplant) {
            this.blockID = id;
            this.metaReplant = metadataReplant;
            this.metaMature = metadataMature;
        }

        public void addDropItem(int id, int metaFrom, int metaTo, int countFrom, int countTo, int rarityNumenator, int rarityDenominator, int itemPriority) {
            this.itemId.add(id);
            this.metaStart.add(metaFrom);
            this.metaEnd.add(metaTo);
            this.countStart.add(countFrom);
            this.countEnd.add(countTo);
            this.rarityNum.add(rarityNumenator);
            this.rarityDenom.add(rarityDenominator);
            this.priority.add(itemPriority);
            ++this.itemsCount;
        }

        public boolean canHarvestBlock(int id, int meta) {
            return id == this.blockID && (meta == this.metaMature || this.metaMature < 0);
        }

        public ItemStack[] getHarvestedStacks(int id, int meta) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int priorityTurn = 1; priorityTurn < 20; ++priorityTurn) {
                int itemsOfPriority = 0;
                int itemsDropped = 0;
                for (int i = 0; i < this.itemsCount; ++i) {
                    if (this.priority.get(i) != priorityTurn) continue;
                    ++itemsOfPriority;
                    if (this.rarityDenom.get(i) <= 0 || this.rand.nextInt(this.rarityDenom.get(i)) >= this.rarityNum.get(i)) continue;
                    int stackMeta = this.metaStart.get(i) < 0 ? meta & -this.metaStart.get(i).intValue() : this.metaStart.get(i) + this.rand.nextInt(this.metaEnd.get(i) - this.metaStart.get(i) + 1);
                    int stackCount = this.countStart.get(i) + this.rand.nextInt(this.countEnd.get(i) - this.countStart.get(i) + 1);
                    if (stackMeta < 0 || stackMeta >= 32000 || stackCount <= 0 || Item.itemsList[this.itemId.get(i)] == null) continue;
                    stacks.add(new ItemStack(this.itemId.get(i), stackCount, stackMeta));
                    ++itemsDropped;
                }
                if (itemsOfPriority == 0 || itemsOfPriority > 0 && itemsDropped > 0) break;
            }
            if (stacks.size() == 0) {
                return null;
            }
            return PC_InvUtils.mergeStacks(stacks.toArray(new ItemStack[stacks.size()]));
        }

        public int getReplantMetadata() {
            return this.metaReplant;
        }
    }
}

