/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityReddustFX;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordD;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;

public class PC_EntityLaserParticleFX
extends EntityReddustFX {
    private int part;

    public PC_EntityLaserParticleFX(World par1World, PC_CoordD pos, PC_Color color, PC_CoordI motion, int par) {
        super(par1World, pos.x, pos.y, pos.z, 0.45f, (float)color.r, (float)color.g, (float)color.b);
        this.motionX = 0.04f;
        this.motionZ = 0.04f;
        this.motionY = 0.04f;
        this.motionX *= (double)motion.x;
        this.motionY *= (double)motion.y;
        this.motionZ *= (double)motion.z;
        this.part = par;
        this.noClip = true;
    }

    @Override
    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        super.renderParticle(par1Tessellator, par2, par3, par4, par5, par6, par7);
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.setParticleTextureIndex(7 - this.particleAge * 8 / this.particleMaxAge);
        if (!this.isDead) {
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
        }
        if (this.part == 1) {
            if (this.motionX > 0.0 && this.posX - Math.floor(this.posX) > (double)0.45f) {
                this.setDead();
            }
            if (this.motionX < 0.0 && this.posX - Math.floor(this.posX) < (double)0.55f) {
                this.setDead();
            }
            if (this.motionY > 0.0 && this.posY - Math.floor(this.posY) > (double)0.45f) {
                this.setDead();
            }
            if (this.motionY < 0.0 && this.posY - Math.floor(this.posY) < (double)0.55f) {
                this.setDead();
            }
            if (this.motionZ > 0.0 && this.posZ - Math.floor(this.posZ) > (double)0.45f) {
                this.setDead();
            }
            if (this.motionZ < 0.0 && this.posZ - Math.floor(this.posZ) < (double)0.55f) {
                this.setDead();
            }
        }
    }

    @Override
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    @Override
    public float getBrightness(float par1) {
        return 0.9f;
    }
}

