/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.FontRenderer;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.mod_PCcore;

public class PC_GresButton
extends PC_GresWidget {
    private boolean isClicked = false;

    public PC_GresButton(String label) {
        super(label);
        this.canAddWidget = false;
        this.minSize.setTo(60, 0);
    }

    @Override
    public PC_CoordI calcSize() {
        FontRenderer fontRenderer = this.getFontRenderer();
        this.size.setTo(fontRenderer.getStringWidth(this.text), fontRenderer.FONT_HEIGHT).add(12, 12);
        if (this.size.x < this.minSize.x) {
            this.size.x = this.minSize.x;
        }
        return this.size.copy();
    }

    @Override
    public void calcChildPositions() {
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        int state = !this.enabled ? 0 : (this.isClicked ? 3 : (this.isMouseOver ? 2 : 1));
        int txC = 0xE0E0E0;
        if (state == 0) {
            txC = 0xA0A0A0;
        }
        if (state == 1) {
            txC = 0xE0E0E0;
        }
        if (state > 1) {
            txC = 0xFFFFA0;
        }
        this.renderTextureSliced(offsetPos, mod_PCcore.getImgDir() + "gres/button.png", this.size, new PC_CoordI(0, state * 50), new PC_CoordI(256, 50));
        this.drawCenteredString(this.getFontRenderer(), this.text, offsetPos.x + this.pos.x + this.size.x / 2, offsetPos.y + this.pos.y + (this.size.y - 8) / 2, txC);
    }

    @Override
    public boolean mouseOver(PC_CoordI mpos) {
        this.isMouseOver = true;
        return true;
    }

    @Override
    public boolean mouseClick(PC_CoordI mpos, int key) {
        if (!this.enabled) {
            return false;
        }
        if (this.isClicked && key == -1) {
            this.isClicked = false;
            return true;
        }
        this.isClicked = key != -1;
        return false;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mpos) {
        if (mpos.x < 0 || mpos.x >= this.size.x || mpos.y < 0 || mpos.y >= this.size.y || !this.mouseOver(mpos)) {
            this.isClicked = false;
        }
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public void addedToWidget() {
    }
}

