/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.PC_GresGui;
import net.minecraft.src.PC_IGresGui;
import net.minecraft.src.PCco_GuiCraftingTool;
import net.minecraft.src.Slot;

public class PC_GresContainerManager
extends Container {
    public EntityPlayer thePlayer;
    PC_IGresGui gresGui;
    private static final int playerSlots = 36;
    public Slot[][] inventoryPlayerUpper = new Slot[9][3];
    public Slot[][] inventoryPlayerLower = new Slot[9][1];

    public PC_GresContainerManager(EntityPlayer player) {
        this.thePlayer = player;
        this.gresGui = this.gresGui;
        if (this.thePlayer != null) {
            int i;
            for (i = 0; i < 9; ++i) {
                this.inventoryPlayerLower[i][0] = new Slot(player.inventory, i, -3000, 0);
                this.addSlot(this.inventoryPlayerLower[i][0]);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.inventoryPlayerUpper[i][j] = new Slot(player.inventory, i + j * 9 + 9, -3000, 0);
                    this.addSlot(this.inventoryPlayerUpper[i][j]);
                }
            }
        }
    }

    public void setGresGui(PC_IGresGui gresGui) {
        this.gresGui = gresGui;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public void addSlot(Slot slot) {
        super.addSlot(slot);
    }

    @Override
    protected void retrySlotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
        if (((PC_GresGui)this.gresGui).gui instanceof PCco_GuiCraftingTool) {
            return;
        }
        super.retrySlotClick(par1, par2, par3, par4EntityPlayer);
    }

    @Override
    public ItemStack transferStackInSlot(int slotIndex) {
        if (slotIndex < 36 && !this.gresGui.canShiftTransfer()) {
            return null;
        }
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (slotIndex < 36) {
                if (!this.mergeItemStack(itemstack1, 36, this.inventorySlots.size(), false)) {
                    return null;
                }
                slot.onPickupFromSlot(itemstack);
            } else {
                if (!this.mergeItemStack(itemstack1, 0, 36, false)) {
                    return null;
                }
                slot.onPickupFromSlot(itemstack);
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    public void setSlot(int id, Slot newSlot) {
        if (newSlot != null) {
            this.inventorySlots.set(id, newSlot);
            this.inventoryItemStacks.set(id, null);
            newSlot.slotNumber = id;
        }
    }

    public void removeSlot(int id) {
        int i;
        for (i = id; i < this.inventorySlots.size() - 1; ++i) {
            Slot s = (Slot)this.inventorySlots.get(i + 1);
            if (s != null) {
                s.slotNumber = i;
            }
            this.inventorySlots.set(i, s);
            this.inventoryItemStacks.set(i, this.inventorySlots.get(i + 1));
        }
        if (i < this.inventorySlots.size()) {
            this.inventorySlots.remove(i);
            this.inventoryItemStacks.remove(i);
        }
    }

    private int getLimit(Slot slot, int a, boolean flag) {
        if (flag) {
            return a;
        }
        return Math.min(a, slot.inventory.getInventoryStackLimit());
    }

    @Override
    protected boolean mergeItemStack(ItemStack itemstack, int i, int j, boolean flag) {
        boolean flag1 = false;
        int k = i;
        if (flag) {
            k = j - 1;
        }
        if (itemstack.isStackable()) {
            while (itemstack.stackSize > 0 && (!flag && k < j || flag && k >= i)) {
                Slot slot = (Slot)this.inventorySlots.get(k);
                ItemStack itemstack1 = slot.getStack();
                if (!(itemstack1 == null || !flag && itemstack1.stackSize >= slot.inventory.getInventoryStackLimit() || itemstack1.itemID != itemstack.itemID || itemstack.getHasSubtypes() && itemstack.getItemDamage() != itemstack1.getItemDamage())) {
                    int i1 = itemstack1.stackSize + itemstack.stackSize;
                    if (i1 <= this.getLimit(slot, itemstack.getMaxStackSize(), flag)) {
                        itemstack.stackSize = 0;
                        itemstack1.stackSize = i1;
                        slot.onSlotChanged();
                        flag1 = true;
                    } else if (itemstack1.stackSize < this.getLimit(slot, itemstack.getMaxStackSize(), flag)) {
                        itemstack.stackSize -= this.getLimit(slot, itemstack.getMaxStackSize(), flag) - itemstack1.stackSize;
                        itemstack1.stackSize = this.getLimit(slot, itemstack.getMaxStackSize(), flag);
                        slot.onSlotChanged();
                        flag1 = true;
                    }
                }
                if (flag) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (itemstack.stackSize > 0) {
            int l = flag ? j - 1 : i;
            while (!flag && l < j || flag && l >= i) {
                Slot slot = (Slot)this.inventorySlots.get(l);
                ItemStack itemstack2 = slot.getStack();
                if (itemstack2 == null) {
                    ItemStack toStore = itemstack.copy();
                    toStore.stackSize = this.getLimit(slot, toStore.stackSize, flag);
                    itemstack.stackSize -= toStore.stackSize;
                    slot.putStack(toStore);
                    slot.onSlotChanged();
                    if (itemstack.stackSize <= 0) {
                        flag1 = true;
                        itemstack.stackSize = 0;
                        break;
                    }
                }
                if (flag) {
                    --l;
                    continue;
                }
                ++l;
            }
        }
        return flag1;
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
        this.gresGui.onCraftMatrixChanged(iinventory);
    }
}

