/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.mod_PCcore;

public class PC_GresFrame
extends PC_GresWidget {
    int framePadding = 5;

    @Override
    public PC_CoordI calcSize() {
        this.calcChildPositions();
        if (this.size.x < this.minSize.x + this.framePadding * 2) {
            this.size.x = this.minSize.x + this.framePadding * 2;
        }
        if (this.size.y < this.minSize.y + this.framePadding * 2) {
            this.size.y = this.minSize.y + this.framePadding * 2;
        }
        return this.size.copy();
    }

    @Override
    public void calcChildPositions() {
        PC_CoordI csize;
        int xx = 0;
        int xSize = 0;
        for (PC_GresWidget w : this.childs) {
            w.calcChildPositions();
            csize = w.calcSize();
            if (csize.x + xSize + this.framePadding * 2 > this.size.x || csize.y > this.size.y) {
                if (csize.x + xSize + this.framePadding * 2 > this.size.x) {
                    this.size.x = csize.x + xSize + this.framePadding * 2;
                }
                if (csize.y + this.framePadding * 2 > this.size.y) {
                    this.size.y = csize.y + this.framePadding * 2;
                }
                if (this.parent != null) {
                    this.parent.calcChildPositions();
                }
                this.calcChildPositions();
                return;
            }
            xSize += csize.x + this.widgetMargin;
        }
        xSize -= this.widgetMargin;
        for (PC_GresWidget w : this.childs) {
            csize = w.getSize();
            int xPos = 0;
            int yPos = 0;
            switch (this.alignH) {
                case LEFT: {
                    xPos = xx;
                    break;
                }
                case RIGHT: {
                    xPos = this.size.x - xSize + xx;
                    break;
                }
                case CENTER: {
                    xPos = this.size.x / 2 - xSize / 2 + xx;
                    break;
                }
                case STRETCH: {
                    xPos = xx;
                }
            }
            switch (this.alignV) {
                case TOP: {
                    yPos = 0;
                    break;
                }
                case BOTTOM: {
                    yPos = this.size.y - csize.y;
                    break;
                }
                case CENTER: {
                    yPos = this.size.y / 2 - csize.y / 2;
                    break;
                }
                case STRETCH: {
                    yPos = 0;
                    w.setSize(w.getSize().x, this.size.y, false);
                }
            }
            w.setPosition(xPos, yPos);
            xx += csize.x + w.widgetMargin;
        }
    }

    @Override
    protected void render(PC_CoordI mpos) {
        this.renderTextureSliced(mpos, mod_PCcore.getImgDir() + "gres/frame.png", this.size, new PC_CoordI(0, 0), new PC_CoordI(256, 256));
    }

    @Override
    public boolean mouseOver(PC_CoordI mpos) {
        return true;
    }

    @Override
    public boolean mouseClick(PC_CoordI mpos, int key) {
        return false;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mpos) {
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public void addedToWidget() {
    }
}

