/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IInventory;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresInventoryPlayer;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.Slot;
import net.minecraft.src.mod_PCcore;
import org.lwjgl.opengl.GL11;

public class PC_GresInventory
extends PC_GresWidget {
    public Slot[][] slots;
    public int gridWidth = 0;
    public int gridHeight = 0;

    public PC_GresInventory(int width, int height) {
        super(width * 18, height * 18);
        this.gridHeight = height;
        this.gridWidth = width;
        this.canAddWidget = false;
        this.slots = new Slot[this.gridWidth][this.gridHeight];
    }

    public PC_GresInventory(IInventory inventory, int width, int height) {
        super(width * 18, height * 18);
        this.gridHeight = height;
        this.gridWidth = width;
        this.canAddWidget = false;
        this.slots = new Slot[this.gridWidth][this.gridHeight];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                if (i + j * width >= inventory.getSizeInventory()) continue;
                this.setSlot(new Slot(inventory, i + j * width, 0, 0), i, j);
            }
        }
    }

    public PC_GresInventory(IInventory inventory, int slot) {
        super(18, 18);
        this.gridHeight = 1;
        this.gridWidth = 1;
        this.canAddWidget = false;
        this.slots = new Slot[1][1];
        this.setSlot(new Slot(inventory, slot, 0, 0), 0, 0);
    }

    public PC_GresInventory(IInventory inventory, int width, int height, int slotStart, int slotEnd) {
        super(width * 18, height * 18);
        this.gridHeight = height;
        this.gridWidth = width;
        this.canAddWidget = false;
        this.slots = new Slot[this.gridWidth][this.gridHeight];
        block0: for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                if (slotStart + i + j * width > slotEnd) break block0;
                if (slotStart + i + j * width >= inventory.getSizeInventory()) continue;
                this.setSlot(new Slot(inventory, slotStart + i + j * width, 0, 0), i, j);
            }
        }
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public PC_CoordI calcSize() {
        return new PC_CoordI(this.gridWidth * 18, this.gridHeight * 18);
    }

    @Override
    public void calcChildPositions() {
    }

    @Override
    protected void render(PC_CoordI posOffset) {
        String texture = mod_PCcore.getImgDir() + "gres/widgets.png";
        PC_CoordI posOnScrren = this.getPositionOnScreen();
        PC_CoordI widgetPos = null;
        for (PC_GresWidget w = this; w != null; w = w.getParent()) {
            widgetPos = w.getPosition();
        }
        posOnScrren.x -= widgetPos.x;
        posOnScrren.y -= widgetPos.y;
        GL11.glBindTexture((int)3553, (int)PC_GresInventory.mc.renderEngine.getTexture(texture));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                if (this.slots[x][y] != null) {
                    this.slots[x][y].xDisplayPosition = posOnScrren.x + x * 18 + 1;
                    this.slots[x][y].yDisplayPosition = posOnScrren.y + y * 18 + 1;
                }
                this.drawTexturedModalRect(this.pos.x + posOffset.x + x * 18, this.pos.y + posOffset.y + y * 18, 0, 66, 18, 18);
            }
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI mousePos) {
        return true;
    }

    @Override
    public boolean mouseClick(PC_CoordI mousePos, int key) {
        return key != -1;
    }

    @Override
    public void mouseMove(PC_CoordI mousePos) {
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void addedToWidget() {
        if (!(this.containerManager == null || this.parent != null && this.parent instanceof PC_GresInventoryPlayer)) {
            for (int x = 0; x < this.gridWidth; ++x) {
                for (int y = 0; y < this.gridHeight; ++y) {
                    if (this.slots[x][y] == null) continue;
                    this.containerManager.addSlot(this.slots[x][y]);
                }
            }
        }
    }

    public PC_GresInventory setSlot(Slot slot, int x, int y) {
        if (x >= 0 && x < this.slots.length && y >= 0 && y < this.slots[x].length) {
            if (this.containerManager != null) {
                if (this.slots[x][y] == null) {
                    if (slot != null) {
                        this.containerManager.addSlot(slot);
                    }
                } else if (slot == null) {
                    this.containerManager.removeSlot(this.slots[x][y].slotNumber);
                } else {
                    this.containerManager.setSlot(this.slots[x][y].slotNumber, slot);
                }
            }
            this.slots[x][y] = slot;
        }
        return this;
    }

    public Slot getSlot(int x, int y) {
        if (x >= 0 && x < this.slots.length && y >= 0 && y < this.slots[x].length) {
            return this.slots[x][y];
        }
        return null;
    }
}

